/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph.attributes;

import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.NoValueException;
import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.attributes.Attribute;
import java.util.Arrays;
import java.util.Comparator;

public class LongAttribute<T extends KeyedObject>
extends Attribute<T> {
    private LongLongHashtable values;
    private static String attributeType = "LONG_TYPE";

    public LongAttribute(String name, KeyIndexableSet<T> set) {
        super(name, set);
        this.values = new LongLongHashtable(set.size());
    }

    public void setValue(KeyedObject o, long value) {
        this.update();
        this.values.put(o.key(), value);
    }

    public long getValue(KeyedObject o) throws NoValueException {
        return this.values.get(o.key());
    }

    public KeyedObject[] toSortedArray() {
        KeyedObject[] keyedObjects = this.owningSet().toArray();
        Arrays.sort(keyedObjects, new LongComparator());
        return keyedObjects;
    }

    public KeyedObject[] toSortedArray(KeyedObject[] keyedObjects) {
        KeyedObject[] clone = (KeyedObject[])keyedObjects.clone();
        Arrays.sort(clone, new LongComparator());
        return clone;
    }

    @Override
    public String attributeType() {
        return attributeType;
    }

    @Override
    public void clear() {
        this.values.removeAll();
    }

    @Override
    public String getValueAsString(KeyedObject o) {
        try {
            return Long.toString(this.getValue(o));
        }
        catch (NoValueException exc) {
            return "0";
        }
    }

    class LongComparator
    implements Comparator<KeyedObject> {
        LongComparator() {
        }

        @Override
        public int compare(KeyedObject object1, KeyedObject object2) {
            KeyedObject ko1 = object1;
            KeyedObject ko2 = object2;
            long value1 = 0L;
            long value2 = 0L;
            value1 = LongAttribute.this.getValue(ko1);
            try {
                value2 = LongAttribute.this.getValue(ko2);
                if (value1 < value2) {
                    return -1;
                }
                if (value1 > value2) {
                    return 1;
                }
                if (ko1.key() - ko2.key() < 0L) {
                    return -1;
                }
                if (ko1.key() - ko2.key() > 0L) {
                    return 1;
                }
                return 0;
            }
            catch (NoValueException exc2) {
                try {
                    return -1;
                }
                catch (NoValueException exc) {
                    try {
                        value2 = LongAttribute.this.getValue(ko2);
                        return 1;
                    }
                    catch (NoValueException exc22) {
                        if (ko1.key() - ko2.key() < 0L) {
                            return -1;
                        }
                        if (ko1.key() - ko2.key() > 0L) {
                            return 1;
                        }
                        return 0;
                    }
                }
            }
        }
    }
}

