/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import utilities.util.reflection.ReflectionUtilities;

public class MessageLog {
    private static final int MAX_COUNT = 500;
    private List<String> messages = new ArrayList<String>();
    private int maxSize = 500;
    private int count;
    private String statusMsg = "";

    public void copyFrom(MessageLog log) {
        for (String otherMessage : log.messages) {
            this.add(otherMessage);
        }
    }

    public void appendMsg(String message) {
        this.add(message);
    }

    public void appendMsg(String originator, String message) {
        if (originator == null) {
            this.add(message);
        } else {
            this.add(originator + "> " + message);
        }
    }

    public void appendMsg(int lineNum, String message) {
        this.add("Line #" + lineNum + " - " + message);
    }

    public void appendException(Throwable t) {
        String asString = ReflectionUtilities.stackTraceToString((Throwable)t);
        this.add(asString);
    }

    @Deprecated
    public void error(String originator, String message) {
        this.appendMsg(originator, message);
    }

    public boolean hasMessages() {
        return this.count > 0;
    }

    public void clear() {
        this.messages = new ArrayList<String>();
        this.count = 0;
    }

    public void setStatus(String status) {
        this.statusMsg = status;
    }

    public void clearStatus() {
        this.statusMsg = "";
    }

    public String getStatus() {
        return this.statusMsg;
    }

    public String toString() {
        return this.toStringWithWarning();
    }

    public void write(Class<?> owner, String messageHeader) {
        String header = (String)StringUtils.defaultIfBlank((CharSequence)messageHeader, (CharSequence)"Log Messages");
        Msg.info(owner, (Object)(header + "\n" + this.toStringWithWarning()));
    }

    private String toStringWithWarning() {
        StringBuilder output = new StringBuilder();
        if (this.count > this.maxSize) {
            output.append("There were too many messages to display.\n");
            output.append(this.count - this.maxSize).append(" messages have been truncated.\n");
            output.append('\n');
        }
        for (String s : this.messages) {
            output.append(s).append('\n');
        }
        return output.toString();
    }

    private void add(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return;
        }
        if (this.count++ < this.maxSize) {
            this.messages.add(msg);
        }
    }
}

