/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;

public class Algorithms {
    public static <T> IteratorSTL<T> lower_bound(IteratorSTL<T> start, IteratorSTL<T> end, T key) {
        if (!(key instanceof Comparable)) {
            throw new IllegalArgumentException("Element must implement Comparable");
        }
        Comparable comparableKey = (Comparable)key;
        IteratorSTL<T> cur = start.copy();
        while (!cur.equals(end)) {
            int result = comparableKey.compareTo(cur.get());
            if (result <= 0) {
                return cur;
            }
            cur.increment();
        }
        return end;
    }

    public static <T> IteratorSTL<T> upper_bound(IteratorSTL<T> start, IteratorSTL<T> end, T key) {
        if (!(key instanceof Comparable)) {
            throw new IllegalArgumentException("Element must implement Comparable");
        }
        Comparable comparableKey = (Comparable)key;
        IteratorSTL<T> cur = start.copy();
        while (!cur.equals(end)) {
            int result = comparableKey.compareTo(cur.get());
            if (result < 0) {
                return cur;
            }
            cur.increment();
        }
        return end;
    }
}

