/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TriadicCensus {
    public static final String[] TRIAD_NAMES = new String[]{"N/A", "003", "012", "102", "021D", "021U", "021C", "111D", "111U", "030T", "030C", "201", "120D", "120U", "120C", "210", "300"};
    public static final int MAX_TRIADS = TRIAD_NAMES.length;
    protected static final int[] codeToType = new int[]{1, 2, 2, 3, 2, 4, 6, 8, 2, 6, 5, 7, 3, 8, 7, 11, 2, 6, 4, 8, 5, 9, 9, 13, 6, 10, 9, 14, 7, 14, 12, 15, 2, 5, 6, 7, 6, 9, 10, 14, 4, 9, 9, 12, 8, 13, 14, 15, 3, 7, 8, 11, 7, 12, 14, 15, 8, 14, 13, 15, 11, 15, 15, 16};

    public static <V, E> long[] getCounts(DirectedGraph<V, E> g) {
        long[] count = new long[MAX_TRIADS];
        ArrayList id = new ArrayList(g.getVertices());
        for (int i_v = 0; i_v < g.getVertexCount(); ++i_v) {
            Object v = id.get(i_v);
            for (Object u : g.getNeighbors(v)) {
                int triType = -1;
                if (id.indexOf(u) <= i_v) continue;
                HashSet neighbors = new HashSet(g.getNeighbors(u));
                neighbors.addAll(g.getNeighbors(v));
                neighbors.remove(u);
                neighbors.remove(v);
                triType = g.isSuccessor(v, u) && g.isSuccessor(u, v) ? 3 : 2;
                int n = triType;
                count[n] = count[n] + (long)(g.getVertexCount() - neighbors.size() - 2);
                for (Object w : neighbors) {
                    if (!TriadicCensus.shouldCount(g, id, u, v, w)) continue;
                    int n2 = TriadicCensus.triType(TriadicCensus.triCode(g, u, v, w));
                    count[n2] = count[n2] + 1L;
                }
            }
        }
        int sum = 0;
        for (int i = 2; i <= 16; ++i) {
            sum = (int)((long)sum + count[i]);
        }
        int n = g.getVertexCount();
        count[1] = n * (n - 1) * (n - 2) / 6 - sum;
        return count;
    }

    public static <V, E> int triCode(Graph<V, E> g, V u, V v, V w) {
        int i = 0;
        i += TriadicCensus.link(g, v, u) ? 1 : 0;
        i += TriadicCensus.link(g, u, v) ? 2 : 0;
        i += TriadicCensus.link(g, v, w) ? 4 : 0;
        i += TriadicCensus.link(g, w, v) ? 8 : 0;
        i += TriadicCensus.link(g, u, w) ? 16 : 0;
        return i += TriadicCensus.link(g, w, u) ? 32 : 0;
    }

    protected static <V, E> boolean link(Graph<V, E> g, V a, V b) {
        return g.isPredecessor(b, a);
    }

    public static int triType(int triCode) {
        return codeToType[triCode];
    }

    protected static <V, E> boolean shouldCount(Graph<V, E> g, List<V> id, V u, V v, V w) {
        int i_w;
        int i_u = id.indexOf(u);
        if (i_u < (i_w = id.indexOf(w))) {
            return true;
        }
        int i_v = id.indexOf(v);
        return i_v < i_w && i_w < i_u && !g.isNeighbor(w, v);
    }
}

