/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.exceptionhandling.EHESTypeListModel;
import ghidra.app.cmd.data.exceptionhandling.EHIPToStateModel;
import ghidra.app.cmd.data.exceptionhandling.EHTryBlockModel;
import ghidra.app.cmd.data.exceptionhandling.EHUnwindModel;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ImageBaseOffset32DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.UndefinedValueException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.AssertException;

public class EHFunctionInfoModel
extends AbstractCreateDataTypeModel {
    public static final int EH_MAGIC_NUMBER_V1 = 429065504;
    public static final int EH_MAGIC_NUMBER_V2 = 429065505;
    public static final int EH_MAGIC_NUMBER_V3 = 429065506;
    public static final String DATA_TYPE_NAME = "FuncInfo";
    private static final String STRUCTURE_NAME = "_s_FuncInfo";
    private static final int MAGIC_NUMBER_ORDINAL = 0;
    private static final int MAX_STATE_ORDINAL = 1;
    private static final int UNWIND_MAP_ORDINAL = 2;
    private static final int TRY_BLOCK_COUNT_ORDINAL = 3;
    private static final int TRY_BLOCK_MAP_ORDINAL = 4;
    private static final int IP_TO_STATE_COUNT_ORDINAL = 5;
    private static final int IP_TO_STATE_MAP_ORDINAL = 6;
    private int magicNum;
    private int bbtFlags;
    private boolean isV1;
    private boolean isV2;
    private boolean isV3;
    private int dataTypeLength;
    private DataType dataType;
    private EHUnwindModel unwindModel;
    private EHTryBlockModel tryBlockModel;
    private EHIPToStateModel ipToStateModel;
    private EHESTypeListModel esTypeListModel;

    public EHFunctionInfoModel(Program program, Address address, DataValidationOptions validationOptions) {
        super(program, 1, address, validationOptions);
        this.init();
    }

    private void init() {
        int field0 = 0;
        try {
            field0 = this.getMemBuffer().getInt(0);
        }
        catch (MemoryAccessException e) {
            return;
        }
        this.magicNum = field0 & 0x1FFFFFFF;
        this.bbtFlags = field0 >>> 29;
        this.isV1 = this.magicNum == 429065504;
        this.isV2 = this.magicNum == 429065505;
        this.isV3 = this.magicNum == 429065506;
        this.dataTypeLength = this.doGetDataTypeLength();
    }

    @Override
    protected void checkDataType() throws InvalidDataTypeException {
        if (!this.hasValidMagicNum()) {
            throw new InvalidDataTypeException(this.getName() + " @ " + this.getAddress() + " doesn't have a valid magic number.");
        }
    }

    private String getStructureName() {
        return STRUCTURE_NAME;
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    public final int getVersionNumber() {
        if (this.isV3) {
            return 3;
        }
        if (this.isV2) {
            return 2;
        }
        if (this.isV1) {
            return 1;
        }
        return -1;
    }

    private boolean hasValidMagicNum() {
        return this.isV1 || this.isV2 || this.isV3;
    }

    @Override
    protected int getDataTypeLength() {
        return this.dataTypeLength;
    }

    private int doGetDataTypeLength() {
        int additional21;
        int size20;
        if (!this.hasValidMagicNum()) {
            return 0;
        }
        ProgramBasedDataTypeManager dataTypeManager = this.getProgram().getDataTypeManager();
        int intSize = new IntegerDataType((DataTypeManager)dataTypeManager).getLength();
        int uintSize = new UnsignedIntegerDataType((DataTypeManager)dataTypeManager).getLength();
        int ibo32Size = new ImageBaseOffset32DataType((DataTypeManager)dataTypeManager).getLength();
        int defaultPointerSize = this.getDefaultPointerSize();
        int additional22 = intSize;
        if (this.isRelative()) {
            size20 = uintSize * 3 + intSize + ibo32Size * 4;
            additional21 = ibo32Size;
        } else {
            size20 = uintSize * 3 + intSize + defaultPointerSize * 3;
            additional21 = defaultPointerSize;
        }
        if (this.isV1) {
            return size20;
        }
        if (this.isV2) {
            return size20 + additional21;
        }
        if (this.isV3) {
            return size20 + additional21 + additional22;
        }
        return 0;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        if (!this.hasValidMagicNum()) {
            throw new InvalidDataTypeException(this.getName() + " data type must contain a valid magic number, but doesn't at " + this.getAddress() + ".");
        }
        if (this.getUnwindCount() == 0 && this.getTryBlockCount() == 0 && this.getIPToStateCount() == 0) {
            throw new InvalidDataTypeException(this.getName() + " data type doesn't have any map data.");
        }
        if (!this.isValidMap(this.getUnwindCount(), this.getUnwindMapAddress())) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid unwind map.");
        }
        if (!this.isValidMap(this.getTryBlockCount(), this.getTryBlockMapAddress())) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid try block map.");
        }
        if (!this.isValidMap(this.getIPToStateCount(), this.getIPToStateMapAddress())) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid IP to state map.");
        }
        if (this.isV2 || this.isV3) {
            Address esTypeListAddress;
            try {
                esTypeListAddress = this.getESTypeListAddress();
            }
            catch (UndefinedValueException e) {
                throw new AssertException((Throwable)e);
            }
            if (esTypeListAddress != null && !this.isValidMap(1, esTypeListAddress)) {
                throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid type list reference.");
            }
        }
    }

    public void validateCounts(int maxCount) throws InvalidDataTypeException {
        this.checkValidity();
        this.checkEntryCount("unwind", this.getUnwindCount(), maxCount);
        this.checkEntryCount("try block", this.getTryBlockCount(), maxCount);
        this.checkEntryCount("IP to state", this.getIPToStateCount(), maxCount);
    }

    public void validateLocationsInSameBlock() throws InvalidDataTypeException {
        this.checkValidity();
        Memory memory = this.getProgram().getMemory();
        Address funcInfoAddress = this.getAddress();
        MemoryBlock funcInfoBlock = memory.getBlock(funcInfoAddress);
        this.validateInSameBlock(this.getUnwindMapAddress(), "unwind map", memory, funcInfoBlock);
        this.validateInSameBlock(this.getTryBlockMapAddress(), "try block map", memory, funcInfoBlock);
        this.validateInSameBlock(this.getIPToStateMapAddress(), "IP to state map", memory, funcInfoBlock);
        try {
            this.validateInSameBlock(this.getESTypeListAddress(), "ES type list", memory, funcInfoBlock);
        }
        catch (UndefinedValueException undefinedValueException) {
            // empty catch block
        }
    }

    private void validateInSameBlock(Address referenceAddress, String componentName, Memory memory, MemoryBlock funcInfoBlock) throws InvalidDataTypeException {
        MemoryBlock block;
        if (referenceAddress != null && funcInfoBlock != (block = memory.getBlock(referenceAddress))) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " has a " + componentName + " component that refers to an address that is in a different memory block.");
        }
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = this.doGetDataType();
        }
        return this.dataType;
    }

    private DataType doGetDataType() {
        if (!this.hasValidMagicNum()) {
            return null;
        }
        Program program = this.getProgram();
        if (this.dataType == null) {
            boolean isRelative = this.isRelative();
            ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
            CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
            StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)this.getStructureName());
            UnsignedIntegerDataType compDt = new UnsignedIntegerDataType((DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "magicNumber_and_bbtFlags", null);
            compDt = new TypedefDataType(new CategoryPath("/ehdata.h"), "__ehstate_t", (DataType)new IntegerDataType((DataTypeManager)dataTypeManager), (DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "maxState", null);
            if (isRelative) {
                compDt = new ImageBaseOffset32DataType((DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "dispUnwindMap", null);
            } else {
                compDt = new PointerDataType(EHUnwindModel.getDataType(program), (DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "pUnwindMap", null);
            }
            compDt = new UnsignedIntegerDataType((DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "nTryBlocks", null);
            if (isRelative) {
                compDt = new ImageBaseOffset32DataType((DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "dispTryBlockMap", null);
            } else {
                compDt = new PointerDataType(EHTryBlockModel.getDataType(program), (DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "pTryBlockMap", null);
            }
            compDt = new UnsignedIntegerDataType((DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "nIPMapEntries", null);
            if (isRelative) {
                compDt = new ImageBaseOffset32DataType((DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "dispIPToStateMap", null);
            } else {
                compDt = new PointerDataType((DataType)new VoidDataType((DataTypeManager)dataTypeManager), (DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "pIPToStateMap", null);
            }
            if (isRelative) {
                compDt = new IntegerDataType((DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "dispUnwindHelp", null);
            }
            if (this.isV2 || this.isV3) {
                if (isRelative) {
                    compDt = new ImageBaseOffset32DataType((DataTypeManager)dataTypeManager);
                    struct.add((DataType)compDt, "dispESTypeList", null);
                } else {
                    compDt = new PointerDataType(EHESTypeListModel.getDataType(program), (DataTypeManager)dataTypeManager);
                    struct.add((DataType)compDt, "pESTypeList", null);
                }
            }
            if (this.isV3) {
                compDt = new IntegerDataType((DataTypeManager)dataTypeManager);
                struct.add((DataType)compDt, "EHFlags", null);
            }
            TypedefDataType typedef = new TypedefDataType(categoryPath, this.getName(), (DataType)struct, (DataTypeManager)dataTypeManager);
            this.dataType = typedef;
        }
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)this.dataType);
    }

    public int getMagicNumber() throws InvalidDataTypeException {
        this.checkValidity();
        return this.magicNum;
    }

    public int getBbtFlags() throws InvalidDataTypeException {
        this.checkValidity();
        return this.bbtFlags;
    }

    public EHUnwindModel getUnwindModel() throws InvalidDataTypeException {
        this.checkValidity();
        if (this.unwindModel == null) {
            this.unwindModel = new EHUnwindModel(this.getProgram(), this.getUnwindCount(), this.getUnwindMapAddress(), this.validationOptions);
        }
        return this.unwindModel;
    }

    public int getUnwindCount() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getCount(this.getDataType(), 1, this.getMemBuffer());
    }

    public Address getUnwindMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        Address mapAddress = EHDataTypeUtilities.getAddress(this.getDataType(), 2, this.getMemBuffer());
        return this.getAdjustedAddress(mapAddress, this.getUnwindCount());
    }

    public Address getComponentAddressOfUnwindMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getComponentAddress(this.getDataType(), 2, this.getMemBuffer());
    }

    public EHTryBlockModel getTryBlockModel() throws InvalidDataTypeException {
        this.checkValidity();
        if (this.tryBlockModel == null) {
            this.tryBlockModel = new EHTryBlockModel(this.getProgram(), this.getTryBlockCount(), this.getTryBlockMapAddress(), this.validationOptions);
        }
        return this.tryBlockModel;
    }

    public int getTryBlockCount() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getCount(this.getDataType(), 3, this.getMemBuffer());
    }

    public Address getTryBlockMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        Address mapAddress = EHDataTypeUtilities.getAddress(this.getDataType(), 4, this.getMemBuffer());
        return this.getAdjustedAddress(mapAddress, this.getTryBlockCount());
    }

    public Address getComponentAddressOfTryBlockMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getComponentAddress(this.getDataType(), 4, this.getMemBuffer());
    }

    public EHIPToStateModel getIPToStateModel() throws InvalidDataTypeException {
        this.checkValidity();
        if (this.ipToStateModel == null) {
            this.ipToStateModel = new EHIPToStateModel(this.getProgram(), this.getIPToStateCount(), this.getIPToStateMapAddress(), this.validationOptions);
        }
        return this.ipToStateModel;
    }

    public int getIPToStateCount() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getCount(this.getDataType(), 5, this.getMemBuffer());
    }

    public Address getIPToStateMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        Address mapAddress = EHDataTypeUtilities.getAddress(this.getDataType(), 6, this.getMemBuffer());
        return this.getAdjustedAddress(mapAddress, this.getIPToStateCount());
    }

    public Address getComponentAddressOfIPToStateMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getComponentAddress(this.getDataType(), 6, this.getMemBuffer());
    }

    public int getUnwindHelpDisplacement() throws UndefinedValueException, InvalidDataTypeException {
        this.checkValidity();
        if (this.isRelative()) {
            return EHDataTypeUtilities.getCount(this.getDataType(), 7, this.getMemBuffer());
        }
        throw new UndefinedValueException("No UnwindHelp displacement, since it isn't defined for this program.");
    }

    public Address getComponentAddressOfUnwindHelpAddress() throws UndefinedValueException, InvalidDataTypeException {
        this.checkValidity();
        if (this.isRelative()) {
            return EHDataTypeUtilities.getComponentAddress(this.getDataType(), 7, this.getMemBuffer());
        }
        throw new UndefinedValueException("No UnwindHelp address, since it isn't defined for this program.");
    }

    public EHESTypeListModel getESTypeListModel() throws UndefinedValueException, InvalidDataTypeException {
        this.checkValidity();
        if (this.esTypeListModel == null) {
            Address esTypeListAddress = this.getESTypeListAddress();
            if (esTypeListAddress == null) {
                throw new UndefinedValueException("FuncInfo at " + this.getAddress() + " doesn't specify an ESTypeList address.");
            }
            this.esTypeListModel = new EHESTypeListModel(this.getProgram(), esTypeListAddress, this.validationOptions);
        }
        return this.esTypeListModel;
    }

    public Address getESTypeListAddress() throws UndefinedValueException, InvalidDataTypeException {
        this.checkValidity();
        if (this.isV2 || this.isV3) {
            Address refAddress = EHDataTypeUtilities.getAddress(this.getDataType(), this.isRelative() ? 8 : 7, this.getMemBuffer());
            return this.getAdjustedAddress(refAddress, 0);
        }
        throw new UndefinedValueException("No ESTypeList address, since not a version 2 or 3 FuncInfo structure.");
    }

    public Address getComponentAddressOfESTypeListAddress() throws UndefinedValueException, InvalidDataTypeException {
        this.checkValidity();
        if (this.isV2 || this.isV3) {
            return EHDataTypeUtilities.getComponentAddress(this.getDataType(), this.isRelative() ? 8 : 7, this.getMemBuffer());
        }
        throw new UndefinedValueException("No ESTypeList address, since not a version 2 or 3 FuncInfo structure.");
    }

    public int getEHFlags() throws UndefinedValueException, InvalidDataTypeException {
        this.checkValidity();
        if (this.isV3) {
            return EHDataTypeUtilities.getCount(this.getDataType(), this.isRelative() ? 9 : 8, this.getMemBuffer());
        }
        throw new UndefinedValueException("No EH Flags, since not a version 3 FuncInfo structure.");
    }

    public EHTryBlockModel getEHTryBlockModel() {
        try {
            this.checkValidity();
        }
        catch (InvalidDataTypeException e) {
            return null;
        }
        return this.tryBlockModel;
    }

    public EHUnwindModel getEHUnwindModel() {
        try {
            this.checkValidity();
        }
        catch (InvalidDataTypeException e) {
            return null;
        }
        return this.unwindModel;
    }

    public EHIPToStateModel getEHIPToStateModel() {
        try {
            this.checkValidity();
        }
        catch (InvalidDataTypeException e) {
            return null;
        }
        return this.ipToStateModel;
    }

    public EHESTypeListModel getEHESTypeListModel() {
        try {
            this.checkValidity();
        }
        catch (InvalidDataTypeException e) {
            return null;
        }
        return this.esTypeListModel;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EHFunctionInfo\n");
        buffer.append("    Program: " + this.getProgram().getDomainFile().getPathname() + "\n");
        buffer.append("    Address: " + this.getAddress().toString(true) + "\n");
        buffer.append("    fitsInSingleMemoryBlock: " + this.fitsInSingleMemoryBlock() + "\n");
        buffer.append("    isRelative: " + this.isRelative() + "\n");
        buffer.append("    defaultPointerSize: " + this.getDefaultPointerSize() + "\n");
        buffer.append("    magicNum: 0x" + Long.toHexString(this.magicNum) + "\n");
        buffer.append("    bbtFlags: 0x" + Long.toHexString(this.bbtFlags) + "\n");
        DataType dt = this.getDataType();
        if (dt != null) {
            buffer.append("\n" + dt.toString() + "\n");
            if (dt instanceof TypeDef) {
                DataType baseDataType = ((TypeDef)dt).getBaseDataType();
                buffer.append("\n" + baseDataType.toString() + "\n");
            }
        }
        return buffer.toString();
    }
}

