/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.exceptionhandling.EHCatchHandlerModel;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ImageBaseOffset32DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;

public class EHESTypeListModel
extends AbstractCreateDataTypeModel {
    public static final String DATA_TYPE_NAME = "ESTypeList";
    private static final String STRUCTURE_NAME = "_s_ESTypeList";
    private static final int COUNT_ORDINAL = 0;
    private static final int TYPE_ARRAY_ORDINAL = 1;
    private DataType dataType;

    public EHESTypeListModel(Program program, Address esTypeListAddress, DataValidationOptions validationOptions) {
        super(program, 1, esTypeListAddress, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        int handlerTypeCount = this.getHandlerTypeCount();
        Address handlerTypeMapAddress = this.getHandlerTypeMapAddress();
        if (handlerTypeCount == 0 || handlerTypeMapAddress == null || this.isRelative() && this.imageBaseAddress.equals((Object)handlerTypeMapAddress)) {
            throw new InvalidDataTypeException(this.getName() + " data type doesn't have any map data.");
        }
        if (!this.isValidMap(this.getHandlerTypeCount(), this.getHandlerTypeMapAddress())) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid handler type map.");
        }
    }

    public static DataType getDataType(Program program) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean isRelative = EHESTypeListModel.isRelative(program);
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        IntegerDataType compDt = new IntegerDataType((DataTypeManager)dataTypeManager);
        struct.add((DataType)compDt, "nCount", null);
        if (isRelative) {
            compDt = new ImageBaseOffset32DataType((DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "dispTypeArray", null);
        } else {
            compDt = new PointerDataType(EHCatchHandlerModel.getDataType(program), (DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "pTypeArray", null);
        }
        TypedefDataType typeDefDt = new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, (DataTypeManager)dataTypeManager);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)typeDefDt);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = EHESTypeListModel.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    public EHCatchHandlerModel getCatchHandlerModel() throws InvalidDataTypeException {
        this.checkValidity();
        EHCatchHandlerModel catchHandlerModel = new EHCatchHandlerModel(this.getProgram(), this.getHandlerTypeCount(), this.getHandlerTypeMapAddress(), this.validationOptions);
        return catchHandlerModel;
    }

    public int getHandlerTypeCount() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getCount(this.getDataType(), 0, this.getMemBuffer());
    }

    public Address getHandlerTypeMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        Address mapAddress = EHDataTypeUtilities.getAddress(this.getDataType(), 1, this.getMemBuffer());
        return this.getAdjustedAddress(mapAddress, this.getHandlerTypeCount());
    }

    public Address getComponentAddressOfHandlerTypeMapAddress() throws InvalidDataTypeException {
        this.checkValidity();
        return EHDataTypeUtilities.getComponentAddress(this.getDataType(), 1, this.getMemBuffer());
    }
}

