/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledType;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.UndefinedValueException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import mdemangler.MDException;
import mdemangler.MDMangGhidra;
import mdemangler.MDParsableItem;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.complex.MDComplexType;
import mdemangler.datatype.modifier.MDModifierType;
import mdemangler.naming.MDQualifiedName;

public class TypeDescriptorModel
extends AbstractCreateDataTypeModel {
    public static final String DATA_TYPE_NAME = "TypeDescriptor";
    private static final String STRUCTURE_NAME = "TypeDescriptor";
    private static final int VF_TABLE_OR_HASH_ORDINAL = 0;
    private static final int SPARE_ORDINAL = 1;
    private static final int NAME_ORDINAL = 2;
    private DataType dataType;
    private boolean hasVFPointer;
    private String originalTypeName;
    private MDComplexType mdComplexType;
    private boolean hasProcessedName = false;
    private Namespace namespace;

    public TypeDescriptorModel(Program program, Address address, DataValidationOptions validationOptions) {
        super(program, 1, address, validationOptions);
        this.hasVFPointer = TypeDescriptorModel.hasVFPointer(program);
    }

    @Override
    public String getName() {
        return "TypeDescriptor";
    }

    @Override
    protected void checkDataType() throws InvalidDataTypeException {
        if (this.getDataTypeLength() <= 0) {
            throw new InvalidDataTypeException(this.getName() + " @ " + this.getAddress() + " can't determine a null terminated type name.");
        }
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        Memory memory = program.getMemory();
        AddressSetView loadedAndInitializedSet = memory.getLoadedAndInitializedAddressSet();
        Address startAddress = this.getAddress();
        int pointerSize = MSDataTypeUtils.is64Bit((Program)program) ? 8 : 4;
        MSDataTypeUtils.getBytes((Memory)memory, (Address)startAddress, (int)(pointerSize * 2));
        this.checkVfTablePointerComponent(loadedAndInitializedSet);
        this.checkSpareDataComponent(loadedAndInitializedSet);
        this.checkTypeNameComponent();
    }

    private void checkVfTablePointerComponent(AddressSetView loadedAndInitializedSet) throws InvalidDataTypeException {
        try {
            Address vfTableAddress = this.getVFTableAddress();
            if (vfTableAddress == null || !loadedAndInitializedSet.contains(vfTableAddress)) {
                String message = this.getName() + " data type at " + this.getAddress() + " doesn't point to a vfTable address in a loaded and initialized memory block.";
                throw new InvalidDataTypeException(message);
            }
        }
        catch (UndefinedValueException e) {
            throw new InvalidDataTypeException(e.getMessage());
        }
    }

    private void checkSpareDataComponent(AddressSetView loadedAndInitializedSet) throws InvalidDataTypeException {
        try {
            Address spareDataAddress = this.getSpareDataAddress();
            if (spareDataAddress != null && spareDataAddress.getOffset() != 0L && !loadedAndInitializedSet.contains(spareDataAddress)) {
                throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't point to a spare data address in a loaded and initialized memory block.");
            }
        }
        catch (AddressOutOfBoundsException e1) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid reference to spare data.");
        }
    }

    private void checkTypeNameComponent() throws InvalidDataTypeException {
        Program program = this.getProgram();
        Memory memory = program.getMemory();
        Address typeDescriptorAddress = this.getAddress();
        int pointerSize = this.getDefaultPointerSize();
        String typeName = this.doGetTypeName();
        if (typeName == null) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid type name.");
        }
        int nameLength = typeName.length();
        if (nameLength == 0) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid type name.");
        }
        int lengthWithoutAlignPadding = TypeDescriptorModel.getNameOffset(program) + nameLength;
        int mod = lengthWithoutAlignPadding % pointerSize;
        int padSize = mod == 0 ? 0 : pointerSize - mod;
        int paddedLength = lengthWithoutAlignPadding + padSize;
        try {
            MSDataTypeUtils.getBytes((Memory)memory, (Address)typeDescriptorAddress, (int)paddedLength);
        }
        catch (InvalidDataTypeException e) {
            String paddingErrorMessage = this.getName() + " data type at " + this.getAddress() + " doesn't have valid alignment after the vftable name.";
            throw new InvalidDataTypeException(e.getMessage() + "\n" + paddingErrorMessage);
        }
        if (this.containsWhitespace(typeName)) {
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't have a valid type name.");
        }
    }

    private boolean containsWhitespace(String s) {
        int checkLength = s.length();
        if (s.charAt(checkLength - 1) == '\u0000') {
            --checkLength;
        }
        for (int i = 0; i < checkLength; ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    public static DataType getDataType(Program program) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = TypeDescriptorModel.isRelative(program) ? MSDataTypeUtils.getAlignedPack8Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)"TypeDescriptor") : MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)"TypeDescriptor");
        PointerDataType pointerDataType = new PointerDataType((DataType)new VoidDataType((DataTypeManager)dataTypeManager), (DataTypeManager)dataTypeManager);
        boolean hasVFPointer = TypeDescriptorModel.hasVFPointer(program);
        if (hasVFPointer) {
            struct.add((DataType)pointerDataType, "pVFTable", null);
        } else {
            DWordDataType compDt = new DWordDataType((DataTypeManager)dataTypeManager);
            struct.add((DataType)compDt, "hash", null);
        }
        struct.add((DataType)pointerDataType, "spare", null);
        struct.add((DataType)new ArrayDataType((DataType)CharDataType.dataType, 0, -1), "name", null);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)struct);
    }

    private static boolean hasVFPointer(Program program) {
        Address typeInfoVftableAddress = null;
        try {
            typeInfoVftableAddress = RttiUtil.findTypeInfoVftableAddress(program, TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            throw new AssertException((Throwable)e);
        }
        return typeInfoVftableAddress != null;
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = TypeDescriptorModel.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        DumbMemBufferImpl nameMemBuffer;
        int preNameLength;
        Structure struct = (Structure)this.getDataType();
        int totalLength = preNameLength = struct.getLength();
        Address nameAddress = this.getAddress().add((long)preNameLength);
        TerminatedStringDataType terminatedStringDt = new TerminatedStringDataType((DataTypeManager)this.getProgram().getDataTypeManager());
        int nameLength = terminatedStringDt.getLength((MemBuffer)(nameMemBuffer = new DumbMemBufferImpl(this.getMemBuffer().getMemory(), nameAddress)), 16384);
        if (nameLength <= 0) {
            return 0;
        }
        int alignment = this.getAlignment();
        int mod = (totalLength += nameLength) % alignment;
        if (mod != 0) {
            int numAlignBytes = alignment - mod;
            totalLength += numAlignBytes;
        }
        return totalLength;
    }

    @Override
    protected int getAlignment() {
        DataType dt = this.getDataType();
        if (dt != null) {
            return dt.getAlignment();
        }
        return this.isRelative() ? 8 : 4;
    }

    public int getVFTableAddressOffset() {
        return 0;
    }

    public int getSpareDataOffset() {
        return MSDataTypeUtils.is64Bit((Program)this.getProgram()) ? 8 : 4;
    }

    public int getNameOffset() {
        return TypeDescriptorModel.getNameOffset(this.getProgram());
    }

    private static int getNameOffset(Program program) {
        return MSDataTypeUtils.is64Bit((Program)program) ? 16 : 8;
    }

    public Address getVFTableAddress() throws InvalidDataTypeException, UndefinedValueException {
        this.checkValidity();
        if (!this.hasVFPointer) {
            throw new UndefinedValueException("No vf table pointer is defined for this TypeDescriptor model.");
        }
        Address vfTableAddress = EHDataTypeUtilities.getAddress(this.getDataType(), 0, this.getMemBuffer());
        return vfTableAddress.getOffset() != 0L ? vfTableAddress : null;
    }

    public Scalar getHashValue() throws InvalidDataTypeException, UndefinedValueException {
        this.checkValidity();
        if (this.hasVFPointer) {
            throw new UndefinedValueException("No hash value is defined for this TypeDescriptor model.");
        }
        return EHDataTypeUtilities.getScalarValue(this.getDataType(), 0, this.getMemBuffer());
    }

    public Address getSpareDataAddress() throws InvalidDataTypeException {
        this.checkValidity();
        Address spareAddress = EHDataTypeUtilities.getAddress(this.getDataType(), 1, this.getMemBuffer());
        return spareAddress.getOffset() != 0L ? spareAddress : null;
    }

    public String getTypeName() throws InvalidDataTypeException {
        if (this.originalTypeName != null) {
            return this.originalTypeName;
        }
        try {
            this.checkValidity();
        }
        catch (Exception e) {
            this.hasProcessedName = true;
            throw e;
        }
        String typeName = this.doGetTypeName();
        if (typeName == null) {
            throw new InvalidDataTypeException("Can't determine type name for " + this.getName() + " data type at " + this.getAddress() + ".");
        }
        return typeName;
    }

    private String doGetTypeName() throws InvalidDataTypeException {
        DumbMemBufferImpl nameMemBuffer;
        Address nameAddress = this.getComponentAddressOfTypeName();
        if (nameAddress == null) {
            return null;
        }
        Program program = this.getProgram();
        TerminatedStringDataType terminatedStringDt = new TerminatedStringDataType((DataTypeManager)program.getDataTypeManager());
        Object value = terminatedStringDt.getValue((MemBuffer)(nameMemBuffer = new DumbMemBufferImpl(this.getMemBuffer().getMemory(), nameAddress)), SettingsImpl.NO_SETTINGS, 1);
        if (value instanceof String) {
            this.originalTypeName = (String)value;
            if (this.originalTypeName != null) {
                this.mdComplexType = TypeDescriptorModel.getMDComplexType(program, this.originalTypeName);
            }
        }
        this.hasProcessedName = true;
        return this.originalTypeName;
    }

    private boolean hasComplexType() {
        if (!this.hasProcessedName) {
            try {
                this.getTypeName();
            }
            catch (InvalidDataTypeException e) {
                return false;
            }
        }
        return this.mdComplexType != null;
    }

    public String getDemangledTypeDescriptor() {
        return this.hasComplexType() ? this.mdComplexType.toString() : null;
    }

    public String getRefType() {
        return this.hasComplexType() ? this.mdComplexType.getTypeName() : null;
    }

    public String getDescriptorName() {
        if (!this.hasComplexType()) {
            return null;
        }
        MDQualifiedName qualifiedName = this.mdComplexType.getNamespace();
        return qualifiedName.getName();
    }

    public DemangledType getParentNamespace() {
        if (!this.hasComplexType()) {
            return null;
        }
        MDQualifiedName qualifiedName = this.mdComplexType.getNamespace();
        MDMangGhidra demangler = new MDMangGhidra();
        return demangler.processNamespace(qualifiedName);
    }

    public String getDescriptorTypeNamespace() {
        return this.hasComplexType() ? this.mdComplexType.getTypeNamespace() : null;
    }

    public Address getComponentAddressOfTypeName() throws InvalidDataTypeException {
        this.checkValidity();
        DataType dt = this.getDataType();
        if (dt == null) {
            return null;
        }
        Structure struct = (Structure)dt;
        DataTypeComponent nameComponent = struct.getComponent(2);
        int offset = nameComponent.getOffset();
        try {
            Address addressOfName = this.getAddress().add((long)offset);
            return addressOfName;
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
    }

    public static Address getBaseAddress(Program program, Address typeNameAddress) {
        int nameOffset = TypeDescriptorModel.getNameOffset(program);
        try {
            return typeNameAddress.subtractNoWrap((long)nameOffset);
        }
        catch (AddressOverflowException e) {
            return null;
        }
    }

    public void validate(Address expectedVFTableAddress) throws InvalidDataTypeException, UndefinedValueException {
        this.validate();
        Address vfTableAddress = this.getVFTableAddress();
        if (expectedVFTableAddress != null && !expectedVFTableAddress.equals((Object)vfTableAddress)) {
            String message = this.getName() + " data type at " + this.getAddress() + " wouldn't have expected vfTable address of " + expectedVFTableAddress + ".";
            throw new InvalidDataTypeException(message);
        }
    }

    public Namespace getDescriptorAsNamespace() {
        if (this.namespace == null || this.isNamespaceDeleted(this.namespace)) {
            String descriptorName = this.getDescriptorName();
            if (descriptorName == null) {
                return null;
            }
            String demangledSource = this.mdComplexType.toString();
            DemangledType typeNamespace = new DemangledType(this.originalTypeName, demangledSource, descriptorName);
            DemangledType parentNamespace = this.getParentNamespace();
            if (parentNamespace != null) {
                typeNamespace.setNamespace((Demangled)parentNamespace);
            }
            Program program = this.getProgram();
            this.namespace = DemangledObject.createNamespace((Program)program, (Demangled)typeNamespace, (Namespace)program.getGlobalNamespace(), (boolean)false);
        }
        return this.namespace;
    }

    private boolean isNamespaceDeleted(Namespace other) {
        Symbol nsSymbol = other.getSymbol();
        if (nsSymbol == null) {
            return false;
        }
        return nsSymbol.isDeleted();
    }

    private static MDComplexType getMDComplexType(Program program, String mangledString) {
        MDMangGhidra demangler = new MDMangGhidra();
        try {
            MDModifierType modifierType;
            MDType refType;
            MDParsableItem parsableItem = demangler.demangle(mangledString, true);
            if (!(parsableItem instanceof MDDataType)) {
                return null;
            }
            MDDataType mangledDt = (MDDataType)parsableItem;
            if (mangledDt instanceof MDModifierType && (refType = (modifierType = (MDModifierType)mangledDt).getReferencedType()) instanceof MDComplexType) {
                return (MDComplexType)refType;
            }
            return null;
        }
        catch (MDException e) {
            return null;
        }
    }
}

