/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Method;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetSectionContainer;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.AddressRange;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Section", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class JdiModelTargetSection
extends JdiModelTargetObjectImpl
implements TargetMemoryRegion,
TargetSection {
    protected final Method method;
    private AddressRange range;

    public JdiModelTargetSection(JdiModelTargetSectionContainer parent, Method method, boolean isElement) {
        super(parent, method.toString(), method, isElement);
        this.method = method;
        this.range = this.impl.getAddressRange(method);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_module", parent.getClassType(), "_readable", true, "_memory", parent, "_range", this.range), "Initialized");
    }

    public JdiModelTargetSection(JdiModelTargetSectionContainer parent) {
        super(parent);
        this.method = null;
        this.range = this.impl.defaultRange;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_module", parent.getClassType(), "_range", this.range), "Initialized");
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        Object object = this.range = this.method == null ? this.impl.defaultRange : this.impl.getAddressRange(this.method);
        if (this.range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of(), "Initialized");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        if (this.method == null) {
            return "NULL";
        }
        JdiModelTargetReferenceType classType = ((JdiModelTargetSectionContainer)this.parent).getClassType();
        return classType.getName() + ":" + this.method.signature();
    }

    public AddressRange getRange() {
        return this.range;
    }
}

