/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.ReferenceType;
import ghidra.async.AsyncFence;
import ghidra.dbg.jdi.model.JdiModelTargetAttributesContainer;
import ghidra.dbg.jdi.model.JdiModelTargetFieldContainer;
import ghidra.dbg.jdi.model.JdiModelTargetLocationContainer;
import ghidra.dbg.jdi.model.JdiModelTargetMethodContainer;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReference;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReferenceContainer;
import ghidra.dbg.jdi.model.JdiModelTargetSectionContainer;
import ghidra.dbg.jdi.model.JdiModelTargetType;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ReferenceType", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=JdiModelTargetAttributesContainer.class), @TargetAttributeType(type=Object.class)})
public class JdiModelTargetReferenceType
extends JdiModelTargetType
implements TargetModule {
    protected final ReferenceType reftype;
    private long maxInstances = 100L;
    private JdiModelTargetFieldContainer allFields;
    private JdiModelTargetMethodContainer allMethods;
    private JdiModelTargetFieldContainer fields;
    private JdiModelTargetMethodContainer methods;
    private JdiModelTargetObjectReferenceContainer instances;
    private JdiModelTargetObjectReference classObject;
    private JdiModelTargetObjectReference classLoader;
    private JdiModelTargetLocationContainer locations;
    private JdiModelTargetAttributesContainer addedAttributes;
    protected JdiModelTargetSectionContainer sections;

    public JdiModelTargetReferenceType(JdiModelTargetObject parent, ReferenceType reftype, boolean isElement) {
        this(parent, reftype.name(), reftype, isElement);
    }

    public JdiModelTargetReferenceType(JdiModelTargetObject parent, String id, ReferenceType reftype, boolean isElement) {
        super(parent, id, reftype, isElement);
        this.reftype = reftype;
        if (reftype instanceof ClassType) {
            this.sections = new JdiModelTargetSectionContainer(this);
            if (this.sections != null) {
                this.changeAttributes(List.of(), List.of(this.sections), Map.of(), "Initialized");
            }
        }
        Address zero = this.impl.getAddressSpace("ram").getAddress(0L);
        this.changeAttributes(List.of(), List.of(), Map.of("_display", reftype.name(), "_short_display", reftype.name(), "_range", new AddressRangeImpl(zero, zero), "_module_name", reftype.name()), "Initialized");
    }

    private void populateAttributes() {
        HashMap<String, Object> attrs;
        block3: {
            this.addedAttributes = new JdiModelTargetAttributesContainer(this, "Attributes");
            attrs = new HashMap<String, Object>();
            if (this.reftype instanceof ArrayType) {
                return;
            }
            try {
                attrs.put("isAbstract", this.reftype.isAbstract());
                attrs.put("isFinal", this.reftype.isFinal());
                attrs.put("isInitialized", this.reftype.isInitialized());
                attrs.put("isPackagePrivate", this.reftype.isPackagePrivate());
                attrs.put("isPrepared", this.reftype.isPrepared());
                attrs.put("isPrivate", this.reftype.isPrivate());
                attrs.put("isProtected", this.reftype.isProtected());
                attrs.put("isPublic", this.reftype.isPublic());
                attrs.put("isStatic", this.reftype.isStatic());
                attrs.put("isVerified", this.reftype.isVerified());
            }
            catch (Exception e) {
                if (!(e instanceof ClassNotLoadedException)) break block3;
                attrs.put("status", "Class not loaded");
            }
        }
        attrs.put("defaultStratum", this.reftype.defaultStratum());
        attrs.put("availableStata", this.reftype.availableStrata());
        attrs.put("failedToInitialize", this.reftype.failedToInitialize());
        this.addedAttributes.addAttributes(attrs);
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        this.allFields = new JdiModelTargetFieldContainer(this, true);
        this.allMethods = new JdiModelTargetMethodContainer(this, true);
        this.fields = new JdiModelTargetFieldContainer(this, false);
        this.methods = new JdiModelTargetMethodContainer(this, false);
        this.instances = new JdiModelTargetObjectReferenceContainer(this, "Objects", this.reftype.instances(this.maxInstances));
        this.classLoader = this.reftype.classLoader() == null ? null : new JdiModelTargetObjectReference((JdiModelTargetObject)this, this.reftype.classLoader(), false);
        this.classObject = (JdiModelTargetObjectReference)this.getInstance(this.reftype.classObject());
        this.populateAttributes();
        this.changeAttributes(List.of(), List.of(this.allFields, this.allMethods, this.fields, this.methods, this.instances, this.addedAttributes), Map.of("Class Object", this.classObject), "Initialized");
        try {
            this.locations = new JdiModelTargetLocationContainer(this, "Locations", this.reftype.allLineLocations());
            if (this.locations != null) {
                this.changeAttributes(List.of(), List.of(this.locations), Map.of(), "Initialized");
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        if (this.classLoader != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("Class Loader", this.classLoader), "Initialized");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        AsyncFence fence = new AsyncFence();
        return fence.ready();
    }

    @Override
    public String getDisplay() {
        return this.reftype == null ? super.getDisplay() : this.reftype.name();
    }

    public JdiModelTargetMethodContainer getAllMethods() {
        return this.allMethods;
    }
}

