/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.memory;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.memory.MemoryReader;
import ghidra.dbg.memory.MemoryWriter;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CachedMemory
implements MemoryReader,
MemoryWriter {
    private final SemisparseByteArray memory = new SemisparseByteArray();
    private final NavigableMap<UnsignedLong, PendingRead> pendingByLoc = new TreeMap<UnsignedLong, PendingRead>();
    private final MemoryReader reader;
    private final MemoryWriter writer;

    public CachedMemory(MemoryReader reader, MemoryWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public CompletableFuture<Void> writeMemory(long addr, byte[] data) {
        return this.writer.writeMemory(addr, data).thenAccept(__ -> this.memory.putData(addr, data));
    }

    protected synchronized CompletableFuture<Void> waitForReads(long addr, int len) {
        RangeSet undefined = this.memory.getUninitialized(addr, addr + (long)len - 1L);
        AsyncFence fence = new AsyncFence();
        for (Range rng : undefined.asRanges()) {
            this.findPendingOrSchedule((Range<UnsignedLong>)rng, fence);
        }
        return fence.ready();
    }

    protected synchronized void findPendingOrSchedule(Range<UnsignedLong> rng, AsyncFence fence) {
        TreeRangeSet needRequests = TreeRangeSet.create();
        needRequests.add(rng);
        Map.Entry<UnsignedLong, PendingRead> prec = this.pendingByLoc.lowerEntry((UnsignedLong)rng.lowerEndpoint());
        if (prec != null) {
            PendingRead pending = prec.getValue();
            if (!pending.future.isCompletedExceptionally() && rng.isConnected(pending.range)) {
                needRequests.remove(pending.range);
                fence.include(pending.future);
            }
        }
        NavigableMap<UnsignedLong, PendingRead> applicablePending = this.pendingByLoc.subMap((UnsignedLong)rng.lowerEndpoint(), true, (UnsignedLong)rng.upperEndpoint(), rng.upperBoundType() == BoundType.CLOSED);
        for (Map.Entry ent : applicablePending.entrySet()) {
            PendingRead pending = (PendingRead)ent.getValue();
            if (pending.future.isCompletedExceptionally()) continue;
            needRequests.remove(pending.range);
            fence.include(pending.future);
        }
        for (Range needed : needRequests.asRanges()) {
            UnsignedLong lower = (UnsignedLong)needed.lowerEndpoint();
            UnsignedLong upper = needed.upperBoundType() == BoundType.CLOSED ? ((UnsignedLong)needed.upperEndpoint()).plus(UnsignedLong.ONE) : (UnsignedLong)needed.upperEndpoint();
            CompletableFuture<byte[]> futureRead = this.reader.readMemory(lower.longValue(), upper.minus(lower).intValue());
            CompletionStage futureStored = ((CompletableFuture)futureRead.thenAcceptAsync(data -> {
                CachedMemory cachedMemory = this;
                synchronized (cachedMemory) {
                    if (this.pendingByLoc.remove(lower) != null) {
                        this.memory.putData(lower.longValue(), data);
                    }
                }
            })).exceptionally(e -> {
                Msg.error((Object)this, (Object)"Unexpected error caching memory: ", (Throwable)e);
                CachedMemory cachedMemory = this;
                synchronized (cachedMemory) {
                    this.pendingByLoc.remove(lower);
                }
                return (Void)ExceptionUtils.rethrow((Throwable)e);
            });
            this.pendingByLoc.put(lower, new PendingRead(rng, (CompletableFuture<Void>)futureStored));
            fence.include((CompletableFuture)futureStored);
        }
    }

    @Override
    public CompletableFuture<byte[]> readMemory(long addr, int len) {
        AssertionError defaultErr = new AssertionError((Object)"No data available even after a successful read?");
        AtomicReference<AssertionError> exc = new AtomicReference<AssertionError>(defaultErr);
        return this.waitForReads(addr, len).handle((v, e) -> {
            int available = this.memory.contiguousAvailableAfter(addr);
            if (available == 0) {
                if (e == null) {
                    throw new AssertionError((Object)("No data available at " + Long.toUnsignedString(addr, 16) + " even after a successful read?"));
                }
                return (byte[])ExceptionUtils.rethrow((Throwable)e);
            }
            if (e != null && !this.isTimeout((Throwable)e)) {
                Msg.error((Object)this, (Object)("Some reads requested by the cache failed. Returning a partial result: " + exc.get()));
            }
            byte[] result = new byte[Math.min(len, available)];
            this.memory.getData(addr, result);
            return result;
        });
    }

    public void updateMemory(long address, byte[] data) {
        this.memory.putData(address, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<PendingRead> toCancel;
        CachedMemory cachedMemory = this;
        synchronized (cachedMemory) {
            this.memory.clear();
            toCancel = List.copyOf(this.pendingByLoc.values());
            this.pendingByLoc.clear();
        }
        for (PendingRead pendingRead : toCancel) {
            pendingRead.future.cancel(true);
        }
    }

    protected boolean isTimeout(Throwable e) {
        return (e = AsyncUtils.unwrapThrowable((Throwable)e)) instanceof TimeoutException;
    }

    protected static class PendingRead {
        final Range<UnsignedLong> range;
        final CompletableFuture<Void> future;

        protected static Range<UnsignedLong> normalize(Range<UnsignedLong> range) {
            if (range.lowerBoundType() == BoundType.CLOSED) {
                if (range.upperBoundType() == BoundType.OPEN || ((UnsignedLong)range.upperEndpoint()).longValue() == -1L) {
                    return range;
                }
                return Range.closedOpen((Comparable)((UnsignedLong)range.lowerEndpoint()), (Comparable)((UnsignedLong)range.upperEndpoint()).plus(UnsignedLong.ONE));
            }
            assert (((UnsignedLong)range.lowerEndpoint()).longValue() != -1L);
            UnsignedLong lower = ((UnsignedLong)range.lowerEndpoint()).plus(UnsignedLong.ONE);
            if (range.upperBoundType() == BoundType.OPEN || ((UnsignedLong)range.upperEndpoint()).longValue() == -1L) {
                return Range.closed((Comparable)lower, (Comparable)((UnsignedLong)range.upperEndpoint()));
            }
            return Range.closedOpen((Comparable)lower, (Comparable)((UnsignedLong)range.upperEndpoint()).plus(UnsignedLong.ONE));
        }

        protected PendingRead(Range<UnsignedLong> range, CompletableFuture<Void> future) {
            this.range = PendingRead.normalize(range);
            this.future = future;
        }
    }
}

