/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugExceptionFilterInformation;
import agent.dbgeng.dbgeng.DebugFilterInformation;
import agent.dbgeng.dbgeng.DebugSpecificFilterInformation;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import com.sun.jna.platform.win32.WinDef;

public class DbgToggleContinuationCommand
extends AbstractDbgCommand<Void> {
    private int index;
    private DebugControl.DebugFilterContinuationOption optionCont;

    public DbgToggleContinuationCommand(DbgManagerImpl manager, int index, DebugControl.DebugFilterContinuationOption optionCont) {
        super(manager);
        this.index = index;
        this.optionCont = optionCont;
    }

    @Override
    public void invoke() {
        DebugControl control = this.manager.getControl();
        DebugFilterInformation info = control.getNumberEventFilters();
        int nEvents = info.getNumberEvents();
        int nExcs = info.getNumberSpecificExceptions();
        if (this.index < nEvents) {
            DebugSpecificFilterInformation exc = control.getSpecificFilterParameters(0, nEvents);
            DbgEngNative.DEBUG_SPECIFIC_FILTER_PARAMETERS p = exc.getParameter(this.index);
            p.ContinueOption = new WinDef.ULONG((long)this.optionCont.ordinal());
            control.setSpecificFilterParameters(0, nEvents, exc);
        } else {
            DebugExceptionFilterInformation exc = control.getExceptionFilterParameters(nEvents, null, nExcs);
            DbgEngNative.DEBUG_EXCEPTION_FILTER_PARAMETERS p = exc.getParameter(this.index);
            p.ContinueOption = new WinDef.ULONG((long)this.optionCont.ordinal());
            control.setExceptionFilterParameters(nExcs, exc);
        }
    }
}

