/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.UniqueAddressFactory;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionPcodeOverride;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import java.util.List;

public interface InstructionAdapterFromPrototype
extends Instruction {
    default public String getFullString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMnemonicString());
        int n = this.getNumOperands();
        String sep = this.getSeparator(0);
        if (sep != null || n != 0) {
            sb.append(' ');
        }
        if (sep != null) {
            sb.append(sep);
        }
        for (int i = 0; i < n; ++i) {
            sb.append(this.getDefaultOperandRepresentation(i));
            sep = this.getSeparator(i + 1);
            if (sep == null) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    default public String getMnemonicString() {
        return this.getPrototype().getMnemonic(this.getInstructionContext());
    }

    default public int getNumOperands() {
        return this.getPrototype().getNumOperands();
    }

    default public Address getAddress(int opIndex) {
        InstructionContext context;
        if (opIndex < 0) {
            return null;
        }
        InstructionPrototype prototype = this.getPrototype();
        int opType = prototype.getOpType(opIndex, context = this.getInstructionContext());
        if (OperandType.isAddress((int)opType)) {
            return prototype.getAddress(opIndex, context);
        }
        return null;
    }

    default public Scalar getScalar(int opIndex) {
        return this.getPrototype().getScalar(opIndex, this.getInstructionContext());
    }

    default public Register getRegister(int opIndex) {
        return this.getPrototype().getRegister(opIndex, this.getInstructionContext());
    }

    default public Object[] getOpObjects(int opIndex) {
        return this.getPrototype().getOpObjects(opIndex, this.getInstructionContext());
    }

    default public Object[] getInputObjects() {
        return this.getPrototype().getInputObjects(this.getInstructionContext());
    }

    default public Object[] getResultObjects() {
        return this.getPrototype().getResultObjects(this.getInstructionContext());
    }

    default public String getDefaultOperandRepresentation(int opIndex) {
        List<Object> opList = this.getDefaultOperandRepresentationList(opIndex);
        if (opList == null) {
            return "<UNSUPPORTED>";
        }
        StringBuilder sb = new StringBuilder();
        for (Object opElem : opList) {
            if (opElem instanceof Address) {
                Address opAddr = (Address)opElem;
                sb.append("0x");
                sb.append(opAddr.toString(false));
                continue;
            }
            sb.append(opElem.toString());
        }
        return sb.toString();
    }

    default public List<Object> getDefaultOperandRepresentationList(int opIndex) {
        return this.getPrototype().getOpRepresentationList(opIndex, this.getInstructionContext());
    }

    default public String getSeparator(int opIndex) {
        return this.getPrototype().getSeparator(opIndex, this.getInstructionContext());
    }

    default public int getOperandType(int opIndex) {
        return this.getPrototype().getOpType(opIndex, this.getInstructionContext());
    }

    default public RefType getOperandRefType(int opIndex) {
        InstructionPrototype prototype = this.getPrototype();
        Language language = prototype.getLanguage();
        InstructionPcodeOverride override = new InstructionPcodeOverride((Instruction)this);
        UniqueAddressFactory uniqueFactory = new UniqueAddressFactory(language.getAddressFactory(), language);
        return prototype.getOperandRefType(opIndex, this.getInstructionContext(), (PcodeOverride)override, uniqueFactory);
    }

    default public int getDefaultFallThroughOffset() {
        return this.getPrototype().getFallThroughOffset(this.getInstructionContext());
    }

    default public PcodeOp[] getPcode() {
        return this.getPcode(false);
    }

    default public PcodeOp[] getPcode(boolean includeOverrides) {
        if (!includeOverrides) {
            return this.getPrototype().getPcode(this.getInstructionContext(), null, null);
        }
        InstructionPrototype prototype = this.getPrototype();
        Language language = prototype.getLanguage();
        InstructionPcodeOverride override = new InstructionPcodeOverride((Instruction)this);
        UniqueAddressFactory uniqueFactory = new UniqueAddressFactory(language.getAddressFactory(), language);
        return prototype.getPcode(this.getInstructionContext(), (PcodeOverride)override, uniqueFactory);
    }

    default public PcodeOp[] getPcode(int opIndex) {
        return this.getPrototype().getPcode(this.getInstructionContext(), opIndex);
    }

    default public int getDelaySlotDepth() {
        return this.getPrototype().getDelaySlotDepth(this.getInstructionContext());
    }

    default public boolean isInDelaySlot() {
        return this.getPrototype().isInDelaySlot();
    }
}

