/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.symbol.TraceEquate;
import ghidra.trace.model.symbol.TraceEquateOperations;
import ghidra.trace.model.symbol.TraceEquateRegisterSpace;
import ghidra.trace.model.symbol.TraceEquateSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface TraceEquateManager
extends TraceEquateOperations {
    public static void validateName(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty string");
        }
        Pattern whitespace = Pattern.compile("\\s+");
        Matcher matcher = whitespace.matcher(name);
        if (matcher.find()) {
            throw new IllegalArgumentException("name cannot contain whitespace");
        }
    }

    public TraceEquateSpace getEquateSpace(AddressSpace var1, boolean var2);

    public TraceEquateRegisterSpace getEquateRegisterSpace(TraceThread var1, boolean var2);

    public TraceEquateRegisterSpace getEquateRegisterSpace(TraceStackFrame var1, boolean var2);

    public TraceEquate create(String var1, long var2) throws DuplicateNameException, IllegalArgumentException;

    public TraceEquate getByName(String var1);

    public TraceEquate getByKey(long var1);

    public Collection<? extends TraceEquate> getByValue(long var1);

    public Collection<? extends TraceEquate> getAll();
}

