/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.breakpoint;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;

public interface TraceBreakpointManager {
    public TraceBreakpoint addBreakpoint(String var1, Range<Long> var2, AddressRange var3, Collection<TraceThread> var4, Collection<TraceBreakpointKind> var5, boolean var6, String var7) throws DuplicateNameException;

    default public TraceBreakpoint addBreakpoint(String path, Range<Long> lifespan, Address address, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        return this.addBreakpoint(path, lifespan, (AddressRange)new AddressRangeImpl(address, address), threads, kinds, enabled, comment);
    }

    default public TraceBreakpoint placeBreakpoint(String path, long snap, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        return this.addBreakpoint(path, DBTraceUtils.toRange(snap), range, threads, kinds, enabled, comment);
    }

    default public TraceBreakpoint placeBreakpoint(String path, long snap, Address address, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        return this.addBreakpoint(path, DBTraceUtils.toRange(snap), (AddressRange)new AddressRangeImpl(address, address), threads, kinds, enabled, comment);
    }

    public Collection<? extends TraceBreakpoint> getAllBreakpoints();

    public Collection<? extends TraceBreakpoint> getBreakpointsByPath(String var1);

    public TraceBreakpoint getPlacedBreakpointByPath(long var1, String var3);

    public Collection<? extends TraceBreakpoint> getBreakpointsAt(long var1, Address var3);

    public Collection<? extends TraceBreakpoint> getBreakpointsIntersecting(Range<Long> var1, AddressRange var2);
}

