/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.time;

import db.DBRecord;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.time.DBTraceTimeManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceSnapshot
extends DBAnnotatedObject
implements TraceSnapshot {
    protected static final String TABLE_NAME = "Snapshots";
    protected static final String REAL_TIME_COLUMN_NAME = "RealTime";
    protected static final String SCHEDULE_COLUMN_NAME = "Schedule";
    protected static final String DESCRIPTION_COLUMN_NAME = "Description";
    protected static final String THREAD_COLUMN_NAME = "Thread";
    @DBAnnotatedColumn(value="RealTime")
    static DBObjectColumn REAL_TIME_COLUMN;
    @DBAnnotatedColumn(value="Schedule")
    static DBObjectColumn SCHEDULE_COLUMN;
    @DBAnnotatedColumn(value="Description")
    static DBObjectColumn DESCRIPTION_COLUMN;
    @DBAnnotatedColumn(value="Thread")
    static DBObjectColumn THREAD_COLUMN;
    @DBAnnotatedField(column="RealTime")
    long realTime;
    @DBAnnotatedField(column="Schedule", indexed=true)
    String scheduleStr = "";
    @DBAnnotatedField(column="Description")
    String description;
    @DBAnnotatedField(column="Thread")
    long threadKey = -1L;
    public final DBTraceTimeManager manager;
    private DBTraceThread eventThread;
    private TraceSchedule schedule;

    public DBTraceSnapshot(DBTraceTimeManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            this.threadKey = -1L;
            this.scheduleStr = "";
        } else {
            this.eventThread = this.manager.threadManager.getThread(this.threadKey);
            if (!"".equals(this.scheduleStr)) {
                try {
                    this.schedule = TraceSchedule.parse(this.scheduleStr);
                }
                catch (IllegalArgumentException e) {
                    Msg.error((Object)this, (Object)("Could not parse schedule: " + this.schedule), (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        return String.format("<DBTraceSnapshot key=%d, realTime=%d, schedule='%s', description='%s'>", this.key, this.realTime, this.scheduleStr, this.description);
    }

    protected void set(long realTime, String description) {
        this.realTime = realTime;
        this.description = description;
        this.update(REAL_TIME_COLUMN, DESCRIPTION_COLUMN);
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public long getRealTime() {
        return this.realTime;
    }

    @Override
    public void setRealTime(long millis) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.realTime = millis;
            this.update(REAL_TIME_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSnapshotChangeType.CHANGED, null, this));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.description = description;
            this.update(DESCRIPTION_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSnapshotChangeType.CHANGED, null, this));
    }

    @Override
    public TraceThread getEventThread() {
        return this.eventThread;
    }

    @Override
    public void setEventThread(TraceThread thread) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (thread == null) {
                this.eventThread = null;
                this.threadKey = -1L;
            } else {
                this.eventThread = this.manager.threadManager.assertIsMine(thread);
                this.threadKey = thread.getKey();
            }
            this.update(THREAD_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSnapshotChangeType.CHANGED, null, this));
    }

    @Override
    public TraceSchedule getSchedule() {
        return this.schedule;
    }

    @Override
    public String getScheduleString() {
        return this.scheduleStr;
    }

    @Override
    public void setSchedule(TraceSchedule schedule) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.schedule = schedule;
            this.scheduleStr = schedule == null ? "" : schedule.toString();
            this.update(SCHEDULE_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSnapshotChangeType.CHANGED, null, this));
    }

    @Override
    public void delete() {
        this.manager.deleteSnapshot(this);
    }
}

