/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Range;
import db.DBHandle;
import db.DBRecord;
import db.StringField;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.data.DBTraceDataTypeManager;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.DBTraceSpaceKey;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeView;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeWithAddressView;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeWithLocationView;
import ghidra.trace.database.symbol.AbstractDBTraceVariableSymbol;
import ghidra.trace.database.symbol.DBTraceClassSymbol;
import ghidra.trace.database.symbol.DBTraceClassSymbolView;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.symbol.DBTraceFunctionSymbolView;
import ghidra.trace.database.symbol.DBTraceGlobalVariableSymbol;
import ghidra.trace.database.symbol.DBTraceGlobalVariableSymbolView;
import ghidra.trace.database.symbol.DBTraceLabelSymbol;
import ghidra.trace.database.symbol.DBTraceLabelSymbolView;
import ghidra.trace.database.symbol.DBTraceLocalVariableSymbol;
import ghidra.trace.database.symbol.DBTraceLocalVariableSymbolView;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbolView;
import ghidra.trace.database.symbol.DBTraceParameterSymbol;
import ghidra.trace.database.symbol.DBTraceParameterSymbolView;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesNoDuplicatesView;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesView;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesWithAddressNoDuplicatesView;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesWithLocationView;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.symbol.TraceSymbolNoDuplicatesView;
import ghidra.trace.model.symbol.TraceSymbolView;
import ghidra.trace.model.symbol.TraceSymbolWithAddressNoDuplicatesView;
import ghidra.trace.model.symbol.TraceSymbolWithLocationView;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceSymbolManager
implements TraceSymbolManager,
DBTraceManager {
    protected static final byte DEFAULT_CALLING_CONVENTION_ID = -1;
    protected static final byte UNKNOWN_CALLING_CONVENTION_ID = -2;
    protected static final String DEFAULT_CALLING_CONVENTION_NAME = "default";
    protected static final String UNKNOWN_CALLING_CONVENTION_NAME = "unknown";
    private static final long TYPE_MASK = 255L;
    private static final int TYPE_SHIFT = 56;
    private static final long KEY_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int KEY_SHIFT = 0;
    protected final DBTrace trace;
    protected final ReadWriteLock lock;
    protected final DBTraceThreadManager threadManager;
    protected final DBTraceDataTypeManager dataTypeManager;
    protected final DBTraceOverlaySpaceAdapter overlayAdapter;
    protected final DBTraceAddressSnapRangePropertyMap<Long, DBTraceSymbolIDEntry> idMap;
    protected final DBCachedObjectStore<DBTraceCallingConventionEntry> callingConventionStore;
    protected final BiMap<String, Byte> callingConventionMap = HashBiMap.create();
    protected final DBCachedObjectStore<DBTraceFunctionTag> tagStore;
    protected final DBCachedObjectIndex<String, DBTraceFunctionTag> tagsByName;
    protected final DBCachedObjectStore<DBTraceFunctionTagMapping> tagMappingStore;
    protected final DBCachedObjectIndex<Long, DBTraceFunctionTagMapping> tagMappingsByFunc;
    protected final DBCachedObjectIndex<Long, DBTraceFunctionTagMapping> tagMappingsByTag;
    protected final DBCachedObjectStore<DBTraceVariableStorageEntry> storageStore;
    protected final DBCachedObjectIndex<VariableStorage, DBTraceVariableStorageEntry> storageByStorage;
    protected final DBCachedObjectStore<DBTraceLabelSymbol> labelStore;
    protected final DBCachedObjectStore<DBTraceNamespaceSymbol> namespaceStore;
    protected final DBCachedObjectStore<DBTraceClassSymbol> classStore;
    protected final DBCachedObjectStore<DBTraceFunctionSymbol> functionStore;
    protected final DBCachedObjectIndex<Long, DBTraceFunctionSymbol> functionsByThunked;
    protected final DBCachedObjectStore<DBTraceParameterSymbol> parameterStore;
    protected final DBCachedObjectStore<DBTraceLocalVariableSymbol> localVarStore;
    protected final DBCachedObjectStore<DBTraceGlobalVariableSymbol> globalVarStore;
    protected final DBTraceNamespaceSymbol globalNamespace;
    protected final DBTraceLabelSymbolView labels;
    protected final DBTraceNamespaceSymbolView namespaces;
    protected final DBTraceClassSymbolView classes;
    protected final DBTraceFunctionSymbolView functions;
    protected final DBTraceParameterSymbolView parameters;
    protected final DBTraceLocalVariableSymbolView localVars;
    protected final DBTraceGlobalVariableSymbolView globalVars;
    protected final DBTraceSymbolMultipleTypesView<? extends DBTraceNamespaceSymbol> allNamespaces;
    protected final DBTraceSymbolMultipleTypesNoDuplicatesView<? extends DBTraceNamespaceSymbol> uniqueNamespaces;
    protected final DBTraceSymbolMultipleTypesWithAddressNoDuplicatesView<? extends AbstractDBTraceVariableSymbol> allLocals;
    protected final DBTraceSymbolMultipleTypesWithAddressNoDuplicatesView<?> allVariables;
    protected final DBTraceSymbolMultipleTypesWithLocationView<?> labelsAndFunctions;
    protected final DBTraceSymbolMultipleTypesNoDuplicatesView<?> notLabelsNorFunctions;
    protected final DBTraceSymbolMultipleTypesView<?> allSymbols;
    protected final Map<Byte, AbstractDBTraceSymbolSingleTypeView<?>> symbolViews = new HashMap();

    public DBTraceSymbolManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, DBTraceDataTypeManager dataTypeManager, DBTraceOverlaySpaceAdapter overlayAdapter) throws VersionException, IOException {
        this.trace = trace;
        this.lock = lock;
        this.threadManager = threadManager;
        this.dataTypeManager = dataTypeManager;
        this.overlayAdapter = overlayAdapter;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.idMap = new DBTraceAddressSnapRangePropertyMap("SymbolIDs", dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceSymbolIDEntry.class, DBTraceSymbolIDEntry::new);
        this.callingConventionStore = factory.getOrCreateCachedStore("CallingConventions", DBTraceCallingConventionEntry.class, DBTraceCallingConventionEntry::new, true);
        this.loadCallingConventions();
        this.tagStore = factory.getOrCreateCachedStore("FunctionTags", DBTraceFunctionTag.class, (s, r) -> new DBTraceFunctionTag(this, s, r), true);
        this.tagsByName = this.tagStore.getIndex(String.class, DBTraceFunctionTag.NAME_COLUMN);
        this.tagMappingStore = factory.getOrCreateCachedStore("FunctionTagMappings", DBTraceFunctionTagMapping.class, DBTraceFunctionTagMapping::new, true);
        this.tagMappingsByFunc = this.tagMappingStore.getIndex(Long.TYPE, DBTraceFunctionTagMapping.FUNCTION_COLUMN);
        this.tagMappingsByTag = this.tagMappingStore.getIndex(Long.TYPE, DBTraceFunctionTagMapping.TAG_COLUMN);
        this.storageStore = factory.getOrCreateCachedStore("VariableStorage", DBTraceVariableStorageEntry.class, (s, r) -> new DBTraceVariableStorageEntry(this, s, r), true);
        this.storageByStorage = this.storageStore.getIndex(VariableStorage.class, DBTraceVariableStorageEntry.STORAGE_COLUMN);
        this.labelStore = factory.getOrCreateCachedStore("Labels", DBTraceLabelSymbol.class, (s, r) -> new DBTraceLabelSymbol(this, s, r), true);
        this.namespaceStore = factory.getOrCreateCachedStore("Namespaces", DBTraceNamespaceSymbol.class, (s, r) -> new DBTraceNamespaceSymbol(this, s, r), true);
        this.classStore = factory.getOrCreateCachedStore("Classes", DBTraceClassSymbol.class, (s, r) -> new DBTraceClassSymbol(this, s, r), true);
        this.functionStore = factory.getOrCreateCachedStore("Functions", DBTraceFunctionSymbol.class, (s, r) -> new DBTraceFunctionSymbol(this, s, r), true);
        this.functionsByThunked = this.functionStore.getIndex(Long.TYPE, DBTraceFunctionSymbol.THUNKED_COLUMN);
        this.parameterStore = factory.getOrCreateCachedStore("Parameters", DBTraceParameterSymbol.class, (s, r) -> new DBTraceParameterSymbol(this, s, r), true);
        this.localVarStore = factory.getOrCreateCachedStore("LocalVars", DBTraceLocalVariableSymbol.class, (s, r) -> new DBTraceLocalVariableSymbol(this, s, r), true);
        this.globalVarStore = factory.getOrCreateCachedStore("GlobalVars", DBTraceGlobalVariableSymbol.class, (s, r) -> new DBTraceGlobalVariableSymbol(this, s, r), true);
        this.globalNamespace = this.getOrCreateGlobalNamespace();
        this.labels = this.putInMap(new DBTraceLabelSymbolView(this));
        this.namespaces = this.putInMap(new DBTraceNamespaceSymbolView(this));
        this.classes = this.putInMap(new DBTraceClassSymbolView(this));
        this.functions = this.putInMap(new DBTraceFunctionSymbolView(this));
        this.parameters = this.putInMap(new DBTraceParameterSymbolView(this));
        this.localVars = this.putInMap(new DBTraceLocalVariableSymbolView(this));
        this.globalVars = this.putInMap(new DBTraceGlobalVariableSymbolView(this));
        this.allNamespaces = new DBTraceSymbolMultipleTypesView(this, this.namespaces, this.classes, this.functions);
        this.uniqueNamespaces = new DBTraceSymbolMultipleTypesNoDuplicatesView(this, this.namespaces, this.classes);
        this.allLocals = new DBTraceSymbolMultipleTypesWithAddressNoDuplicatesView(this, new AbstractDBTraceSymbolSingleTypeWithAddressView[]{this.parameters, this.localVars});
        this.allVariables = new DBTraceSymbolMultipleTypesWithAddressNoDuplicatesView(this, new AbstractDBTraceSymbolSingleTypeWithAddressView[]{this.parameters, this.localVars, this.globalVars});
        this.labelsAndFunctions = new DBTraceSymbolMultipleTypesWithLocationView(this, new AbstractDBTraceSymbolSingleTypeWithLocationView[]{this.labels, this.functions});
        this.notLabelsNorFunctions = new DBTraceSymbolMultipleTypesNoDuplicatesView(this, this.namespaces, this.classes, this.parameters, this.localVars, this.globalVars);
        this.allSymbols = new DBTraceSymbolMultipleTypesView(this, this.labels, this.namespaces, this.classes, this.functions, this.parameters, this.localVars, this.globalVars);
    }

    protected DataType checkIndirection(VariableStorage s, DataType formal) {
        if (!s.isForcedIndirect()) {
            return formal;
        }
        int ptrSize = s.size();
        if (ptrSize != this.dataTypeManager.getDataOrganization().getPointerSize()) {
            return this.dataTypeManager.getPointer(formal, ptrSize);
        }
        return this.dataTypeManager.getPointer(formal);
    }

    protected <T extends AbstractDBTraceSymbolSingleTypeView<?>> T putInMap(T view) {
        this.symbolViews.put(view.typeID, view);
        return view;
    }

    protected DBTraceNamespaceSymbol getOrCreateGlobalNamespace() {
        DBTraceNamespaceSymbol global = (DBTraceNamespaceSymbol)this.namespaceStore.getObjectAt(0L);
        if (global != null) {
            assert (global.parentID == -1L);
            assert ("Global".equals(global.name));
            return global;
        }
        global = (DBTraceNamespaceSymbol)this.namespaceStore.create(0L);
        global.rawSet("Global", -1L);
        return global;
    }

    protected static long packID(byte typeID, long key) {
        assert ((long)(typeID + 1) <= 255L);
        assert (key <= 0xFFFFFFFFFFFFFFL);
        return ((long)(typeID + 1) & 0xFFL) << 56 | (key & 0xFFFFFFFFFFFFFFL) << 0;
    }

    protected static byte unpackTypeID(long symbolID) {
        return (byte)((symbolID >> 56 & 0xFFL) - 1L);
    }

    protected static long unpackKey(long symbolID) {
        return symbolID >> 0 & 0xFFFFFFFFFFFFFFL;
    }

    protected void loadCallingConventions() {
        for (DBTraceCallingConventionEntry ent : this.callingConventionStore.asMap().values()) {
            this.callingConventionMap.put((Object)ent.name, (Object)((byte)ent.getKey()));
        }
    }

    protected byte doRecordCallingConvention(String name) {
        DBTraceCallingConventionEntry ent = (DBTraceCallingConventionEntry)this.callingConventionStore.create();
        ent.setName(name);
        return (byte)ent.getKey();
    }

    protected byte findOrRecordCallingConvention(String name) {
        return (Byte)this.callingConventionMap.computeIfAbsent((Object)name, this::doRecordCallingConvention);
    }

    protected int findOrRecordVariableStorage(VariableStorage storage) {
        DBTraceVariableStorageEntry entry = (DBTraceVariableStorageEntry)this.storageByStorage.getOne((Object)storage);
        if (entry == null) {
            entry = (DBTraceVariableStorageEntry)this.storageStore.create();
            entry.set(storage);
        }
        return (int)entry.getKey();
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.idMap.invalidateCache(all);
            this.callingConventionStore.invalidateCache();
            this.callingConventionMap.clear();
            this.loadCallingConventions();
            for (AbstractDBTraceSymbolSingleTypeView<?> view : this.symbolViews.values()) {
                view.invalidateCache();
            }
            if (this.globalNamespace.isDeleted()) {
                throw new AssertionError();
            }
        }
    }

    public void replaceDataTypes(long oldID, long newID) {
    }

    protected void assertValidThreadAddress(DBTraceThread thread, Address address) {
        if (thread != null && address.isMemoryAddress()) {
            throw new IllegalArgumentException("Memory addresses cannot be associated with a thread");
        }
        if (thread == null && address.getAddressSpace().isRegisterSpace()) {
            throw new IllegalArgumentException("Register addresses must be associated with a thread");
        }
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public AbstractDBTraceSymbol getSymbolByID(long symbolID) {
        if (symbolID == 0L) {
            return this.globalNamespace;
        }
        byte typeID = DBTraceSymbolManager.unpackTypeID(symbolID);
        AbstractDBTraceSymbolSingleTypeView<?> view = this.symbolViews.get(typeID);
        if (view == null) {
            return null;
        }
        return (AbstractDBTraceSymbol)view.store.getObjectAt(DBTraceSymbolManager.unpackKey(symbolID));
    }

    @Override
    public DBTraceNamespaceSymbol getGlobalNamespace() {
        return this.globalNamespace;
    }

    @Override
    public DBTraceLabelSymbolView labels() {
        return this.labels;
    }

    @Override
    public DBTraceNamespaceSymbolView namespaces() {
        return this.namespaces;
    }

    @Override
    public DBTraceClassSymbolView classes() {
        return this.classes;
    }

    @Override
    public DBTraceFunctionSymbolView functions() {
        return this.functions;
    }

    @Override
    public DBTraceParameterSymbolView parameters() {
        return this.parameters;
    }

    @Override
    public DBTraceLocalVariableSymbolView localVariables() {
        return this.localVars;
    }

    @Override
    public DBTraceGlobalVariableSymbolView globalVariables() {
        return this.globalVars;
    }

    public TraceSymbolView<? extends DBTraceNamespaceSymbol> allNamespaces() {
        return this.allNamespaces;
    }

    public TraceSymbolNoDuplicatesView<? extends DBTraceNamespaceSymbol> uniqueNamespaces() {
        return this.uniqueNamespaces;
    }

    public TraceSymbolWithAddressNoDuplicatesView<? extends AbstractDBTraceVariableSymbol> allLocals() {
        return this.allLocals;
    }

    public TraceSymbolWithAddressNoDuplicatesView<? extends AbstractDBTraceSymbol> allVariables() {
        return this.allVariables;
    }

    public TraceSymbolWithLocationView<? extends AbstractDBTraceSymbol> labelsAndFunctions() {
        return this.labelsAndFunctions;
    }

    public TraceSymbolNoDuplicatesView<? extends AbstractDBTraceSymbol> notLabelsNorFunctions() {
        return this.notLabelsNorFunctions;
    }

    public TraceSymbolView<? extends AbstractDBTraceSymbol> allSymbols() {
        return this.allSymbols;
    }

    public DBTraceNamespaceSymbol checkIsMine(Namespace ns) {
        if (!(ns instanceof DBTraceNamespaceSymbol)) {
            return null;
        }
        DBTraceNamespaceSymbol dbns = (DBTraceNamespaceSymbol)ns;
        if (dbns.manager != this) {
            return null;
        }
        if (dbns.isDeleted()) {
            return null;
        }
        if (this.namespaceStore.contains((DBAnnotatedObject)dbns)) {
            return dbns;
        }
        if (dbns instanceof DBTraceClassSymbol && this.classStore.contains((DBAnnotatedObject)((DBTraceClassSymbol)dbns))) {
            return dbns;
        }
        if (dbns instanceof DBTraceFunctionSymbol && this.functionStore.contains((DBAnnotatedObject)((DBTraceFunctionSymbol)dbns))) {
            return dbns;
        }
        return null;
    }

    public AbstractDBTraceSymbol checkIsMine(Symbol symbol) {
        if (!(symbol instanceof AbstractDBTraceSymbol)) {
            return null;
        }
        AbstractDBTraceSymbol dbSym = (AbstractDBTraceSymbol)symbol;
        if (dbSym.manager != this) {
            return null;
        }
        if (dbSym.isDeleted()) {
            return null;
        }
        long symbolID = dbSym.getID();
        byte tid = DBTraceSymbolManager.unpackTypeID(symbolID);
        AbstractDBTraceSymbolSingleTypeView<?> view = this.symbolViews.get(tid);
        if (view == null) {
            return null;
        }
        if (!view.store.containsKey(DBTraceSymbolManager.unpackKey(symbolID))) {
            return null;
        }
        return dbSym;
    }

    public DBTraceFunctionSymbol checkIsMine(Function function) {
        if (!(function instanceof DBTraceFunctionSymbol)) {
            return null;
        }
        DBTraceFunctionSymbol dbFunc = (DBTraceFunctionSymbol)function;
        if (dbFunc.manager != this) {
            return null;
        }
        if (dbFunc.isDeleted()) {
            return null;
        }
        if (this.functionStore.contains((DBAnnotatedObject)dbFunc)) {
            return dbFunc;
        }
        return null;
    }

    public DBTraceNamespaceSymbol assertIsMine(Namespace ns) {
        DBTraceNamespaceSymbol dbns = this.checkIsMine(ns);
        if (dbns == null) {
            throw new IllegalArgumentException("Given namespace is not in this trace");
        }
        return dbns;
    }

    public AbstractDBTraceSymbol assertIsMine(Symbol symbol) {
        AbstractDBTraceSymbol dbSym = this.checkIsMine(symbol);
        if (dbSym == null) {
            throw new IllegalArgumentException("Given symbol is not in this trace");
        }
        return dbSym;
    }

    public DBTraceFunctionSymbol assertIsMine(Function function) {
        DBTraceFunctionSymbol dbFunc = this.checkIsMine(function);
        if (dbFunc == null) {
            throw new IllegalArgumentException("Given function is not in this trace");
        }
        return dbFunc;
    }

    protected static void assertValidName(String name) throws InvalidInputException {
        if (name == null || name.length() == 0 || !name.matches("\\p{Graph}+")) {
            throw new InvalidInputException(name);
        }
    }

    protected void assertUniqueName(String name, DBTraceNamespaceSymbol parent) throws DuplicateNameException {
        for (AbstractDBTraceSymbol symbol : this.notLabelsNorFunctions.getChildren(parent)) {
            if (!name.equals(symbol.name)) continue;
            throw new DuplicateNameException(name);
        }
    }

    protected boolean doDeleteSymbol(AbstractDBTraceSymbol symbol) {
        byte typeID = symbol.getSymbolType().getID();
        DBTraceThread thread = symbol.getThread();
        AbstractDBTraceSymbol deleted = (AbstractDBTraceSymbol)this.symbolViews.get((Object)Byte.valueOf((byte)typeID)).store.deleteKey(symbol.getKey());
        if (deleted == null) {
            return false;
        }
        if (symbol.getAddress().isMemoryAddress()) {
            this.delID(thread, symbol.getAddress().getAddressSpace(), symbol.getID());
        }
        this.trace.setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, Object>(Trace.TraceSymbolChangeType.DELETED, symbol.getSpace(), symbol, null, null));
        return true;
    }

    protected void putID(Range<Long> lifespan, DBTraceThread thread, Address address, long id) {
        ((DBTraceAddressSnapRangePropertyMapSpace)this.idMap.get(DBTraceSpaceKey.create(address.getAddressSpace(), thread, 0), true)).put(address, lifespan, id);
    }

    protected void putID(Range<Long> lifespan, DBTraceThread thread, AddressRange rng, long id) {
        ((DBTraceAddressSnapRangePropertyMapSpace)this.idMap.get(DBTraceSpaceKey.create(rng.getAddressSpace(), thread, 0), true)).put(rng, lifespan, id);
    }

    protected void delID(DBTraceThread thread, AddressSpace addressSpace, long id) {
        DBTraceAddressSnapRangePropertyMapSpace space = (DBTraceAddressSnapRangePropertyMapSpace)this.idMap.get(DBTraceSpaceKey.create(addressSpace, thread, 0), false);
        if (space == null) {
            return;
        }
        DBCachedObjectIndex byID = space.getUserIndex(Long.TYPE, DBTraceSymbolIDEntry.ID_COLUMN);
        for (DBTraceSymbolIDEntry entry : byID.get((Object)id)) {
            space.deleteData(entry);
        }
    }

    protected void assertNotDuplicate(AbstractDBTraceSymbol exclude, Range<Long> lifespan, DBTraceThread thread, Address address, String name, DBTraceNamespaceSymbol parent) throws DuplicateNameException {
        if (address.isMemoryAddress()) {
            for (AbstractDBTraceSymbol duplicate : this.labelsAndFunctions.getIntersecting(lifespan, thread, (AddressRange)new AddressRangeImpl(address, address), false, true)) {
                if (duplicate == exclude || duplicate.getParentNamespace() != parent || !name.contentEquals(duplicate.getName())) continue;
                throw new DuplicateNameException(name);
            }
        }
        this.assertNotDuplicate(exclude, name, parent);
    }

    protected void assertNotDuplicate(AbstractDBTraceSymbol exclude, String name, DBTraceNamespaceSymbol parent) throws DuplicateNameException {
        for (AbstractDBTraceSymbol duplicate : this.notLabelsNorFunctions.getChildrenNamed(name, parent)) {
            if (duplicate == exclude) continue;
            throw new DuplicateNameException(name);
        }
    }

    @Override
    public Collection<Long> getIDsAdded(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.idMap.getActiveMemorySpaces()) {
            result.addAll(space.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.added(from, to, space.getAddressSpace())).values());
        }
        return result;
    }

    @Override
    public Collection<Long> getIDsRemoved(long from, long to) {
        if (from == to) {
            return Collections.emptySet();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.idMap.getActiveMemorySpaces()) {
            result.addAll(space.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.removed(from, to, space.getAddressSpace())).values());
        }
        return result;
    }

    public static enum MySymbolTypes {
        LABEL{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return true;
            }
        }
        ,
        NO_LIBRARY{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return false;
            }
        }
        ,
        NO_NULL{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return false;
            }
        }
        ,
        NAMESPACE{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return true;
            }
        }
        ,
        CLASS{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return this.isNoFunctionAncestor(parent);
            }
        }
        ,
        FUNCTION{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return this.isNoFunctionAncestor(parent);
            }
        }
        ,
        PARAMETER{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return parent instanceof Function;
            }
        }
        ,
        LOCAL_VAR{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return parent instanceof Function;
            }
        }
        ,
        GLOBAL_VAR{

            @Override
            boolean isValidParent(DBTraceNamespaceSymbol parent) {
                return parent.getSymbolType() == SymbolType.GLOBAL;
            }
        };


        abstract boolean isValidParent(DBTraceNamespaceSymbol var1);

        boolean isNoFunctionAncestor(DBTraceNamespaceSymbol parent) {
            DBTraceNamespaceSymbol p = parent;
            while (p != null) {
                if (p instanceof Function) {
                    return false;
                }
                p = p.parent;
            }
            return true;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceVariableStorageEntry
    extends DBAnnotatedObject {
        static final String TABLE_NAME = "VariableStorage";
        static final String STORAGE_COLUMN_NAME = "Storage";
        @DBAnnotatedColumn(value="Storage")
        static DBObjectColumn STORAGE_COLUMN;
        @DBAnnotatedField(column="Storage", indexed=true, codec=VariableStorageDBFieldCodec.class)
        private VariableStorage storage;
        protected final DBTraceSymbolManager manager;

        public DBTraceVariableStorageEntry(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
            this.manager = manager;
        }

        void set(VariableStorage storage) {
            this.storage = storage;
            this.update(STORAGE_COLUMN);
        }

        public Program getProgram() {
            return this.manager.trace.getProgramView();
        }

        public VariableStorage getStorage() {
            return this.storage;
        }
    }

    public static class VariableStorageDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<VariableStorage, DBTraceVariableStorageEntry, StringField> {
        public VariableStorageDBFieldCodec(Class<DBTraceVariableStorageEntry> objectType, Field field, int column) {
            super(VariableStorage.class, objectType, StringField.class, field, column);
        }

        public void store(VariableStorage value, StringField f) {
            f.setString(value == null ? null : value.getSerializationString());
        }

        protected void doStore(DBTraceVariableStorageEntry obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            VariableStorage value = (VariableStorage)this.getValue(obj);
            record.setString(this.column, value == null ? null : value.getSerializationString());
        }

        protected void doLoad(DBTraceVariableStorageEntry obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            String serial = record.getString(this.column);
            try {
                this.setValue(obj, serial == null ? null : VariableStorage.deserialize((Program)obj.getProgram(), (String)serial));
            }
            catch (InvalidInputException e) {
                throw new AssertionError("Database corruption", e);
            }
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceFunctionTagMapping
    extends DBAnnotatedObject {
        static final String TABLE_NAME = "FunctionTagMappings";
        static final String FUNCTION_COLUMN_NAME = "Function";
        static final String TAG_COLUMN_NAME = "Tag";
        @DBAnnotatedColumn(value="Function")
        static DBObjectColumn FUNCTION_COLUMN;
        @DBAnnotatedColumn(value="Tag")
        static DBObjectColumn TAG_COLUMN;
        @DBAnnotatedField(column="Function", indexed=true)
        private long functionKey;
        @DBAnnotatedField(column="Tag", indexed=true)
        private long tagKey;

        public DBTraceFunctionTagMapping(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        protected void set(DBTraceFunctionSymbol function, DBTraceFunctionTag tag) {
            this.functionKey = function.getKey();
            this.tagKey = tag.getKey();
            this.update(FUNCTION_COLUMN, TAG_COLUMN);
        }

        public long getFunctionKey() {
            return this.functionKey;
        }

        public long getTagKey() {
            return this.tagKey;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceFunctionTag
    extends DBAnnotatedObject
    implements FunctionTag {
        static final String TABLE_NAME = "FunctionTags";
        static final String NAME_COLUMN_NAME = "Name";
        static final String COMMENT_COLUMN_NAME = "Comment";
        @DBAnnotatedColumn(value="Name")
        static DBObjectColumn NAME_COLUMN;
        @DBAnnotatedColumn(value="Comment")
        static DBObjectColumn COMMENT_COLUMN;
        @DBAnnotatedField(column="Name", indexed=true)
        String name;
        @DBAnnotatedField(column="Comment")
        String comment;
        protected final DBTraceSymbolManager manager;

        public DBTraceFunctionTag(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
            this.manager = manager;
        }

        protected void set(String name, String comment) {
            this.name = name;
            this.comment = comment;
            this.update(NAME_COLUMN, COMMENT_COLUMN);
        }

        public int hashCode() {
            return Long.hashCode(this.key);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FunctionTag)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            FunctionTag that = (FunctionTag)obj;
            if (!Objects.equals(this.getName(), that.getName())) {
                return false;
            }
            return Objects.equals(this.getComment(), that.getComment());
        }

        public int compareTo(FunctionTag o) {
            int result = this.getName().compareToIgnoreCase(o.getName());
            if (result != 0) {
                return result;
            }
            result = this.getComment().compareToIgnoreCase(o.getComment());
            if (result != 0) {
                return result;
            }
            return 0;
        }

        public long getId() {
            return this.key;
        }

        public String getName() {
            try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
                String string = this.name;
                return string;
            }
        }

        public String getComment() {
            try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
                String string = this.comment;
                return string;
            }
        }

        public void setName(String name) {
            try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
                this.name = name;
                this.update(NAME_COLUMN);
            }
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionTagChangeType.CHANGED, null, this));
        }

        public void setComment(String comment) {
            try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
                this.comment = comment;
                this.update(COMMENT_COLUMN);
            }
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionTagChangeType.CHANGED, null, this));
        }

        public void delete() {
            try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
                for (DBTraceFunctionTagMapping mapping : this.manager.tagMappingsByTag.get((Object)this.key)) {
                    this.manager.tagMappingStore.delete((DBAnnotatedObject)mapping);
                }
                this.manager.tagStore.delete((DBAnnotatedObject)this);
            }
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionTagChangeType.DELETED, null, this));
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceCallingConventionEntry
    extends DBAnnotatedObject {
        static final String TABLE_NAME = "CallingConventions";
        static final String NAME_COLUMN_NAME = "Name";
        @DBAnnotatedColumn(value="Name")
        static DBObjectColumn NAME_COLUMN;
        @DBAnnotatedField(column="Name")
        String name;

        public DBTraceCallingConventionEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        public void setName(String name) {
            this.name = name;
            this.update(NAME_COLUMN);
        }

        public String getName() {
            return this.name;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceSymbolIDEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<Long> {
        static final String ID_COLUMN_NAME = "ID";
        @DBAnnotatedColumn(value="ID")
        static DBObjectColumn ID_COLUMN;
        @DBAnnotatedField(column="ID", indexed=true)
        long symbolID;

        public DBTraceSymbolIDEntry(DBTraceAddressSnapRangePropertyMapTree<Long, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(Long symbolID) {
            assert (symbolID != null);
            this.symbolID = symbolID;
            this.update(ID_COLUMN);
        }

        protected Long getRecordValue() {
            return this.symbolID;
        }
    }
}

