/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.lifecycle.Unfinished;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.StackVariableComparator;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.database.symbol.AbstractDBTraceVariableSymbol;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.symbol.DBTraceLocalVariableSymbol;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

public class DBTraceFunctionStackFrame
implements StackFrame,
Unfinished {
    protected final DBTraceFunctionSymbol function;
    protected Variable[] variables;
    protected boolean growsNegative;
    protected boolean valid;

    public DBTraceFunctionStackFrame(DBTraceFunctionSymbol function) {
        this.function = function;
        this.growsNegative = function.getTrace().getBaseCompilerSpec().stackGrowsNegative();
        this.valid = false;
    }

    protected synchronized boolean checkIsValid() {
        if (!this.function.isDeleted()) {
            if (!this.valid) {
                this.growsNegative = this.function.getTrace().getBaseCompilerSpec().stackGrowsNegative();
                this.variables = this.function.getVariables(VariableFilter.COMPOUND_STACK_VARIABLE_FILTER);
                Arrays.sort(this.variables, StackVariableComparator.get());
                this.valid = true;
            }
            return true;
        }
        return false;
    }

    public DBTraceFunctionSymbol getFunction() {
        return this.function;
    }

    public int getFrameSize() {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            int n = this.getParameterSize() + this.getLocalSize();
            return n;
        }
    }

    public int getLocalSize() {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            int baseOffset;
            this.checkIsValid();
            Integer base = VariableUtilities.getBaseStackParamOffset((Function)this.function);
            int n = baseOffset = base == null ? 0 : base;
            if (this.growsNegative) {
                if (this.variables.length == 0) {
                    int n2 = baseOffset;
                    return n2;
                }
                Variable v = this.variables[0];
                if (!(v instanceof LocalVariable)) {
                    int n3 = baseOffset;
                    return n3;
                }
                int offset = Math.max(0, (int)v.getLastStorageVarnode().getOffset());
                int n4 = baseOffset - offset;
                return n4;
            }
            if (this.variables.length == 0) {
                int v = -baseOffset;
                return v;
            }
            Variable v = this.variables[this.variables.length - 1];
            if (!(v instanceof LocalVariable)) {
                int offset = -baseOffset;
                return offset;
            }
            Varnode stackVarnode = v.getLastStorageVarnode();
            int len = stackVarnode.getSize();
            int offset = Math.max(0, (int)stackVarnode.getOffset());
            int n5 = offset - baseOffset + len;
            return n5;
        }
    }

    public int getParameterSize() {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            int baseOffset;
            this.checkIsValid();
            Integer base = VariableUtilities.getBaseStackParamOffset((Function)this.function);
            int n = baseOffset = base == null ? 0 : base;
            if (this.growsNegative) {
                if (this.variables.length == 0) {
                    int n2 = 0;
                    return n2;
                }
                Variable v = this.variables[this.variables.length - 1];
                if (!(v instanceof Parameter)) {
                    int n3 = 0;
                    return n3;
                }
                Varnode stackVarnode = v.getLastStorageVarnode();
                int len = stackVarnode.getSize();
                int offset = (int)stackVarnode.getOffset();
                int n4 = offset - baseOffset + len;
                return n4;
            }
            if (this.variables.length == 0) {
                int v = 0;
                return v;
            }
            Variable v = this.variables[0];
            if (!(v instanceof Parameter)) {
                int stackVarnode = 0;
                return stackVarnode;
            }
            int offset = (int)v.getLastStorageVarnode().getOffset();
            int n5 = baseOffset - offset;
            return n5;
        }
    }

    public int getParameterOffset() {
        Integer base = VariableUtilities.getBaseStackParamOffset((Function)this.function);
        return base == null ? 131072 : base;
    }

    public boolean isParameterOffset(int offset) {
        Integer base = VariableUtilities.getBaseStackParamOffset((Function)this.function);
        if (base == null) {
            return false;
        }
        if (this.growsNegative) {
            return offset >= base;
        }
        return offset < base;
    }

    public void setLocalSize(int size) {
        Unfinished.TODO();
    }

    public void setReturnAddressOffset(int offset) {
        this.function.setReturnAddressOffset(offset);
    }

    public int getReturnAddressOffset() {
        return this.function.getReturnAddressOffset();
    }

    public Variable getVariableContaining(int offset) {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            int index = Arrays.binarySearch(this.variables, offset, StackVariableComparator.get());
            if (index >= 0) {
                Variable variable = this.variables[index];
                return variable;
            }
            if ((index = -index - 2) < 0) {
                Variable variable = null;
                return variable;
            }
            Variable var = this.variables[index];
            Varnode stackVarnode = var.getLastStorageVarnode();
            int varOffset = (int)stackVarnode.getOffset();
            if (offset < varOffset + stackVarnode.getSize()) {
                Variable variable = var;
                return variable;
            }
            Variable variable = null;
            return variable;
        }
    }

    public AbstractDBTraceVariableSymbol createVariable(String name, int offset, DataType dataType, SourceType source) throws DuplicateNameException, InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.writeLock());){
            AbstractDBTraceVariableSymbol result;
            this.checkIsValid();
            if (dataType != null) {
                dataType = dataType.clone((DataTypeManager)this.function.getTrace().getDataTypeManager());
            }
            LocalVariableImpl var = new LocalVariableImpl(name, dataType, offset, (Program)this.function.getProgram());
            if (this.isParameterOffset(offset)) {
                int ordinal = this.function.getParameterCount();
                Parameter[] params = this.getParameters();
                if (this.growsNegative) {
                    for (int i = params.length - 1; i >= 0; --i) {
                        Parameter p = params[i];
                        if ((long)offset > p.getLastStorageVarnode().getOffset()) continue;
                        ordinal = p.getOrdinal();
                    }
                } else {
                    for (int i = 0; i < params.length; ++i) {
                        Parameter p = params[i];
                        if ((long)offset > p.getLastStorageVarnode().getOffset()) continue;
                        ordinal = p.getOrdinal();
                    }
                }
                result = this.function.insertParameter(ordinal, (Variable)var, source);
            } else {
                result = this.function.addLocalVariable((Variable)var, source);
            }
            DBTraceLocalVariableSymbol dBTraceLocalVariableSymbol = result;
            return dBTraceLocalVariableSymbol;
        }
    }

    public void clearVariable(int offset) {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.writeLock());){
            this.checkIsValid();
            Variable var = this.getVariableContaining(offset);
            if (var != null) {
                this.function.removeVariable(var);
            }
        }
    }

    public Variable[] getStackVariables() {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            this.checkIsValid();
            Variable[] variableArray = Arrays.copyOf(this.variables, this.variables.length);
            return variableArray;
        }
    }

    public Parameter[] getParameters() {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            this.checkIsValid();
            ArrayList<Parameter> list = new ArrayList<Parameter>();
            for (Variable v : this.variables) {
                if (!(v instanceof Parameter)) continue;
                list.add((Parameter)v);
            }
            Variable[] variableArray = list.toArray(new Parameter[list.size()]);
            return variableArray;
        }
    }

    public LocalVariable[] getLocals() {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            this.checkIsValid();
            ArrayList<LocalVariable> list = new ArrayList<LocalVariable>();
            for (Variable v : this.variables) {
                if (!(v instanceof LocalVariable)) continue;
                list.add((LocalVariable)v);
            }
            Variable[] variableArray = list.toArray(new LocalVariable[list.size()]);
            return variableArray;
        }
    }

    public boolean growsNegative() {
        try (LockHold hold = LockHold.lock((Lock)this.function.manager.lock.readLock());){
            boolean bl = this.growsNegative;
            return bl;
        }
    }

    protected synchronized void invalidate() {
        this.valid = false;
    }
}

