/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import com.google.common.cache.RemovalNotification;
import ghidra.framework.store.LockException;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.LiveMemoryHandler;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.trace.database.memory.DBTraceMemoryManager;
import ghidra.trace.database.memory.DBTraceMemoryRegion;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewMemoryRegionBlock;
import ghidra.trace.database.program.DBTraceProgramViewMemorySpaceBlock;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceProgramViewMemory;
import ghidra.trace.util.MemoryAdapter;
import ghidra.util.MathUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractDBTraceProgramViewMemory
implements TraceProgramViewMemory,
MemoryAdapter {
    protected final DBTraceProgramView program;
    protected final DBTraceMemoryManager memoryManager;
    protected AddressSetView addressSet;
    protected boolean forceFullView = false;
    protected long snap;

    public AbstractDBTraceProgramViewMemory(DBTraceProgramView program) {
        this.program = program;
        this.memoryManager = program.trace.getMemoryManager();
        this.setSnap(program.snap);
    }

    protected void regionBlockRemoved(RemovalNotification<DBTraceMemoryRegion, DBTraceProgramViewMemoryRegionBlock> rn) {
    }

    protected void spaceBlockRemoved(RemovalNotification<AddressSpace, DBTraceProgramViewMemorySpaceBlock> rn) {
    }

    protected abstract void recomputeAddressSet();

    protected void forPhysicalSpaces(Consumer<AddressSpace> consumer) {
        for (AddressSpace space : this.program.getAddressFactory().getAddressSpaces()) {
            if (!space.isMemorySpace() || space.getType() == 7) continue;
            consumer.accept(space);
        }
    }

    protected void computeFullAdddressSet() {
        AddressSet temp = new AddressSet();
        this.forPhysicalSpaces(space -> temp.add(space.getMinAddress(), space.getMaxAddress()));
        this.addressSet = temp;
    }

    @Override
    public void setForceFullView(boolean forceFullView) {
        this.forceFullView = forceFullView;
        if (forceFullView) {
            this.computeFullAdddressSet();
        } else {
            this.recomputeAddressSet();
        }
        this.program.fireObjectRestored();
    }

    @Override
    public boolean isForceFullView() {
        return this.forceFullView;
    }

    void setSnap(long snap) {
        this.snap = snap;
        if (!this.forceFullView) {
            this.recomputeAddressSet();
        }
    }

    @Override
    public TraceProgramView getProgram() {
        return this.program;
    }

    @Override
    public Trace getTrace() {
        return this.program.trace;
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    public synchronized AddressSetView getLoadedAndInitializedAddressSet() {
        return this.addressSet;
    }

    public synchronized AddressSetView getAllInitializedAddressSet() {
        return this.addressSet;
    }

    public synchronized AddressSetView getInitializedAddressSet() {
        return this.addressSet;
    }

    public AddressSetView getExecuteSet() {
        AddressSet result = new AddressSet();
        for (DBTraceMemoryRegion region : this.memoryManager.getRegionsInternal()) {
            if (!region.isExecute() || !this.program.isRegionVisible(region, region.getLifespan())) continue;
            result.add(region.getRange());
        }
        return result;
    }

    public boolean isBigEndian() {
        return this.program.getLanguage().isBigEndian();
    }

    public void setLiveMemoryHandler(LiveMemoryHandler handler) {
        throw new UnsupportedOperationException();
    }

    public LiveMemoryHandler getLiveMemoryHandler() {
        return null;
    }

    public MemoryBlock createInitializedBlock(String name, Address start, InputStream is, long length, TaskMonitor monitor, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createInitializedBlock(String name, Address start, FileBytes fileBytes, long offset, long size, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createInitializedBlock(String name, Address start, long size, byte initialValue, TaskMonitor monitor, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createUninitializedBlock(String name, Address start, long size, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException("All trace memory is initialized");
    }

    public MemoryBlock createBitMappedBlock(String name, Address start, Address mappedAddress, long length, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException("Mapped blocks are not supported in traces");
    }

    public MemoryBlock createByteMappedBlock(String name, Address start, Address mappedAddress, long length, ByteMappingScheme byteMappingScheme, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException("Mapped blocks are not supported in traces");
    }

    public MemoryBlock createBlock(MemoryBlock block, String name, Address start, long length) throws LockException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }

    public void removeBlock(MemoryBlock block, TaskMonitor monitor) throws LockException {
        throw new UnsupportedOperationException();
    }

    public synchronized long getSize() {
        return this.addressSet.getNumAddresses();
    }

    public void moveBlock(MemoryBlock block, Address newStartAddr, TaskMonitor monitor) throws LockException, MemoryBlockException, MemoryConflictException, AddressOverflowException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public void split(MemoryBlock block, Address addr) throws MemoryBlockException, LockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock join(MemoryBlock blockOne, MemoryBlock blockTwo) throws LockException, MemoryBlockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock convertToInitialized(MemoryBlock unitializedBlock, byte initialValue) throws LockException, MemoryBlockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock convertToUninitialized(MemoryBlock itializedBlock) throws MemoryBlockException, NotFoundException, LockException {
        throw new UnsupportedOperationException();
    }

    public Address findBytes(Address addr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        Address endAddr;
        Address startAddr;
        if (forward) {
            startAddr = addr;
            endAddr = this.getMaxAddress();
        } else {
            startAddr = this.getMinAddress();
            endAddr = addr;
        }
        return this.findBytes(startAddr, endAddr, bytes, masks, forward, monitor);
    }

    public Address findBytes(Address startAddr, Address endAddr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        ByteBuffer bufBytes = ByteBuffer.wrap(bytes);
        ByteBuffer bufMasks = masks == null ? null : ByteBuffer.wrap(masks);
        Address minAddr = forward ? startAddr : endAddr;
        Address maxAddr = forward ? endAddr : startAddr;
        Iterator it = this.program.getAddressFactory().getAddressSet(minAddr, maxAddr).iterator(forward);
        while (it.hasNext()) {
            Address found;
            AddressRange range = (AddressRange)it.next();
            DBTraceMemorySpace space = this.memoryManager.getMemorySpace(range.getAddressSpace(), false);
            if (space == null || (found = space.findBytes(this.snap, range, bufBytes, bufMasks, forward, monitor)) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public byte getByte(Address addr) throws MemoryAccessException {
        MemoryBlock block = this.getBlock(addr);
        if (block == null) {
            return 0;
        }
        return block.getByte(addr);
    }

    public int getBytes(Address addr, byte[] dest, int destIndex, int size) throws MemoryAccessException {
        MemoryBlock block = this.getBlock(addr);
        if (block == null) {
            int avail = MathUtilities.unsignedMin((int)Math.max(0, size), (long)addr.getAddressSpace().getMaxAddress().subtract(addr));
            Arrays.fill(dest, destIndex, avail, (byte)0);
            return avail;
        }
        return block.getBytes(addr, dest, destIndex, size);
    }

    @Override
    public void setByte(Address addr, byte value) throws MemoryAccessException {
        DBTraceMemorySpace space = this.memoryManager.getMemorySpace(addr.getAddressSpace(), true);
        if (space.putBytes(this.snap, addr, ByteBuffer.wrap(new byte[]{value})) != 1) {
            throw new MemoryAccessException();
        }
    }

    public void setBytes(Address addr, byte[] source, int sIndex, int size) throws MemoryAccessException {
        DBTraceMemorySpace space = this.memoryManager.getMemorySpace(addr.getAddressSpace(), true);
        if (space.putBytes(this.snap, addr, ByteBuffer.wrap(source, sIndex, size)) != size) {
            throw new MemoryAccessException();
        }
    }

    public FileBytes createFileBytes(String filename, long offset, long size, InputStream is, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public List<FileBytes> getAllFileBytes() {
        return Collections.emptyList();
    }

    public AddressSourceInfo getAddressSourceInfo(Address address) {
        MemoryBlock block = this.getBlock(address);
        return block == null ? null : new AddressSourceInfo((Memory)this, address, block);
    }

    public boolean deleteFileBytes(FileBytes fileBytes) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Address addr) {
        return this.addressSet.contains(addr);
    }

    public boolean contains(Address start, Address end) {
        return this.addressSet.contains(start, end);
    }

    public boolean contains(AddressSetView set) {
        return this.addressSet.contains(set);
    }

    public boolean isEmpty() {
        return this.addressSet.isEmpty();
    }

    public Address getMinAddress() {
        return this.addressSet.getMinAddress();
    }

    public Address getMaxAddress() {
        return this.addressSet.getMaxAddress();
    }

    public int getNumAddressRanges() {
        return this.addressSet.getNumAddressRanges();
    }

    public AddressRangeIterator getAddressRanges() {
        return this.addressSet.getAddressRanges();
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.addressSet.getAddressRanges(forward);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.addressSet.getAddressRanges(start, forward);
    }

    public Iterator<AddressRange> iterator() {
        return this.addressSet.iterator();
    }

    public Iterator<AddressRange> iterator(boolean forward) {
        return this.addressSet.iterator(forward);
    }

    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.addressSet.iterator(start, forward);
    }

    public long getNumAddresses() {
        return this.addressSet.getNumAddresses();
    }

    public AddressIterator getAddresses(boolean forward) {
        return this.addressSet.getAddresses(forward);
    }

    public AddressIterator getAddresses(Address start, boolean forward) {
        return this.addressSet.getAddresses(start, forward);
    }

    public boolean intersects(AddressSetView addrSet) {
        return this.addressSet.intersects(addrSet);
    }

    public boolean intersects(Address start, Address end) {
        return this.addressSet.intersects(start, end);
    }

    public AddressSet intersect(AddressSetView view) {
        return this.addressSet.intersect(view);
    }

    public AddressSet intersectRange(Address start, Address end) {
        return this.addressSet.intersectRange(start, end);
    }

    public AddressSet union(AddressSetView addrSet) {
        return this.addressSet.union(addrSet);
    }

    public AddressSet subtract(AddressSetView addrSet) {
        return this.addressSet.subtract(addrSet);
    }

    public AddressSet xor(AddressSetView addrSet) {
        return this.addressSet.xor(addrSet);
    }

    public boolean hasSameAddresses(AddressSetView view) {
        return this.addressSet.hasSameAddresses(view);
    }

    public AddressRange getFirstRange() {
        return this.addressSet.getFirstRange();
    }

    public AddressRange getLastRange() {
        return this.addressSet.getLastRange();
    }

    public AddressRange getRangeContaining(Address address) {
        return this.addressSet.getRangeContaining(address);
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        return this.addressSet.findFirstAddressInCommon(set);
    }

    protected synchronized void addRange(AddressRange range) {
        if (!this.forceFullView) {
            this.addressSet = this.addressSet.union((AddressSetView)new AddressSet(range));
        }
    }

    protected synchronized void removeRange(AddressRange range) {
        if (!this.forceFullView) {
            this.addressSet = this.addressSet.subtract((AddressSetView)new AddressSet(range));
        }
    }

    protected synchronized void changeRange(AddressRange remove, AddressRange add) {
        if (!this.forceFullView) {
            AddressSet temp = new AddressSet(this.addressSet);
            temp.delete(remove);
            temp.add(add);
            this.addressSet = temp;
        }
    }
}

