/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import generic.NestedIterator;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.CommentHistory;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.model.util.PropertyMap;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.listing.UndefinedDBTraceData;
import ghidra.trace.database.memory.DBTraceMemoryRegion;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.program.DBTraceProgramViewFragment;
import ghidra.trace.database.program.DBTraceProgramViewRootModule;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.AddressSnap;
import ghidra.trace.model.DefaultAddressSnap;
import ghidra.trace.model.Trace;
import ghidra.trace.model.listing.TraceCodeOperations;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.model.map.TracePropertyMap;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceProgramViewListing;
import ghidra.trace.model.symbol.TraceFunctionSymbol;
import ghidra.trace.util.WrappingCodeUnitIterator;
import ghidra.trace.util.WrappingDataIterator;
import ghidra.trace.util.WrappingInstructionIterator;
import ghidra.util.AddressIteratorAdapter;
import ghidra.util.AddressRangeIterators;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.LockHold;
import ghidra.util.MergeSortingIterator;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractDBTraceProgramViewListing
implements TraceProgramViewListing {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String TREE_NAME = "Trace Tree";
    protected final DBTraceProgramView program;
    protected final TraceCodeOperations codeOperations;
    protected final DBTraceProgramViewRootModule rootModule;
    protected final Map<DBTraceMemoryRegion, DBTraceProgramViewFragment> fragmentsByRegion = new HashMap<DBTraceMemoryRegion, DBTraceProgramViewFragment>();
    protected final Map<AddressSnap, UndefinedDBTraceData> undefinedCache = CacheBuilder.newBuilder().removalListener(this::undefinedRemovedFromCache).weakValues().build().asMap();

    public AbstractDBTraceProgramViewListing(DBTraceProgramView program, TraceCodeOperations codeOperations) {
        this.program = program;
        this.codeOperations = codeOperations;
        this.rootModule = new DBTraceProgramViewRootModule(this);
    }

    private void undefinedRemovedFromCache(RemovalNotification<AddressSnap, UndefinedDBTraceData> rn) {
    }

    @Override
    public TraceProgramView getProgram() {
        return this.program;
    }

    @Override
    public Trace getTrace() {
        return this.program.trace;
    }

    @Override
    public long getSnap() {
        return this.program.snap;
    }

    protected <T extends TraceCodeUnit> T getTopCode(Function<Long, T> codeFunc) {
        return (T)this.program.viewport.getTop(s -> {
            TraceCodeUnit cu = (TraceCodeUnit)codeFunc.apply((Long)s);
            if (cu != null && this.program.isCodeVisible(cu, cu.getLifespan())) {
                return cu;
            }
            return null;
        });
    }

    protected TraceCodeUnit orUndef(TraceCodeUnit cu, Address address) {
        if (cu != null) {
            return cu;
        }
        return this.doCreateUndefinedUnit(address);
    }

    protected TraceData orUndefData(TraceData data, Address address) {
        return (TraceData)this.orUndef(data, address);
    }

    protected TraceData reqUndef(TraceCodeUnit cu, Address address) {
        if (cu != null) {
            return null;
        }
        return this.doCreateUndefinedUnit(address);
    }

    protected <T> T next(Iterator<T> it) {
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    protected Comparator<CodeUnit> getUnitComparator(boolean forward) {
        return forward ? (u1, u2) -> u1.getMinAddress().compareTo((Object)u2.getMinAddress()) : (u1, u2) -> -u1.getMinAddress().compareTo((Object)u2.getMinAddress());
    }

    protected <T extends TraceCodeUnit> Iterator<T> getTopCodeIterator(Function<Long, Iterator<T>> iterFunc, boolean forward) {
        return Iterators.filter(this.program.viewport.mergedIterator(iterFunc, this.getUnitComparator(forward)), cu -> this.program.isCodeVisible((TraceCodeUnit)cu, cu.getLifespan()));
    }

    protected AddressSet getAddressSet(Address start, boolean forward) {
        AddressFactory factory = this.program.getAddressFactory();
        AddressSet all = this.program.allAddresses;
        return forward ? factory.getAddressSet(start, all.getMaxAddress()) : factory.getAddressSet(all.getMinAddress(), start);
    }

    protected UndefinedDBTraceData doCreateUndefinedUnit(Address address) {
        return this.undefinedCache.computeIfAbsent(new DefaultAddressSnap(address, this.program.snap), ot -> new DBTraceProgramViewUndefinedData(this.program.trace, this.program.snap, address, null, 0));
    }

    protected Iterator<? extends TraceInstruction> getInstructionIterator(Address start, boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.instructions().get((long)s, start, forward).iterator(), forward);
    }

    protected Iterator<? extends TraceInstruction> getInstructionIterator(AddressSetView set, boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.instructions().get((long)s, set, forward).iterator(), forward);
    }

    protected Iterator<? extends TraceInstruction> getInstructionIterator(boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.instructions().get((long)s, forward).iterator(), forward);
    }

    protected Iterator<? extends TraceData> getDefinedDataIterator(Address start, boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.definedData().get((long)s, start, forward).iterator(), forward);
    }

    protected Iterator<? extends TraceData> getDefinedDataIterator(AddressSetView set, boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.definedData().get((long)s, set, forward).iterator(), forward);
    }

    protected Iterator<? extends TraceData> getDefinedDataIterator(boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.definedData().get((long)s, forward).iterator(), forward);
    }

    protected Iterator<? extends TraceCodeUnit> getDefinedUnitIterator(Address start, boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.definedUnits().get((long)s, start, forward).iterator(), forward);
    }

    protected Iterator<? extends TraceCodeUnit> getDefinedUnitIterator(AddressSetView set, boolean forward) {
        return this.getTopCodeIterator(s -> this.codeOperations.definedUnits().get((long)s, set, forward).iterator(), forward);
    }

    protected Iterator<TraceData> getUndefinedDataIterator(Address start, boolean forward) {
        TraceCodeUnit defUnit;
        AddressSet set = this.getAddressSet(start, forward);
        Address defStart = start;
        if (forward && (defUnit = this.getTopCode(s -> this.codeOperations.definedUnits().getContaining((long)s, start))) != null) {
            defStart = defUnit.getMinAddress();
        }
        Iterator defIter = Iterators.transform(this.getDefinedUnitIterator(defStart, forward), u -> u.getRange());
        AddressRangeIterator undefIter = AddressRangeIterators.subtract((Iterator)set.iterator(forward), (Iterator)defIter, (Address)start, (boolean)forward);
        AddressIteratorAdapter undefAddrIter = new AddressIteratorAdapter((Iterator)undefIter, forward);
        return Iterators.transform((Iterator)undefAddrIter.iterator(), a -> this.doCreateUndefinedUnit((Address)a));
    }

    protected AddressRangeIterator getUndefinedRangeIterator(AddressSetView set, boolean forward) {
        Iterator defIter = Iterators.transform(this.getDefinedUnitIterator(set, forward), u -> u.getRange());
        return AddressRangeIterators.subtract((Iterator)set.iterator(forward), (Iterator)defIter, (Address)(forward ? set.getMinAddress() : set.getMaxAddress()), (boolean)forward);
    }

    protected boolean isUndefinedRange(long snap, AddressRange range) {
        if (this.codeOperations.undefinedData().coversRange((Range<Long>)Range.singleton((Comparable)Long.valueOf(snap)), range)) {
            return true;
        }
        Object minUnit = this.codeOperations.definedUnits().getContaining(snap, range.getMinAddress());
        if (minUnit != null && this.program.isCodeVisible((TraceCodeUnit)minUnit, minUnit.getLifespan())) {
            return false;
        }
        Object maxUnit = this.codeOperations.definedUnits().getContaining(snap, range.getMaxAddress());
        return maxUnit == null || !this.program.isCodeVisible((TraceCodeUnit)maxUnit, maxUnit.getLifespan());
    }

    protected Iterator<TraceData> getUndefinedDataIterator(AddressSetView set, boolean forward) {
        AddressRangeIterator undefIter = this.getUndefinedRangeIterator(set, forward);
        AddressIteratorAdapter undefAddrIter = new AddressIteratorAdapter((Iterator)undefIter, forward);
        return Iterators.transform((Iterator)undefAddrIter.iterator(), a -> this.doCreateUndefinedUnit((Address)a));
    }

    protected Iterator<TraceCodeUnit> getCodeUnitIterator(AddressSetView set, boolean forward) {
        return new MergeSortingIterator(List.of(this.getDefinedUnitIterator(set, forward), this.getUndefinedDataIterator(set, forward)), this.getUnitComparator(forward));
    }

    protected Iterator<TraceCodeUnit> getCodeUnitIterator(Address start, boolean forward) {
        return new MergeSortingIterator(List.of(this.getDefinedUnitIterator(start, forward), this.getUndefinedDataIterator(start, forward)), this.getUnitComparator(forward));
    }

    protected Iterator<TraceCodeUnit> getCodeUnitIterator(boolean forward) {
        AddressSet set = this.program.allAddresses;
        return this.getCodeUnitIterator(forward ? set.getMinAddress() : set.getMaxAddress(), forward);
    }

    protected Iterator<TraceData> getDataIterator(AddressSetView set, boolean forward) {
        return new MergeSortingIterator(List.of(this.getDefinedDataIterator(set, forward), this.getUndefinedDataIterator(set, forward)), this.getUnitComparator(forward));
    }

    protected Iterator<TraceData> getDataIterator(Address start, boolean forward) {
        return new MergeSortingIterator(List.of(this.getDefinedDataIterator(start, forward), this.getUndefinedDataIterator(start, forward)), this.getUnitComparator(forward));
    }

    protected Iterator<TraceData> getDataIterator(boolean forward) {
        AddressSet set = this.program.allAddresses;
        return this.getDataIterator(forward ? set.getMinAddress() : set.getMaxAddress(), forward);
    }

    public CodeUnit getCodeUnitAt(Address addr) {
        CodeUnit containing = this.getCodeUnitContaining(addr);
        if (containing == null) {
            return this.doCreateUndefinedUnit(addr);
        }
        if (!containing.getMinAddress().equals((Object)addr)) {
            return null;
        }
        return containing;
    }

    public CodeUnit getCodeUnitContaining(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            TraceCodeUnit traceCodeUnit = this.orUndef(this.getTopCode(s -> this.codeOperations.definedUnits().getContaining((long)s, addr)), addr);
            return traceCodeUnit;
        }
    }

    public CodeUnit getCodeUnitAfter(Address addr) {
        addr = addr.next();
        try (LockHold hold = this.program.trace.lockRead();){
            CodeUnit codeUnit = addr == null ? null : (CodeUnit)this.next(this.getCodeUnitIterator(addr, true));
            return codeUnit;
        }
    }

    public CodeUnit getCodeUnitBefore(Address addr) {
        addr = addr.previous();
        try (LockHold hold = this.program.trace.lockRead();){
            CodeUnit codeUnit = addr == null ? null : (CodeUnit)this.next(this.getCodeUnitIterator(addr, false));
            return codeUnit;
        }
    }

    public CodeUnitIterator getCodeUnitIterator(String property, boolean forward) {
        if ("INSTRUCTION__GHIDRA_".equals(property)) {
            return new WrappingCodeUnitIterator(this.getInstructionIterator(forward));
        }
        TracePropertyMap<?> map = this.program.trace.getAddressPropertyManager().getPropertyMap(property);
        if (map == null) {
            return new WrappingCodeUnitIterator(Collections.emptyIterator());
        }
        return new WrappingCodeUnitIterator(NestedIterator.start((Iterator)map.getAddressSetView((Range<Long>)Range.singleton((Comparable)Long.valueOf(this.program.snap))).iterator(forward), rng -> this.getTopCodeIterator(s -> this.codeOperations.codeUnits().get((long)s, (AddressRange)rng, forward).iterator(), forward)));
    }

    public CodeUnitIterator getCodeUnitIterator(String property, Address addr, boolean forward) {
        if ("INSTRUCTION__GHIDRA_".equals(property)) {
            return new WrappingCodeUnitIterator(this.getInstructionIterator(addr, forward));
        }
        TracePropertyMap<?> map = this.program.trace.getAddressPropertyManager().getPropertyMap(property);
        if (map == null) {
            return new WrappingCodeUnitIterator(Collections.emptyIterator());
        }
        return new WrappingCodeUnitIterator(NestedIterator.start((Iterator)map.getAddressSetView((Range<Long>)Range.singleton((Comparable)Long.valueOf(this.program.snap))).iterator(addr, forward), rng -> this.getTopCodeIterator(s -> this.codeOperations.codeUnits().get((long)s, (AddressRange)rng, forward).iterator(), forward)));
    }

    public CodeUnitIterator getCodeUnitIterator(String property, AddressSetView addrSet, boolean forward) {
        if ("INSTRUCTION__GHIDRA_".equals(property)) {
            return new WrappingCodeUnitIterator(this.getInstructionIterator(addrSet, forward));
        }
        TracePropertyMap<?> map = this.program.trace.getAddressPropertyManager().getPropertyMap(property);
        if (map == null) {
            return new WrappingCodeUnitIterator(Collections.emptyIterator());
        }
        return new WrappingCodeUnitIterator(NestedIterator.start((Iterator)new IntersectionAddressSetView(map.getAddressSetView((Range<Long>)Range.singleton((Comparable)Long.valueOf(this.program.snap))), addrSet).iterator(forward), rng -> this.getTopCodeIterator(s -> this.codeOperations.codeUnits().get((long)s, (AddressRange)rng, forward).iterator(), forward)));
    }

    protected AddressSetView getCommentAddresses(int commentType, AddressSetView addrSet) {
        return new IntersectionAddressSetView(addrSet, this.program.viewport.unionedAddresses(s -> this.program.trace.getCommentAdapter().getAddressSetView((Range<Long>)Range.singleton((Comparable)s), e -> e.getType() == commentType)));
    }

    protected AddressSetView getCommentAddresses(AddressSetView addrSet) {
        return new IntersectionAddressSetView(addrSet, this.program.viewport.unionedAddresses(s -> this.program.trace.getCommentAdapter().getAddressSetView((Range<Long>)Range.singleton((Comparable)s))));
    }

    public CodeUnitIterator getCommentCodeUnitIterator(int commentType, AddressSetView addrSet) {
        return new WrappingCodeUnitIterator(this.getCodeUnitIterator(this.getCommentAddresses(commentType, addrSet), true));
    }

    public AddressIterator getCommentAddressIterator(int commentType, AddressSetView addrSet, boolean forward) {
        return this.getCommentAddresses(commentType, addrSet).getAddresses(forward);
    }

    public AddressIterator getCommentAddressIterator(AddressSetView addrSet, boolean forward) {
        return this.getCommentAddresses(addrSet).getAddresses(forward);
    }

    public String getComment(int commentType, Address address) {
        try (LockHold hold = this.program.trace.lockRead();){
            String string = this.program.viewport.getTop(s -> this.program.trace.getCommentAdapter().getComment((long)s, address, commentType));
            return string;
        }
    }

    public void setComment(Address address, int commentType, String comment) {
        this.program.trace.getCommentAdapter().setComment((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.program.snap)), address, commentType, comment);
    }

    public CodeUnitIterator getCodeUnits(boolean forward) {
        return new WrappingCodeUnitIterator(this.getCodeUnitIterator(forward));
    }

    public CodeUnitIterator getCodeUnits(Address start, boolean forward) {
        return new WrappingCodeUnitIterator(this.getCodeUnitIterator(start, forward));
    }

    public CodeUnitIterator getCodeUnits(AddressSetView addressSet, boolean forward) {
        return new WrappingCodeUnitIterator(this.getCodeUnitIterator(addressSet, forward));
    }

    public Instruction getInstructionAt(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            Instruction instruction = this.getTopCode(s -> (TraceInstruction)this.codeOperations.instructions().getAt((long)s, addr));
            return instruction;
        }
    }

    public Instruction getInstructionContaining(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            Instruction instruction = this.getTopCode(s -> (TraceInstruction)this.codeOperations.instructions().getContaining((long)s, addr));
            return instruction;
        }
    }

    public Instruction getInstructionAfter(Address addr) {
        addr = addr.next();
        try (LockHold hold = this.program.trace.lockRead();){
            Instruction instruction = addr == null ? null : (Instruction)this.next(this.getInstructionIterator(addr, true));
            return instruction;
        }
    }

    public Instruction getInstructionBefore(Address addr) {
        addr = addr.previous();
        try (LockHold hold = this.program.trace.lockRead();){
            Instruction instruction = addr == null ? null : (Instruction)this.next(this.getInstructionIterator(addr, false));
            return instruction;
        }
    }

    public InstructionIterator getInstructions(boolean forward) {
        return new WrappingInstructionIterator(this.getInstructionIterator(forward));
    }

    public InstructionIterator getInstructions(Address start, boolean forward) {
        return new WrappingInstructionIterator(this.getInstructionIterator(start, forward));
    }

    public InstructionIterator getInstructions(AddressSetView addressSet, boolean forward) {
        return new WrappingInstructionIterator(this.getInstructionIterator(addressSet, forward));
    }

    public Data getDataAt(Address addr) {
        CodeUnit containing = this.getCodeUnitContaining(addr);
        if (containing == null) {
            return this.doCreateUndefinedUnit(addr);
        }
        if (!(containing instanceof Data)) {
            return null;
        }
        if (!containing.getMinAddress().equals((Object)addr)) {
            return null;
        }
        return (Data)containing;
    }

    public Data getDataContaining(Address addr) {
        CodeUnit cu = this.getCodeUnitContaining(addr);
        if (cu instanceof Data) {
            return (Data)cu;
        }
        return null;
    }

    public Data getDataAfter(Address addr) {
        addr = addr.next();
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = addr == null ? null : (Data)this.next(this.getDataIterator(addr, true));
            return data;
        }
    }

    public Data getDataBefore(Address addr) {
        addr = addr.previous();
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = addr == null ? null : (Data)this.next(this.getDataIterator(addr, false));
            return data;
        }
    }

    public DataIterator getData(boolean forward) {
        return new WrappingDataIterator(this.getDataIterator(forward));
    }

    public DataIterator getData(Address start, boolean forward) {
        return new WrappingDataIterator(this.getDataIterator(start, forward));
    }

    public DataIterator getData(AddressSetView addressSet, boolean forward) {
        return new WrappingDataIterator(this.getDataIterator(addressSet, forward));
    }

    public Data getDefinedDataAt(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = this.getTopCode(s -> (TraceData)this.codeOperations.definedData().getAt((long)s, addr));
            return data;
        }
    }

    public Data getDefinedDataContaining(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = this.getTopCode(s -> (TraceData)this.codeOperations.definedData().getContaining((long)s, addr));
            return data;
        }
    }

    public Data getDefinedDataAfter(Address addr) {
        addr = addr.next();
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = addr == null ? null : (Data)this.next(this.getDefinedDataIterator(addr, true));
            return data;
        }
    }

    public Data getDefinedDataBefore(Address addr) {
        addr = addr.previous();
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = addr == null ? null : (Data)this.next(this.getDefinedDataIterator(addr, false));
            return data;
        }
    }

    public DataIterator getDefinedData(boolean forward) {
        return new WrappingDataIterator(this.getDefinedDataIterator(forward));
    }

    public DataIterator getDefinedData(Address start, boolean forward) {
        return new WrappingDataIterator(this.getDefinedDataIterator(start, forward));
    }

    public DataIterator getDefinedData(AddressSetView addressSet, boolean forward) {
        return new WrappingDataIterator(this.getDefinedDataIterator(addressSet, forward));
    }

    public Data getUndefinedDataAt(Address addr) {
        try (LockHold hold = this.program.trace.lockRead();){
            TraceData traceData = this.reqUndef(this.getTopCode(s -> this.codeOperations.definedUnits().getContaining((long)s, addr)), addr);
            return traceData;
        }
    }

    public Data getUndefinedDataAfter(Address addr, TaskMonitor monitor) {
        addr = addr.next();
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = addr == null ? null : (Data)this.next(this.getUndefinedDataIterator(addr, true));
            return data;
        }
    }

    public Data getUndefinedDataBefore(Address addr, TaskMonitor monitor) {
        addr = addr.previous();
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = addr == null ? null : (Data)this.next(this.getUndefinedDataIterator(addr, false));
            return data;
        }
    }

    public Data getFirstUndefinedData(AddressSetView addressSet, TaskMonitor monitor) {
        try (LockHold hold = this.program.trace.lockRead();){
            Data data = this.next(this.getUndefinedDataIterator(addressSet, true));
            return data;
        }
    }

    public AddressSet getUndefinedRanges(AddressSetView set, boolean initializedMemoryOnly, TaskMonitor monitor) throws CancelledException {
        AddressSet result = new AddressSet();
        for (AddressRange range : this.getUndefinedRangeIterator(set, true)) {
            result.add(range);
            monitor.checkCanceled();
        }
        return result;
    }

    public CodeUnit getDefinedCodeUnitAfter(Address addr) {
        addr = addr.next();
        try (LockHold hold = this.program.trace.lockRead();){
            CodeUnit codeUnit = this.next(this.getDefinedUnitIterator(addr, true));
            return codeUnit;
        }
    }

    public CodeUnit getDefinedCodeUnitBefore(Address addr) {
        addr = addr.previous();
        try (LockHold hold = this.program.trace.lockRead();){
            CodeUnit codeUnit = this.next(this.getDefinedUnitIterator(addr, false));
            return codeUnit;
        }
    }

    public DataIterator getCompositeData(boolean forward) {
        return null;
    }

    public DataIterator getCompositeData(Address start, boolean forward) {
        return null;
    }

    public DataIterator getCompositeData(AddressSetView addrSet, boolean forward) {
        return null;
    }

    public Iterator<String> getUserDefinedProperties() {
        return null;
    }

    public void removeUserDefinedProperty(String propertyName) {
    }

    public PropertyMap getPropertyMap(String propertyName) {
        return null;
    }

    public Instruction createInstruction(Address addr, InstructionPrototype prototype, MemBuffer memBuf, ProcessorContextView context) throws CodeUnitInsertionException {
        try (LockHold hold = this.program.trace.lockWrite();){
            TraceInstruction traceInstruction = this.codeOperations.instructions().create((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.program.snap)), addr, prototype, context);
            return traceInstruction;
        }
    }

    public AddressSetView addInstructions(InstructionSet instructionSet, boolean overwrite) throws CodeUnitInsertionException {
        return this.codeOperations.instructions().addInstructionSet((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.program.snap)), instructionSet, overwrite);
    }

    public Data createData(Address addr, DataType dataType, int length) throws CodeUnitInsertionException {
        return this.codeOperations.definedData().create((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.program.snap)), addr, dataType, length);
    }

    public Data createData(Address addr, DataType dataType) throws CodeUnitInsertionException {
        return this.codeOperations.definedData().create((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.program.snap)), addr, dataType);
    }

    public void clearCodeUnits(Address startAddr, Address endAddr, boolean clearContext) {
        try {
            this.clearCodeUnits(startAddr, endAddr, clearContext, TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void clearComments(Address startAddr, Address endAddr) {
        this.program.trace.getCommentAdapter().clearComments((Range<Long>)Range.atLeast((Comparable)Long.valueOf(this.program.snap)), (AddressRange)new AddressRangeImpl(startAddr, endAddr), -1);
    }

    public void clearProperties(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
    }

    public ProgramFragment getFragment(String treeName, Address addr) {
        DBTraceMemoryRegion region = this.program.memory.getTopRegion(s -> this.program.trace.getMemoryManager().getRegionContaining((long)s, addr));
        if (region == null) {
            return null;
        }
        return this.fragmentsByRegion.computeIfAbsent(region, r -> new DBTraceProgramViewFragment(this, (DBTraceMemoryRegion)r));
    }

    public ProgramModule getModule(String treeName, String name) {
        if (TREE_NAME.equals(treeName) && TREE_NAME.equals(name)) {
            return this.rootModule;
        }
        return null;
    }

    public ProgramFragment getFragment(String treeName, String name) {
        DBTraceMemoryRegion region = this.program.memory.getTopRegion(s -> this.program.trace.getMemoryManager().getLiveRegionByPath((long)s, name));
        if (region == null) {
            return null;
        }
        return this.fragmentsByRegion.computeIfAbsent(region, r -> new DBTraceProgramViewFragment(this, (DBTraceMemoryRegion)r));
    }

    public ProgramModule createRootModule(String treeName) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public ProgramModule getRootModule(String treeName) {
        if (TREE_NAME.equals(treeName)) {
            return this.rootModule;
        }
        return null;
    }

    public ProgramModule getRootModule(long treeID) {
        if (treeID == 0L) {
            return this.rootModule;
        }
        return null;
    }

    public ProgramModule getDefaultRootModule() {
        return this.rootModule;
    }

    public String[] getTreeNames() {
        return new String[0];
    }

    public boolean removeTree(String treeName) {
        throw new UnsupportedOperationException();
    }

    public void renameTree(String oldName, String newName) throws DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public long getNumCodeUnits() {
        return this.codeOperations.definedUnits().size();
    }

    public long getNumDefinedData() {
        return this.codeOperations.definedData().size();
    }

    public long getNumInstructions() {
        return this.codeOperations.instructions().size();
    }

    public DataTypeManager getDataTypeManager() {
        return this.program.getDataTypeManager();
    }

    public TraceFunctionSymbol createFunction(String name, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.program.functionManager.createFunction(name, entryPoint, body, source);
    }

    public TraceFunctionSymbol createFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.program.functionManager.createFunction(name, nameSpace, entryPoint, body, source);
    }

    public void removeFunction(Address entryPoint) {
        this.program.functionManager.removeFunction(entryPoint);
    }

    public ghidra.program.model.listing.Function getFunctionAt(Address entryPoint) {
        return this.program.functionManager.getFunctionAt(entryPoint);
    }

    public List<ghidra.program.model.listing.Function> getGlobalFunctions(String name) {
        return new ArrayList<ghidra.program.model.listing.Function>(this.program.trace.getSymbolManager().functions().getGlobalsNamed(name));
    }

    public List<ghidra.program.model.listing.Function> getFunctions(String namespace, String name) {
        ArrayList<ghidra.program.model.listing.Function> result = new ArrayList<ghidra.program.model.listing.Function>();
        for (DBTraceFunctionSymbol func : this.program.trace.getSymbolManager().functions().getNamed(name)) {
            if (!namespace.equals(func.getParentNamespace().getName(true))) continue;
            result.add(func);
        }
        return result;
    }

    public ghidra.program.model.listing.Function getFunctionContaining(Address addr) {
        return this.program.functionManager.getFunctionContaining(addr);
    }

    public FunctionIterator getExternalFunctions() {
        return this.program.functionManager.getExternalFunctions();
    }

    public FunctionIterator getFunctions(boolean forward) {
        return this.program.functionManager.getFunctions(forward);
    }

    public FunctionIterator getFunctions(Address start, boolean forward) {
        return this.program.functionManager.getFunctions(start, forward);
    }

    public FunctionIterator getFunctions(AddressSetView asv, boolean forward) {
        return this.program.functionManager.getFunctions(asv, forward);
    }

    public boolean isInFunction(Address addr) {
        return this.program.functionManager.isInFunction(addr);
    }

    public CommentHistory[] getCommentHistory(Address addr, int commentType) {
        return new CommentHistory[0];
    }

    protected class DBTraceProgramViewUndefinedData
    extends UndefinedDBTraceData {
        public DBTraceProgramViewUndefinedData(DBTrace trace, long snap, Address address, DBTraceThread thread, int frameLevel) {
            super(trace, snap, address, thread, frameLevel);
        }

        @Override
        public int getBytes(ByteBuffer buffer, int addressOffset) {
            DBTraceMemorySpace mem = (DBTraceMemorySpace)this.trace.getMemoryManager().get(this, false);
            if (mem == null) {
                return 0;
            }
            return mem.getViewBytes(AbstractDBTraceProgramViewListing.this.program.snap, this.address.add((long)addressOffset), buffer);
        }
    }
}

