/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.map;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapSpace;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.spatial.AbstractRStarConstraintsTree;
import ghidra.util.database.spatial.DBTreeDataRecord;
import ghidra.util.database.spatial.DBTreeNodeRecord;
import ghidra.util.database.spatial.rect.Abstract2DRStarTree;
import ghidra.util.database.spatial.rect.AbstractRectangle2DQuery;
import ghidra.util.database.spatial.rect.EuclideanSpace2D;
import ghidra.util.database.spatial.rect.Rectangle2D;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class DBTraceAddressSnapRangePropertyMapTree<T, DR extends AbstractDBTraceAddressSnapRangePropertyMapData<T>>
extends Abstract2DRStarTree<Address, Long, TraceAddressSnapRange, DR, TraceAddressSnapRange, DBTraceAddressSnapRangePropertyMapNode, T, TraceAddressSnapRangeQuery> {
    protected static final int MAX_CHILDREN = 50;
    protected final DBTraceAddressSnapRangePropertyMap.DBTraceAddressSnapRangePropertyMapDataFactory<T, DR> dataFactory;
    protected final DBTraceAddressSnapRangePropertyMapSpace<T, DR> mapSpace;
    protected final DBCachedObjectIndex<Long, DBTraceAddressSnapRangePropertyMapNode> nodesByParent;
    protected final DBCachedObjectIndex<Long, DR> dataByParent;
    protected final Comparator<TraceAddressSnapRange> leftmostComparator;

    public DBTraceAddressSnapRangePropertyMapTree(DBCachedObjectStoreFactory storeFactory, String tableName, DBTraceAddressSnapRangePropertyMapSpace<T, DR> space, Class<DR> dataType, DBTraceAddressSnapRangePropertyMap.DBTraceAddressSnapRangePropertyMapDataFactory<T, DR> dataFactory, boolean upgradable) throws VersionException, IOException {
        super(storeFactory, tableName, (EuclideanSpace2D)TraceAddressSnapSpace.forAddressSpace(space.space), dataType, DBTraceAddressSnapRangePropertyMapNode.class, upgradable, 50);
        this.mapSpace = space;
        this.dataFactory = dataFactory;
        this.nodesByParent = this.nodeStore.getIndex(Long.TYPE, DBTraceAddressSnapRangePropertyMapNode.PARENT_COLUMN);
        this.dataByParent = this.dataStore.getIndex(Long.TYPE, AbstractDBTraceAddressSnapRangePropertyMapData.PARENT_COLUMN);
        this.leftmostComparator = Comparator.comparing(Rectangle2D::getX1, (arg_0, arg_1) -> ((EuclideanSpace2D)this.space).compareX(arg_0, arg_1));
        this.init();
    }

    protected Comparator<TraceAddressSnapRange> getDefaultBoundsComparator() {
        return this.leftmostComparator;
    }

    protected DR createDataEntry(DBCachedObjectStore<DR> store, DBRecord record) {
        return this.dataFactory.create(this, store, record);
    }

    protected DBTraceAddressSnapRangePropertyMapNode createNodeEntry(DBCachedObjectStore<DBTraceAddressSnapRangePropertyMapNode> store, DBRecord record) {
        return new DBTraceAddressSnapRangePropertyMapNode(this, store, record);
    }

    protected Rectangle2DDirection getDirectionOf(TraceAddressSnapRangeQuery query) {
        if (query == null || query.getDirection() == null) {
            return Rectangle2DDirection.LEFTMOST;
        }
        return query.getDirection();
    }

    protected Collection<DBTraceAddressSnapRangePropertyMapNode> getNodeChildrenOf(long parentKey) {
        return this.nodesByParent.get((Object)parentKey);
    }

    protected Collection<DR> getDataChildrenOf(long parentKey) {
        return this.dataByParent.get((Object)parentKey);
    }

    protected void doUnparentEntry(DR data) {
        super.doUnparentEntry(data);
    }

    protected void doDeleteEntry(DR data) {
        super.doDeleteEntry(data);
    }

    protected void doInsertDataEntry(DR entry) {
        super.doInsert(entry, new AbstractRStarConstraintsTree.LevelInfo(this.leafLevel));
    }

    public DBTraceAddressSnapRangePropertyMapSpace<T, DR> getMapSpace() {
        return this.mapSpace;
    }

    public static class TraceAddressSnapRangeQuery
    extends AbstractRectangle2DQuery<Address, Long, TraceAddressSnapRange, TraceAddressSnapRange, TraceAddressSnapRangeQuery> {
        public static TraceAddressSnapRangeQuery at(Address address, long snap) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)new ImmutableTraceAddressSnapRange(address, snap), null, TraceAddressSnapRangeQuery::new);
        }

        public TraceAddressSnapRangeQuery(TraceAddressSnapRange r1, TraceAddressSnapRange r2, Rectangle2DDirection direction) {
            super((Rectangle2D)r1, (Rectangle2D)r2, r1.getSpace(), direction);
        }

        public AddressSpace getAddressSpace() {
            return ((TraceAddressSnapRange)this.r1).getRange().getAddressSpace();
        }

        public boolean testData(TraceAddressSnapRange shape) {
            if (!((TraceAddressSnapRange)this.r1).contains(shape.getX1(), shape.getY1())) {
                return false;
            }
            return ((TraceAddressSnapRange)this.r2).contains(shape.getX2(), shape.getY2());
        }

        protected TraceAddressSnapRangeQuery create(TraceAddressSnapRange ir1, TraceAddressSnapRange ir2, Rectangle2DDirection newDirection) {
            return new TraceAddressSnapRangeQuery(ir1, ir2, newDirection);
        }

        public static TraceAddressSnapRangeQuery enclosed(TraceAddressSnapRange range) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.enclosed((Rectangle2D)range, null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery enclosed(AddressRange range, Range<Long> lifespan) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.enclosed((Rectangle2D)new ImmutableTraceAddressSnapRange(range, lifespan), null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery enclosed(Address minAddress, Address maxAddress, long minSnap, long maxSnap) {
            return TraceAddressSnapRangeQuery.enclosed(new ImmutableTraceAddressSnapRange(minAddress, maxAddress, minSnap, maxSnap));
        }

        public static TraceAddressSnapRangeQuery intersecting(TraceAddressSnapRange range) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)range, null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery intersecting(AddressRange range, Range<Long> lifespan) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)new ImmutableTraceAddressSnapRange(range, lifespan), null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery intersecting(Address minAddress, Address maxAddress, long minSnap, long maxSnap) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)new ImmutableTraceAddressSnapRange(minAddress, maxAddress, minSnap, maxSnap), null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery atSnap(long snap, AddressSpace space) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)new ImmutableTraceAddressSnapRange(space.getMinAddress(), space.getMaxAddress(), snap, snap), null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery intersecting(Range<Long> lifespan, AddressSpace space) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)new ImmutableTraceAddressSnapRange(space.getMinAddress(), space.getMaxAddress(), lifespan), null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery added(long from, long to, AddressSpace space) {
            if (to < from) {
                return TraceAddressSnapRangeQuery.removed(to, from, space);
            }
            AddressRangeImpl rng = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((AddressRange)rng, (Range<Long>)Range.closed((Comparable)Long.valueOf(from + 1L), (Comparable)Long.valueOf(to))).and(TraceAddressSnapRangeQuery.intersecting((AddressRange)rng, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(to))));
        }

        public static TraceAddressSnapRangeQuery removed(long from, long to, AddressSpace space) {
            if (to < from) {
                return TraceAddressSnapRangeQuery.added(to, from, space);
            }
            AddressRangeImpl rng = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((AddressRange)rng, (Range<Long>)Range.closed((Comparable)Long.valueOf(from), (Comparable)Long.valueOf(to - 1L))).and(TraceAddressSnapRangeQuery.enclosed((AddressRange)rng, (Range<Long>)Range.atMost((Comparable)Long.valueOf(from))));
        }

        public static TraceAddressSnapRangeQuery mostRecent(Address address, long snap) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)new ImmutableTraceAddressSnapRange(address, address, Long.MIN_VALUE, snap), (Rectangle2DDirection)Rectangle2DDirection.TOPMOST, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery mostRecent(Address address, Range<Long> span) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.intersecting((Rectangle2D)new ImmutableTraceAddressSnapRange(address, span), (Rectangle2DDirection)Rectangle2DDirection.TOPMOST, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery equalTo(TraceAddressSnapRange shape) {
            return (TraceAddressSnapRangeQuery)TraceAddressSnapRangeQuery.equalTo((Rectangle2D)shape, null, TraceAddressSnapRangeQuery::new);
        }

        public static TraceAddressSnapRangeQuery leftLower(Address address) {
            Address prev = address.previous();
            if (prev == null) {
                throw new NoSuchElementException();
            }
            return TraceAddressSnapRangeQuery.intersecting(address.getAddressSpace().getMinAddress(), prev, Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public static TraceAddressSnapRangeQuery rightHigher(Address address) {
            Address next = address.next();
            if (next == null) {
                throw new NoSuchElementException();
            }
            return TraceAddressSnapRangeQuery.intersecting(next, address.getAddressSpace().getMaxAddress(), Long.MIN_VALUE, Long.MAX_VALUE);
        }
    }

    public static abstract class AbstractDBTraceAddressSnapRangePropertyMapData<T>
    extends DBTreeDataRecord<TraceAddressSnapRange, TraceAddressSnapRange, T>
    implements TraceAddressSnapRange {
        static final String PARENT_COLUMN_NAME = "Parent";
        static final String MIN_ADDRESS_COLUMN_NAME = "MinAddress";
        static final String MAX_ADDRESS_COLUMN_NAME = "MaxAddress";
        static final String MIN_SNAP_COLUMN_NAME = "MinSnap";
        static final String MAX_SNAP_COLUMN_NAME = "MaxSnap";
        @DBAnnotatedColumn(value="Parent")
        static DBObjectColumn PARENT_COLUMN;
        @DBAnnotatedColumn(value="MinAddress")
        static DBObjectColumn MIN_ADDRESS_COLUMN;
        @DBAnnotatedColumn(value="MaxAddress")
        static DBObjectColumn MAX_ADDRESS_COLUMN;
        @DBAnnotatedColumn(value="MinSnap")
        static DBObjectColumn MIN_SNAP_COLUMN;
        @DBAnnotatedColumn(value="MaxSnap")
        static DBObjectColumn MAX_SNAP_COLUMN;
        @DBAnnotatedField(column="Parent", indexed=true)
        private long parentKey;
        @DBAnnotatedField(column="MinAddress")
        private long minOffset;
        @DBAnnotatedField(column="MaxAddress")
        private long maxOffset;
        @DBAnnotatedField(column="MinSnap")
        private long minSnap;
        @DBAnnotatedField(column="MaxSnap")
        private long maxSnap;
        protected final DBTraceAddressSnapRangePropertyMapTree<T, ? extends AbstractDBTraceAddressSnapRangePropertyMapData<T>> tree;
        protected AddressRange range;
        protected Range<Long> lifespan;

        public AbstractDBTraceAddressSnapRangePropertyMapData(DBTraceAddressSnapRangePropertyMapTree<T, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
            this.tree = tree;
        }

        protected void fresh(boolean created) throws IOException {
            super.fresh(created);
            if (created) {
                return;
            }
            Address minAddr = this.tree.mapSpace.toAddress(this.minOffset);
            Address maxAddr = this.tree.mapSpace.toAddress(this.maxOffset);
            this.range = new AddressRangeImpl(minAddr, maxAddr);
            this.lifespan = DBTraceUtils.toRange(this.minSnap, this.maxSnap);
        }

        public void setParentKey(long parentKey) {
            this.parentKey = parentKey;
            this.update(PARENT_COLUMN);
        }

        public long getParentKey() {
            return this.parentKey;
        }

        public void setShape(TraceAddressSnapRange shape) {
            this.minOffset = this.tree.mapSpace.assertInSpace(shape.getX1());
            this.maxOffset = shape.getX2().getOffset();
            this.minSnap = shape.getY1();
            this.maxSnap = shape.getY2();
            this.update(new DBObjectColumn[]{MIN_ADDRESS_COLUMN, MAX_ADDRESS_COLUMN, MIN_SNAP_COLUMN, MAX_SNAP_COLUMN});
            this.range = shape.getRange();
            this.lifespan = shape.getLifespan();
        }

        public TraceAddressSnapRange getShape() {
            return this;
        }

        @Override
        public TraceAddressSnapRange getBounds() {
            return this;
        }

        public EuclideanSpace2D<Address, Long> getSpace() {
            return ((DBTraceAddressSnapRangePropertyMapTree)this.tree).space;
        }

        @Override
        public AddressRange getRange() {
            return this.range;
        }

        protected void doSetRange(AddressRange range) {
            DBTraceAddressSnapRangePropertyMapTree<T, AbstractDBTraceAddressSnapRangePropertyMapData<T>> tree = this.tree;
            long newMinOffset = tree.mapSpace.assertInSpace(range.getMinAddress());
            tree.doUnparentEntry(this);
            this.minOffset = newMinOffset;
            this.maxOffset = range.getMaxAddress().getOffset();
            this.update(MIN_ADDRESS_COLUMN, MAX_ADDRESS_COLUMN);
            this.range = range;
            tree.doInsertDataEntry(this);
        }

        protected void doSetLifespan(Range<Long> lifespan) {
            DBTraceAddressSnapRangePropertyMapTree<T, AbstractDBTraceAddressSnapRangePropertyMapData<T>> tree = this.tree;
            tree.doUnparentEntry(this);
            this.minSnap = DBTraceUtils.lowerEndpoint(lifespan);
            this.maxSnap = DBTraceUtils.upperEndpoint(lifespan);
            this.update(MIN_SNAP_COLUMN, MAX_SNAP_COLUMN);
            this.lifespan = lifespan;
            tree.doInsertDataEntry(this);
        }

        @Override
        public Range<Long> getLifespan() {
            return this.lifespan;
        }

        public boolean shapeEquals(TraceAddressSnapRange shape) {
            return this.doEquals(shape);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbstractDBTraceAddressSnapRangePropertyMapData)) {
                return this.doEquals(obj);
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractDBTraceAddressSnapRangePropertyMapData that = (AbstractDBTraceAddressSnapRangePropertyMapData)obj;
            if (this.tree == that.tree) {
                return this == that;
            }
            if (!this.doEquals(obj)) {
                return false;
            }
            Object thisVal = this.getRecordValue();
            Object thatVal = that.getRecordValue();
            if (thisVal == this || thatVal == that) {
                return false;
            }
            return thisVal.equals(thatVal);
        }

        public int hashCode() {
            return this.doHashCode();
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceAddressSnapRangePropertyMapNode
    extends DBTreeNodeRecord<TraceAddressSnapRange>
    implements TraceAddressSnapRange {
        protected static final byte NODE_TYPE_MASK = 3;
        protected static final int NODE_TYPE_SHIFT = 6;
        protected static final byte NODE_TYPE_CLEAR = 63;
        protected static final byte CHILD_COUNT_MASK = 63;
        protected static final int CHILD_COUNT_SHIFT = 0;
        protected static final byte CHILD_COUNT_CLEAR = -64;
        static final String PARENT_COLUMN_NAME = "Parent";
        static final String MIN_ADDRESS_COLUMN_NAME = "MinAddress";
        static final String MAX_ADDRESS_COLUMN_NAME = "MaxAddress";
        static final String MIN_SNAP_COLUMN_NAME = "MinSnap";
        static final String MAX_SNAP_COLUMN_NAME = "MaxSnap";
        static final String TYPE_AND_CHILD_COUNT_COLUMN_NAME = "Type/ChildCount";
        static final String DATA_COUNT_COLUMN_NAME = "DataCount";
        @DBAnnotatedColumn(value="Parent")
        static DBObjectColumn PARENT_COLUMN;
        @DBAnnotatedColumn(value="MinAddress")
        static DBObjectColumn MIN_ADDRESS_COLUMN;
        @DBAnnotatedColumn(value="MaxAddress")
        static DBObjectColumn MAX_ADDRESS_COLUMN;
        @DBAnnotatedColumn(value="MinSnap")
        static DBObjectColumn MIN_SNAP_COLUMN;
        @DBAnnotatedColumn(value="MaxSnap")
        static DBObjectColumn MAX_SNAP_COLUMN;
        @DBAnnotatedColumn(value="Type/ChildCount")
        static DBObjectColumn TYPE_AND_CHILD_COUNT_COLUMN;
        @DBAnnotatedColumn(value="DataCount")
        static DBObjectColumn DATA_COUNT_COLUMN;
        @DBAnnotatedField(column="Parent", indexed=true)
        private long parentKey;
        @DBAnnotatedField(column="MinAddress")
        private long minOffset;
        @DBAnnotatedField(column="MaxAddress")
        private long maxOffset;
        @DBAnnotatedField(column="MinSnap")
        private long minSnap;
        @DBAnnotatedField(column="MaxSnap")
        private long maxSnap;
        @DBAnnotatedField(column="Type/ChildCount")
        private byte typeAndChildCount;
        @DBAnnotatedField(column="DataCount")
        private int dataCount;
        protected final DBTraceAddressSnapRangePropertyMapTree<?, ?> tree;
        private AddressRange range;
        private Range<Long> lifespan;

        public DBTraceAddressSnapRangePropertyMapNode(DBTraceAddressSnapRangePropertyMapTree<?, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
            this.tree = tree;
        }

        protected void fresh(boolean created) throws IOException {
            super.fresh(created);
            if (created) {
                Address min = this.tree.mapSpace.getAddressSpace().getMinAddress();
                this.range = new AddressRangeImpl(min, min);
                this.lifespan = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L));
                return;
            }
            Address minAddr = this.tree.mapSpace.toAddress(this.minOffset);
            Address maxAddr = this.tree.mapSpace.toAddress(this.maxOffset);
            this.range = new AddressRangeImpl(minAddr, maxAddr);
            this.lifespan = DBTraceUtils.toRange(this.minSnap, this.maxSnap);
        }

        protected DBTreeNodeRecord.NodeType getType() {
            return DBTreeNodeRecord.NodeType.values()[this.typeAndChildCount >> 6 & 3];
        }

        protected void setType(DBTreeNodeRecord.NodeType type) {
            this.typeAndChildCount = (byte)(this.typeAndChildCount & 0x3F | type.ordinal() << 6);
            this.update(TYPE_AND_CHILD_COUNT_COLUMN);
        }

        protected int getChildCount() {
            return this.typeAndChildCount >> 0 & 0x3F;
        }

        protected void setChildCount(int childCount) {
            assert ((childCount & 0x3F) == childCount);
            this.typeAndChildCount = (byte)(this.typeAndChildCount & 0xFFFFFFC0 | childCount << 0);
            this.update(TYPE_AND_CHILD_COUNT_COLUMN);
        }

        protected void setDataCount(int dataCount) {
            this.dataCount = dataCount;
            this.update(DATA_COUNT_COLUMN);
        }

        public TraceAddressSnapRange getShape() {
            return this;
        }

        @Override
        public TraceAddressSnapRange getBounds() {
            return this;
        }

        public void setShape(TraceAddressSnapRange shape) {
            this.minOffset = this.tree.mapSpace.assertInSpace(shape.getX1());
            this.maxOffset = this.tree.mapSpace.assertInSpace(shape.getX2());
            this.minSnap = shape.getY1();
            this.maxSnap = shape.getY2();
            this.update(new DBObjectColumn[]{MIN_ADDRESS_COLUMN, MAX_ADDRESS_COLUMN, MIN_SNAP_COLUMN, MAX_SNAP_COLUMN});
            this.range = shape.getRange();
            this.lifespan = shape.getLifespan();
        }

        public long getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(long parentKey) {
            this.parentKey = parentKey;
            this.update(PARENT_COLUMN);
        }

        protected int getDataCount() {
            return this.dataCount;
        }

        public EuclideanSpace2D<Address, Long> getSpace() {
            return ((DBTraceAddressSnapRangePropertyMapTree)this.tree).space;
        }

        @Override
        public AddressRange getRange() {
            return this.range;
        }

        @Override
        public Range<Long> getLifespan() {
            return this.lifespan;
        }
    }
}

