/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import db.DBHandle;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitsRegisterView;
import ghidra.trace.database.listing.DBTraceDataRegisterView;
import ghidra.trace.database.listing.DBTraceDefinedDataRegisterView;
import ghidra.trace.database.listing.DBTraceDefinedUnitsRegisterView;
import ghidra.trace.database.listing.DBTraceInstructionsRegisterView;
import ghidra.trace.database.listing.DBTraceUndefinedDataRegisterView;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.listing.TraceCodeRegisterSpace;
import ghidra.util.exception.VersionException;
import java.io.IOException;

public class DBTraceCodeRegisterSpace
extends DBTraceCodeSpace
implements TraceCodeRegisterSpace {
    protected final DBTraceThread thread;
    private final int frameLevel;

    public DBTraceCodeRegisterSpace(DBTraceCodeManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent, DBTraceThread thread) throws VersionException, IOException {
        super(manager, dbh, space, ent);
        this.thread = thread;
        this.frameLevel = ent.getFrameLevel();
    }

    @Override
    public DBTraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    @Override
    protected DBTraceInstructionsRegisterView createInstructionsView() {
        return new DBTraceInstructionsRegisterView(this);
    }

    @Override
    protected DBTraceDefinedDataRegisterView createDefinedDataView() {
        return new DBTraceDefinedDataRegisterView(this);
    }

    @Override
    protected DBTraceDefinedUnitsRegisterView createDefinedUnitsView() {
        return new DBTraceDefinedUnitsRegisterView(this);
    }

    @Override
    protected DBTraceUndefinedDataRegisterView createUndefinedDataView() {
        return new DBTraceUndefinedDataRegisterView(this);
    }

    @Override
    protected DBTraceDataRegisterView createDataView() {
        return new DBTraceDataRegisterView(this);
    }

    @Override
    protected DBTraceCodeUnitsRegisterView createCodeUnitsView() {
        return new DBTraceCodeUnitsRegisterView(this);
    }

    @Override
    public DBTraceCodeUnitsRegisterView codeUnits() {
        return (DBTraceCodeUnitsRegisterView)this.codeUnits;
    }

    @Override
    public DBTraceInstructionsRegisterView instructions() {
        return (DBTraceInstructionsRegisterView)this.instructions;
    }

    @Override
    public DBTraceDataRegisterView data() {
        return (DBTraceDataRegisterView)this.data;
    }

    @Override
    public DBTraceDefinedDataRegisterView definedData() {
        return (DBTraceDefinedDataRegisterView)this.definedData;
    }

    @Override
    public DBTraceUndefinedDataRegisterView undefinedData() {
        return (DBTraceUndefinedDataRegisterView)this.undefinedData;
    }

    @Override
    public DBTraceDefinedUnitsRegisterView definedUnits() {
        return (DBTraceDefinedUnitsRegisterView)this.definedUnits;
    }
}

