/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.trace.AbstractCheckedTraceCachedWriteBytesPcodeExecutorState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;

public class RequireIsKnownTraceCachedWriteBytesPcodeExecutorState
extends AbstractCheckedTraceCachedWriteBytesPcodeExecutorState {
    public RequireIsKnownTraceCachedWriteBytesPcodeExecutorState(Trace trace, long snap, TraceThread thread, int frame) {
        super(trace, snap, thread, frame);
    }

    protected AddressSetView getKnown(TraceMemorySpace source) {
        return source.getAddressesWithState(this.snap, s -> s == TraceMemoryState.KNOWN);
    }

    protected AccessPcodeExecutionException excFor(AddressSetView unknown) {
        return new AccessPcodeExecutionException("Memory at " + unknown + " is unknown.");
    }

    @Override
    protected int checkUninitialized(TraceMemorySpace source, Address start, int size, AddressSet uninitialized) {
        if (source == null) {
            if (!uninitialized.contains(start)) {
                return (int)uninitialized.getMinAddress().subtract(start);
            }
            throw this.excFor((AddressSetView)uninitialized);
        }
        AddressSet unknown = uninitialized.subtract(this.getKnown(source));
        if (unknown.isEmpty()) {
            return size;
        }
        if (!unknown.contains(start)) {
            return (int)unknown.getMinAddress().subtract(start);
        }
        throw this.excFor((AddressSetView)unknown);
    }
}

