/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.linux;

import ghidra.util.Msg;
import java.util.List;
import java.util.concurrent.Callable;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;

public class LinuxPtySessionLeader {
    private static final POSIX LIB_POSIX = POSIXFactory.getNativePOSIX();
    private static final int O_RDWR = 2;
    protected String ptyPath;
    protected List<String> subArgs;

    public static void main(String[] args) throws Exception {
        LinuxPtySessionLeader leader = new LinuxPtySessionLeader();
        leader.parseArgs(args);
        leader.run();
    }

    protected void parseArgs(String[] args) {
        this.ptyPath = args[0];
        this.subArgs = List.of(args).subList(1, args.length);
    }

    protected <T> T checkErr(Callable<T> r) throws Exception {
        LIB_POSIX.errno(0);
        T result = r.call();
        int errno = LIB_POSIX.errno();
        if (errno != 0) {
            throw new RuntimeException("errno=" + errno + ": " + LIB_POSIX.strerror(errno));
        }
        return result;
    }

    protected void run() throws Exception {
        this.checkErr(() -> LIB_POSIX.setsid());
        int fd = this.checkErr(() -> LIB_POSIX.open((CharSequence)this.ptyPath, 2, 0));
        int bk = fd + 1;
        this.checkErr(() -> LIB_POSIX.dup2(2, bk));
        this.checkErr(() -> LIB_POSIX.dup2(fd, 0));
        this.checkErr(() -> LIB_POSIX.dup2(fd, 1));
        this.checkErr(() -> LIB_POSIX.dup2(fd, 2));
        try {
            this.checkErr(() -> LIB_POSIX.execv(this.subArgs.get(0), this.subArgs.toArray(new String[0])));
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Could not execv with args " + this.subArgs), (Throwable)t);
            try {
                this.checkErr(() -> LIB_POSIX.dup2(bk, 2));
            }
            catch (Throwable t2) {
                System.exit(-1);
            }
            throw t;
        }
    }
}

