/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbRegister;
import agent.gdb.manager.GdbThread;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetRegister;
import ghidra.async.AsyncUtils;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="RegisterContainer", attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetRegisterContainer
extends DefaultTargetObject<GdbModelTargetRegister, GdbModelTargetInferior>
implements TargetRegisterContainer {
    public static final String NAME = "Registers";
    protected final GdbModelImpl impl;
    protected final GdbInferior inferior;
    protected final Map<Integer, GdbModelTargetRegister> registersByNumber = new WeakValueHashMap();

    public GdbModelTargetRegisterContainer(GdbModelTargetInferior inferior) {
        super((AbstractDebuggerObjectModel)inferior.impl, (TargetObject)inferior, NAME, "RegisterContainer");
        this.impl = inferior.impl;
        this.inferior = inferior.inferior;
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        if (!refresh) {
            return this.completeUsingThreads(this.inferior.getKnownThreads());
        }
        return this.doRefresh();
    }

    protected CompletableFuture<Void> doRefresh() {
        return this.inferior.listThreads().thenCompose(this::completeUsingThreads);
    }

    protected CompletableFuture<Void> completeUsingThreads(Map<Integer, GdbThread> byId) {
        if (byId.isEmpty()) {
            this.setElements(List.of(), "Refreshed (with no thread)");
            return AsyncUtils.NIL;
        }
        GdbThread thread = byId.values().iterator().next();
        return thread.listRegisters().thenAccept(regs -> {
            List registers;
            GdbModelTargetRegisterContainer gdbModelTargetRegisterContainer = this;
            synchronized (gdbModelTargetRegisterContainer) {
                this.registersByNumber.clear();
                registers = regs.stream().map(this::getTargetRegister).collect(Collectors.toList());
            }
            this.setElements(registers, "Refreshed");
        });
    }

    protected synchronized GdbModelTargetRegister getTargetRegister(GdbRegister register) {
        return this.registersByNumber.computeIfAbsent(register.getNumber(), n -> new GdbModelTargetRegister(this, register));
    }

    public CompletableFuture<Void> refreshInternal() {
        return this.doRefresh().exceptionally(ex -> {
            Msg.error((Object)((Object)this), (Object)"Problem refreshing inferior's register descriptions", (Throwable)ex);
            return null;
        });
    }

    public void stateChanged(GdbStateChangeRecord sco) {
        this.requestElements(false).thenAccept(__ -> {
            for (GdbModelTargetRegister modelRegister : this.registersByNumber.values()) {
                modelRegister.stateChanged(sco);
            }
        });
    }
}

