/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbModule;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetModule;
import ghidra.async.AsyncFence;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetModuleContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.lifecycle.Internal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ModuleContainer", elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetModuleContainer
extends DefaultTargetObject<GdbModelTargetModule, GdbModelTargetInferior>
implements TargetModuleContainer {
    public static final String NAME = "Modules";
    protected final GdbModelImpl impl;
    protected final GdbInferior inferior;

    public GdbModelTargetModuleContainer(GdbModelTargetInferior inferior) {
        super((AbstractDebuggerObjectModel)inferior.impl, (TargetObject)inferior, NAME, "ModuleContainer");
        this.impl = inferior.impl;
        this.inferior = inferior.inferior;
    }

    @Internal
    public GdbModelTargetModule libraryLoaded(String name) {
        GdbModule mod = Objects.requireNonNull(this.inferior.getKnownModules().get(name));
        GdbModelTargetModule module = this.getTargetModule(mod);
        this.changeElements(List.of(), List.of(module), "Loaded");
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void libraryUnloaded(String name) {
        GdbModelTargetModuleContainer gdbModelTargetModuleContainer = this;
        synchronized (gdbModelTargetModuleContainer) {
            this.impl.deleteModelObject(name);
        }
        this.changeElements(List.of(name), List.of(), "Unloaded");
    }

    public boolean supportsSyntheticModules() {
        return false;
    }

    public CompletableFuture<? extends TargetModule> addSyntheticModule(String name) {
        throw new DebuggerUserException("GDB Does not support synthetic modules");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingModules(Map<String, GdbModule> byName) {
        List modules;
        GdbModelTargetModuleContainer gdbModelTargetModuleContainer = this;
        synchronized (gdbModelTargetModuleContainer) {
            modules = byName.values().stream().map(this::getTargetModule).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (GdbModelTargetModule mod : modules) {
            fence.include(mod.init());
        }
        return fence.ready().thenAccept(__ -> {
            List validOnly = modules.stream().filter(m -> m.isValid()).collect(Collectors.toList());
            this.changeElements(List.of(), validOnly, "Refreshed");
        });
    }

    protected CompletableFuture<Void> requestElements(boolean refresh) {
        return this.doRefresh();
    }

    protected CompletableFuture<Void> doRefresh() {
        return this.inferior.listModules().thenCompose(byName -> {
            for (String modName : this.inferior.getKnownModules().keySet()) {
                if (byName.keySet().contains(modName)) continue;
                this.impl.deleteModelObject(byName.get(modName));
            }
            return this.updateUsingModules((Map<String, GdbModule>)byName);
        });
    }

    protected synchronized GdbModelTargetModule getTargetModule(GdbModule module) {
        TargetObject modelObject = this.impl.getModelObject(module);
        if (modelObject != null) {
            return (GdbModelTargetModule)modelObject;
        }
        return new GdbModelTargetModule(this, module);
    }

    public synchronized GdbModelTargetModule getTargetModuleIfPresent(String name) {
        return (GdbModelTargetModule)this.impl.getModelObject(name);
    }

    protected CompletableFuture<?> refreshInternal() {
        return this.doRefresh().exceptionally(ex -> {
            this.impl.reportError((Object)this, "Problem refreshing inferior's modules", (Throwable)ex);
            return null;
        });
    }
}

