/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.GdbModule;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetModuleContainer;
import agent.gdb.model.impl.GdbModelTargetSectionContainer;
import agent.gdb.model.impl.GdbModelTargetSymbolContainer;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Module", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetModule
extends DefaultTargetObject<TargetObject, GdbModelTargetModuleContainer>
implements TargetModule {
    public static final String VISIBLE_RANGE_ATTRIBUTE_NAME = "range";
    public static final String VISIBLE_MODULE_NAME_ATTRIBUTE_NAME = "module name";
    protected final GdbModelImpl impl;
    protected final GdbInferior inferior;
    protected final GdbModule module;
    protected final GdbModelTargetSectionContainer sections;
    protected final GdbModelTargetSymbolContainer symbols;
    protected AddressRange range;

    protected static String indexModule(GdbModule module) {
        return module.getName();
    }

    protected static String keyModule(GdbModule module) {
        return PathUtils.makeKey((String)GdbModelTargetModule.indexModule(module));
    }

    public GdbModelTargetModule(GdbModelTargetModuleContainer modules, GdbModule module) {
        super((AbstractDebuggerObjectModel)modules.impl, (TargetObject)modules, GdbModelTargetModule.keyModule(module), "Module");
        this.impl = modules.impl;
        this.inferior = modules.inferior;
        this.module = module;
        this.impl.addModelObject(module, (TargetObject)this);
        this.impl.addModelObject(module.getName(), (TargetObject)this);
        this.sections = new GdbModelTargetSectionContainer(this);
        this.symbols = new GdbModelTargetSymbolContainer(this);
        this.range = this.doGetRange();
        this.changeAttributes(List.of(), List.of(this.sections, this.symbols), Map.of(VISIBLE_RANGE_ATTRIBUTE_NAME, this.range, VISIBLE_MODULE_NAME_ATTRIBUTE_NAME, module.getName(), "_range", this.range, "_module_name", module.getName(), "_short_display", this.getDisplay(), "_display", this.getDisplay()), "Initialized");
    }

    public CompletableFuture<Void> init() {
        return this.sections.requestElements(true).exceptionally(ex -> {
            this.impl.reportError((Object)this, "Could not initialize module sections and base", (Throwable)ex);
            return null;
        });
    }

    @TargetAttributeType(name="Sections", required=true, fixed=true)
    public GdbModelTargetSectionContainer getSections() {
        return this.sections;
    }

    @TargetAttributeType(name="Symbols", required=true, fixed=true)
    public GdbModelTargetSymbolContainer getSymbols() {
        return this.symbols;
    }

    public String getDisplay() {
        String shortName = this.module.getName();
        int sep = shortName.lastIndexOf(47);
        if (sep > 0 && sep < shortName.length()) {
            shortName = shortName.substring(sep + 1);
        }
        return shortName;
    }

    protected AddressRange doGetRange() {
        Long base = this.module.getKnownBase();
        Long max = this.module.getKnownMax();
        Long l = max = max == null ? base : Long.valueOf(max - 1L);
        if (base == null) {
            Address addr = this.impl.space.getMinAddress();
            return new AddressRangeImpl(addr, addr);
        }
        return new AddressRangeImpl(this.impl.space.getAddress(base.longValue()), this.impl.space.getAddress(max.longValue()));
    }

    public void sectionsRefreshed() {
        this.range = this.doGetRange();
        this.changeAttributes(List.of(), Map.of("_range", this.range, VISIBLE_RANGE_ATTRIBUTE_NAME, this.range), "Sections Refreshed");
    }

    public AddressRange getRange() {
        return this.range;
    }

    @TargetAttributeType(name="range")
    public AddressRange getVisibleRange() {
        return this.range;
    }

    @TargetAttributeType(name="module name")
    public String getVisibleModuleName() {
        return this.module.getName();
    }
}

