/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.breakpoint;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum GdbBreakpointType {
    BREAKPOINT("breakpoint", false),
    HW_BREAKPOINT("hw breakpoint", false),
    DPRINTF("dprintf", false),
    HW_WATCHPOINT("hw watchpoint", true),
    READ_WATCHPOINT("read watchpoint", true),
    ACCESS_WATCHPOINT("acc watchpoint", true),
    CATCHPOINT("catchpoint", false),
    OTHER("<OTHER>", false);

    public static final Map<String, GdbBreakpointType> BY_NAME;
    private final String name;
    private final boolean isWatchpoint;

    public static GdbBreakpointType fromStr(String string) {
        return BY_NAME.getOrDefault(string, OTHER);
    }

    private GdbBreakpointType(String name, boolean isWatchpoint) {
        this.name = name;
        this.isWatchpoint = isWatchpoint;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isWatchpoint() {
        return this.isWatchpoint;
    }

    static {
        BY_NAME = List.of(GdbBreakpointType.values()).stream().collect(Collectors.toMap(v -> v.getName(), v -> v));
    }
}

