/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager;

import agent.gdb.manager.GdbRegister;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class GdbRegisterSet
extends AbstractSet<GdbRegister> {
    private final Map<String, GdbRegister> byName = new HashMap<String, GdbRegister>();
    private final Map<Integer, GdbRegister> byNumber = new TreeMap<Integer, GdbRegister>();

    public GdbRegisterSet(Collection<GdbRegister> regs) {
        for (GdbRegister r : regs) {
            this.byName.put(r.getName(), r);
            this.byNumber.put(r.getNumber(), r);
        }
    }

    public GdbRegister get(String name) {
        return this.byName.get(name);
    }

    public GdbRegister get(int number) {
        return this.byNumber.get(number);
    }

    @Override
    public Iterator<GdbRegister> iterator() {
        return this.byNumber.values().iterator();
    }

    @Override
    public int size() {
        return this.byNumber.size();
    }
}

