/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.graph.AbstractDependencyGraph;
import ghidra.util.graph.DependencyGraph;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class AcyclicCallGraphBuilder {
    private Program program;
    private Set<Address> functionSet;
    private boolean killThunks;

    public AcyclicCallGraphBuilder(Program program, boolean killThunks) {
        this(program, program.getMemory(), killThunks);
    }

    public AcyclicCallGraphBuilder(Program program, AddressSetView set, boolean killThunks) {
        this.program = program;
        this.functionSet = AcyclicCallGraphBuilder.findFunctions(program, set, killThunks);
        this.killThunks = killThunks;
    }

    public AcyclicCallGraphBuilder(Program program, Collection<Function> functions, boolean killThunks) {
        this.program = program;
        this.functionSet = new HashSet<Address>();
        for (Function function : functions) {
            if (killThunks && function.isThunk()) {
                function = function.getThunkedFunction(true);
            }
            this.functionSet.add(function.getEntryPoint());
        }
        this.killThunks = killThunks;
    }

    public AbstractDependencyGraph<Address> getDependencyGraph(TaskMonitor monitor) throws CancelledException {
        DependencyGraph graph = new DependencyGraph();
        Deque<Address> startPoints = this.findStartPoints();
        TreeSet<Address> unprocessed = new TreeSet<Address>(this.functionSet);
        monitor.initialize((long)unprocessed.size());
        while (!unprocessed.isEmpty()) {
            monitor.checkCanceled();
            Address functionEntry = this.getNextStartFunction(startPoints, unprocessed);
            this.processForward((AbstractDependencyGraph<Address>)graph, unprocessed, functionEntry, monitor);
        }
        return graph;
    }

    private Address getNextStartFunction(Deque<Address> startPoints, Set<Address> unProcessedSet) {
        while (!startPoints.isEmpty()) {
            Address address = startPoints.pop();
            if (!unProcessedSet.contains(address)) continue;
            return address;
        }
        return unProcessedSet.iterator().next();
    }

    private Deque<Address> findStartPoints() {
        LinkedList<Address> startPoints = new LinkedList<Address>();
        for (Address address : this.functionSet) {
            if (!this.isStartFunction(address)) continue;
            startPoints.add(address);
        }
        return startPoints;
    }

    private void initializeNode(StackNode node) {
        FunctionManager fmanage = this.program.getFunctionManager();
        Function function = fmanage.getFunctionAt(node.address);
        if (function.isThunk()) {
            Function thunkedfunc = function.getThunkedFunction(false);
            node.children = new Address[1];
            node.children[0] = thunkedfunc.getEntryPoint();
            return;
        }
        ArrayList<Address> children = new ArrayList<Address>();
        ReferenceManager referenceManager = this.program.getReferenceManager();
        AddressIterator referenceSourceIterator = referenceManager.getReferenceSourceIterator(function.getBody(), true);
        while (referenceSourceIterator.hasNext()) {
            Address fromAddr = referenceSourceIterator.next();
            for (Reference ref : referenceManager.getFlowReferencesFrom(fromAddr)) {
                Address toAddr = ref.getToAddress();
                if (!ref.getReferenceType().isCall()) continue;
                Function childfunc = fmanage.getFunctionAt(toAddr);
                if (childfunc != null && this.killThunks && childfunc.isThunk()) {
                    childfunc = childfunc.getThunkedFunction(true);
                    toAddr = childfunc.getEntryPoint();
                }
                if (!this.functionSet.contains(toAddr)) continue;
                children.add(toAddr);
            }
        }
        node.children = new Address[children.size()];
        children.toArray(node.children);
    }

    private void processForward(AbstractDependencyGraph<Address> graph, Set<Address> unprocessed, Address startFunction, TaskMonitor monitor) throws CancelledException {
        VisitStack stack = new VisitStack(startFunction);
        StackNode curnode = stack.peek();
        this.initializeNode(curnode);
        graph.addValue((Object)curnode.address);
        while (!stack.isEmpty()) {
            Address childAddr;
            monitor.checkCanceled();
            curnode = stack.peek();
            if (curnode.nextchild >= curnode.children.length) {
                unprocessed.remove(curnode.address);
                monitor.incrementProgress(1L);
                stack.pop();
                continue;
            }
            if (stack.contains(childAddr = curnode.children[curnode.nextchild++])) continue;
            if (unprocessed.contains(childAddr)) {
                stack.push(childAddr);
                StackNode nextnode = stack.peek();
                this.initializeNode(nextnode);
                childAddr = nextnode.address;
                graph.addValue((Object)nextnode.address);
            }
            graph.addDependency((Object)curnode.address, (Object)childAddr);
        }
    }

    private boolean isStartFunction(Address address) {
        ReferenceManager referenceManager = this.program.getReferenceManager();
        ReferenceIterator referencesTo = referenceManager.getReferencesTo(address);
        for (Reference reference : referencesTo) {
            if (reference.isEntryPointReference()) {
                return true;
            }
            if (!reference.getReferenceType().isCall()) continue;
            return false;
        }
        return true;
    }

    private static Set<Address> findFunctions(Program program, AddressSetView set, boolean killThunks) {
        HashSet<Address> functionStarts = new HashSet<Address>();
        FunctionIterator functions = program.getFunctionManager().getFunctions(set, true);
        for (Function function : functions) {
            if (killThunks && function.isThunk()) {
                function = function.getThunkedFunction(true);
            }
            functionStarts.add(function.getEntryPoint());
        }
        return functionStarts;
    }

    private static class VisitStack {
        private Set<Address> inStack = new HashSet<Address>();
        private Deque<StackNode> stack = new LinkedList<StackNode>();

        public VisitStack(Address functionEntry) {
            this.push(functionEntry);
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public StackNode peek() {
            return this.stack.peek();
        }

        public boolean contains(Address address) {
            return this.inStack.contains(address);
        }

        public void push(Address address) {
            if (!this.inStack.add(address)) {
                throw new IllegalStateException("Attempted to visit an address that is already on the stack");
            }
            StackNode newnode = new StackNode();
            newnode.address = address;
            newnode.nextchild = 0;
            this.stack.push(newnode);
        }

        public void pop() {
            Address address = this.stack.pop().address;
            this.inStack.remove(address);
        }
    }

    private static class StackNode {
        public Address address;
        public Address[] children;
        public int nextchild;

        private StackNode() {
        }

        public String toString() {
            return this.address == null ? "" : this.address.toString() + (String)(this.children == null ? " <no children>" : " " + Arrays.toString(this.children));
        }
    }
}

