/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class AddressXML {
    private AddressSpace space;
    private long offset;
    private long size;
    private Varnode[] joinRecord;

    private AddressXML() {
        this.space = null;
        this.joinRecord = null;
    }

    public AddressXML(AddressSpace spc, long off, int sz) {
        this.space = spc;
        this.offset = off;
        this.size = sz;
        this.joinRecord = null;
    }

    public AddressXML(AddressSpace spc, long off, int sz, Varnode[] pieces) {
        if (spc.getType() != 6) {
            throw new IllegalArgumentException("JOIN address space required to represent an Address with pieces");
        }
        this.space = spc;
        this.offset = off;
        this.size = sz;
        this.joinRecord = pieces;
    }

    private void readJoinXML(XmlElement el, CompilerSpec cspec) throws XmlParseException {
        String attrName;
        String attrVal;
        ArrayList<Varnode> pieces = new ArrayList<Varnode>();
        int sizesum = 0;
        int pos = 0;
        while ((attrVal = el.getAttribute(attrName = "piece" + Integer.toString(pos + 1))) != null) {
            Varnode newvn;
            int offpos = attrVal.indexOf(58);
            if (offpos == -1) {
                Register register = cspec.getLanguage().getRegister(attrVal);
                if (register == null) {
                    throw new XmlParseException("Unknown pentry register: " + attrVal);
                }
                newvn = new Varnode(register.getAddress(), register.getBitLength() / 8);
            } else {
                int szpos = attrVal.indexOf(58, offpos + 1);
                if (szpos == -1) {
                    throw new XmlParseException("join address piece attribute is malformed");
                }
                String spcname = attrVal.substring(0, offpos);
                AddressSpace spc = cspec.getAddressSpace(spcname);
                long off = SpecXmlUtils.decodeLong((String)attrVal.substring(offpos + 1, szpos));
                long sz = SpecXmlUtils.decodeLong((String)attrVal.substring(szpos + 1));
                newvn = new Varnode(spc.getAddress(off), (int)sz);
            }
            pieces.add(newvn);
            sizesum += newvn.getSize();
            ++pos;
        }
        this.offset = 0L;
        this.size = sizesum;
        this.joinRecord = new Varnode[pieces.size()];
        pieces.toArray(this.joinRecord);
    }

    public void saveXml(StringBuilder buffer) {
        if (this.joinRecord != null) {
            long logicalSize = this.size;
            long sizeSum = 0L;
            for (Varnode vn : this.joinRecord) {
                sizeSum += (long)vn.getSize();
            }
            if (sizeSum == this.size) {
                logicalSize = 0L;
            }
            AddressXML.buildXML(buffer, this.joinRecord, logicalSize);
            return;
        }
        buffer.append("<addr");
        if (this.space != null) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"space", (String)this.space.getName());
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"offset", (long)this.offset);
            if (this.size != 0L) {
                SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buffer, (String)"size", (long)this.size);
            }
        }
        buffer.append("/>");
    }

    public static AddressXML restoreXml(XmlElement el, CompilerSpec cspec) throws XmlParseException {
        AddressXML result;
        if (el.getName().equals("register")) {
            String regName = el.getAttribute("name");
            if (regName == null) {
                throw new XmlParseException("Missing pentry register name");
            }
            Register register = cspec.getLanguage().getRegister(regName);
            if (register == null) {
                throw new XmlParseException("Unknown pentry register: " + regName);
            }
            result = new AddressXML(register.getAddressSpace(), register.getOffset(), register.getMinimumByteSize());
        } else {
            result = new AddressXML();
            result.size = 0L;
            String spaceName = el.getAttribute("space");
            result.space = cspec.getAddressSpace(spaceName);
            if (result.space == null) {
                throw new XmlParseException("Unknown address space: " + spaceName);
            }
            if (result.space.getType() == 6) {
                result.readJoinXML(el, cspec);
            } else {
                result.offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
            }
            String sizeString = el.getAttribute("size");
            if (sizeString != null) {
                result.size = SpecXmlUtils.decodeInt((String)sizeString);
            }
        }
        return result;
    }

    public static AddressXML restoreXml(XmlElement el, Language language) throws XmlParseException {
        AddressXML result;
        if (el.getName().equals("register")) {
            String regName = el.getAttribute("name");
            if (regName == null) {
                throw new XmlParseException("Missing register name");
            }
            Register register = language.getRegister(regName);
            if (register == null) {
                throw new XmlParseException("Unknown register: " + regName);
            }
            result = new AddressXML(register.getAddressSpace(), register.getOffset(), register.getMinimumByteSize());
        } else {
            result = new AddressXML();
            result.size = 0L;
            String spaceName = el.getAttribute("space");
            result.space = language.getAddressFactory().getAddressSpace(spaceName);
            if (result.space == null) {
                throw new XmlParseException("Unknown address space: " + spaceName);
            }
            result.offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
            String sizeString = el.getAttribute("size");
            if (sizeString != null) {
                result.size = SpecXmlUtils.decodeInt((String)sizeString);
            }
        }
        return result;
    }

    public static AddressXML restoreRangeXml(XmlElement el, CompilerSpec cspec) throws XmlParseException {
        AddressXML result = new AddressXML();
        result.offset = 0L;
        long last = -1L;
        boolean seenLast = false;
        String attrvalue = el.getAttribute("space");
        if (attrvalue != null) {
            result.space = cspec.getAddressSpace(attrvalue);
            if (result.space == null) {
                throw new XmlParseException("Undefined space: " + attrvalue);
            }
        }
        if ((attrvalue = el.getAttribute("first")) != null) {
            result.offset = SpecXmlUtils.decodeLong((String)attrvalue);
        }
        if ((attrvalue = el.getAttribute("last")) != null) {
            last = SpecXmlUtils.decodeLong((String)attrvalue);
            seenLast = true;
        }
        if ((attrvalue = el.getAttribute("name")) != null) {
            Register register = cspec.getLanguage().getRegister(attrvalue);
            result.space = register.getAddressSpace();
            result.offset = register.getOffset();
            last = result.offset - 1L + (long)register.getMinimumByteSize();
            seenLast = true;
        }
        if (result.space == null) {
            throw new XmlParseException("No address space indicated in range tag");
        }
        if (!seenLast) {
            last = result.space.getMaxAddress().getOffset();
        }
        result.size = last - result.offset + 1L;
        return result;
    }

    public final AddressSpace getAddressSpace() {
        return this.space;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final long getSize() {
        return this.size;
    }

    public final Varnode[] getJoinRecord() {
        return this.joinRecord;
    }

    public Varnode getVarnode() {
        Address addr = this.space.getAddress(this.offset);
        return new Varnode(addr, (int)this.size);
    }

    public Address getFirstAddress() {
        return this.space.getAddress(this.offset);
    }

    public Address getLastAddress() {
        return this.space.getAddress(this.offset + this.size - 1L);
    }

    public static Address readXML(String addrstring, AddressFactory addrfactory) throws PcodeXMLException {
        int tagstart = addrstring.indexOf(60);
        if (tagstart >= 0) {
            int spaceend;
            int nameend;
            int attrstart;
            if (addrstring.startsWith("spaceid", ++tagstart) && (attrstart = addrstring.indexOf("name=\"", tagstart += 8)) >= 0 && (nameend = addrstring.indexOf(34, attrstart += 6)) >= 0) {
                AddressSpace spc = addrfactory.getAddressSpace(addrstring.substring(attrstart, nameend));
                int spaceid = spc.getSpaceID();
                spc = addrfactory.getConstantSpace();
                return spc.getAddress(spaceid);
            }
            int spacestart = addrstring.indexOf("space=\"");
            if (spacestart >= 4 && (spaceend = addrstring.indexOf(34, spacestart += 7)) >= spacestart) {
                int offend;
                String spcname = addrstring.substring(spacestart, spaceend);
                int offstart = addrstring.indexOf("offset=\"");
                if (offstart >= 4 && (offend = addrstring.indexOf(34, offstart += 8)) >= offstart) {
                    String offstr = addrstring.substring(offstart, offend);
                    AddressSpace spc = addrfactory.getAddressSpace(spcname);
                    if (spc == null) {
                        return Address.NO_ADDRESS;
                    }
                    long offset = SpecXmlUtils.decodeLong((String)offstr);
                    return spc.getAddress(offset);
                }
            }
        }
        throw new PcodeXMLException("Badly formed address: " + addrstring);
    }

    public static int readXMLSize(String addrxml) {
        int attrend;
        int attrstart = addrxml.indexOf("size=\"");
        if (attrstart >= 4 && (attrend = addrxml.indexOf(34, attrstart += 6)) > attrstart) {
            int size = SpecXmlUtils.decodeInt((String)addrxml.substring(attrstart, attrend));
            return size;
        }
        return 0;
    }

    public static Address readXML(XmlElement el, AddressFactory addrFactory) {
        String localName = el.getName();
        if (localName.equals("spaceid")) {
            AddressSpace spc = addrFactory.getAddressSpace(el.getAttribute("name"));
            int spaceid = spc.getSpaceID();
            spc = addrFactory.getConstantSpace();
            return spc.getAddress(spaceid);
        }
        if (localName.equals("iop")) {
            int ref = SpecXmlUtils.decodeInt((String)el.getAttribute("value"));
            AddressSpace spc = addrFactory.getConstantSpace();
            return spc.getAddress(ref);
        }
        String space = el.getAttribute("space");
        if (space == null) {
            return Address.NO_ADDRESS;
        }
        long offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
        AddressSpace spc = addrFactory.getAddressSpace(space);
        if (spc == null) {
            return null;
        }
        return spc.getAddress(offset);
    }

    public static Address readXML(String localName, Attributes attr, AddressFactory addrFactory) {
        if (localName.equals("spaceid")) {
            AddressSpace spc = addrFactory.getAddressSpace(attr.getValue("name"));
            int spaceid = spc.getSpaceID();
            spc = addrFactory.getConstantSpace();
            return spc.getAddress(spaceid);
        }
        if (localName.equals("iop")) {
            int ref = SpecXmlUtils.decodeInt((String)attr.getValue("value"));
            AddressSpace spc = addrFactory.getConstantSpace();
            return spc.getAddress(ref);
        }
        String space = attr.getValue("space");
        if (space == null) {
            return Address.NO_ADDRESS;
        }
        long offset = SpecXmlUtils.decodeLong((String)attr.getValue("offset"));
        AddressSpace spc = addrFactory.getAddressSpace(space);
        if (spc == null) {
            return Address.NO_ADDRESS;
        }
        return spc.getAddress(offset);
    }

    public static void appendAttributes(StringBuilder buf, Address addr) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isOverlaySpace() && space.getType() != 7) {
            space = space.getPhysicalSpace();
            addr = space.getAddress(addr.getOffset());
        }
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"space", (String)space.getName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"offset", (long)addr.getUnsignedOffset());
    }

    public static void appendAttributes(StringBuilder buf, Address addr, int size) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isOverlaySpace() && space.getType() != 7) {
            space = space.getPhysicalSpace();
            addr = space.getAddress(addr.getOffset());
        }
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"space", (String)space.getName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"offset", (long)addr.getUnsignedOffset());
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"size", (long)size);
    }

    public static void appendAttributes(StringBuilder buffer, Address startAddr, Address endAddr) {
        AddressSpace space = startAddr.getAddressSpace();
        long offset = startAddr.getOffset();
        long size = endAddr.getOffset() - offset + 1L;
        if (space != endAddr.getAddressSpace()) {
            throw new IllegalArgumentException("Range boundaries are not in the same address space");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("Start of range comes after end of range");
        }
        long last = offset + size - 1L;
        boolean useFirst = offset != 0L;
        boolean useLast = last != -1L;
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"space", (String)space.getName());
        if (useFirst) {
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"first", (long)offset);
        }
        if (useLast) {
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buffer, (String)"last", (long)last);
        }
    }

    public static void buildXML(StringBuilder buf, Address addr) {
        if (addr == null || addr == Address.NO_ADDRESS) {
            buf.append("<addr/>");
            return;
        }
        buf.append("<addr");
        AddressXML.appendAttributes(buf, addr);
        buf.append("/>");
    }

    public static void buildXML(StringBuilder buf, Address addr, int size) {
        buf.append("<addr");
        AddressXML.appendAttributes(buf, addr, size);
        buf.append("/>");
    }

    private static void buildVarnodePiece(StringBuilder buf, Address addr, int size) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isOverlaySpace()) {
            space = space.getPhysicalSpace();
            addr = space.getAddress(addr.getOffset());
        }
        buf.append(space.getName());
        buf.append(":0x");
        long off = addr.getUnsignedOffset();
        buf.append(Long.toHexString(off));
        buf.append(':');
        buf.append(Integer.toString(size));
    }

    public static void buildXML(StringBuilder buf, Varnode[] varnodes, long logicalsize) {
        if (varnodes == null) {
            buf.append("<addr/>");
            return;
        }
        if (varnodes.length == 1 && logicalsize == 0L) {
            AddressXML.buildXML(buf, varnodes[0].getAddress(), varnodes[0].getSize());
            return;
        }
        buf.append("<addr space=\"join\"");
        int piece = 0;
        for (Varnode vn : varnodes) {
            buf.append(" piece");
            buf.append(Integer.toString(++piece));
            buf.append("=\"");
            AddressXML.buildVarnodePiece(buf, vn.getAddress(), vn.getSize());
            buf.append("\"");
        }
        if (logicalsize != 0L) {
            buf.append(" logicalsize=\"").append(logicalsize).append('\"');
        }
        buf.append("/>");
    }
}

