/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.List;

public class InjectPayloadCallfixup
extends InjectPayloadSleigh {
    protected List<String> targetSymbolNames;

    protected InjectPayloadCallfixup(ConstructTpl pcode, InjectPayloadCallfixup failedPayload) {
        super(pcode, failedPayload);
        this.targetSymbolNames = failedPayload.targetSymbolNames;
    }

    protected InjectPayloadCallfixup(ConstructTpl pcode, String nm) {
        super(pcode, 1, nm);
        this.targetSymbolNames = new ArrayList<String>();
    }

    public InjectPayloadCallfixup(String sourceName) {
        super(sourceName);
        this.type = 1;
        this.targetSymbolNames = new ArrayList<String>();
    }

    public List<String> getTargets() {
        return this.targetSymbolNames;
    }

    @Override
    public void saveXml(StringBuilder buffer) {
        buffer.append("<callfixup");
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"name", (String)this.name);
        buffer.append(">\n");
        for (String nm : this.targetSymbolNames) {
            buffer.append("<target");
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"name", (String)nm);
            buffer.append("/>\n");
        }
        super.saveXml(buffer);
        buffer.append("</callfixup>\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage language) throws XmlParseException {
        XmlElement fixupEl = parser.start(new String[]{"callfixup"});
        this.name = fixupEl.getAttribute("name");
        boolean pcodeSubtag = false;
        while (parser.peek().isStart()) {
            String elname = parser.peek().getName();
            if (elname.equals("target")) {
                XmlElement subel = parser.start(new String[0]);
                String targetName = subel.getAttribute("name");
                if (targetName == null) {
                    throw new XmlParseException("Invalid callfixup target, missing target name");
                }
                this.targetSymbolNames.add(targetName);
                parser.end(subel);
                continue;
            }
            if (elname.equals("pcode")) {
                super.restoreXml(parser, language);
                pcodeSubtag = true;
                continue;
            }
            throw new XmlParseException("Unknown callfixup tag: " + elname);
        }
        if (!pcodeSubtag) {
            throw new XmlParseException("<callfixup> missing <pcode> subtag: " + this.name);
        }
        parser.end(fixupEl);
    }

    @Override
    public boolean equals(Object obj) {
        InjectPayloadCallfixup op2 = (InjectPayloadCallfixup)obj;
        if (!this.targetSymbolNames.equals(op2.targetSymbolNames)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = 13;
        for (String target : this.targetSymbolNames) {
            hash = 79 * hash + target.hashCode();
        }
        hash = 79 * hash + super.hashCode();
        return hash;
    }
}

