/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.LongLongDataType;

public class UnsignedLongLongDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final UnsignedLongLongDataType dataType = new UnsignedLongLongDataType();

    public UnsignedLongLongDataType() {
        this(null);
    }

    public UnsignedLongLongDataType(DataTypeManager dtm) {
        super("ulonglong", false, dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getLongLongSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Unsigned Long Long Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "unsigned long long";
    }

    @Override
    public LongLongDataType getOppositeSignednessDataType() {
        return LongLongDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public UnsignedLongLongDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new UnsignedLongLongDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this.getName(), "unsigned long long", false);
    }
}

