/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeAlignmentHelper;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionInternal;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class UnionDataType
extends CompositeDataTypeImpl
implements UnionInternal {
    private int unionLength;
    private int unionAlignment;
    private List<DataTypeComponentImpl> components = new ArrayList<DataTypeComponentImpl>();

    public UnionDataType(CategoryPath path, String name) {
        this(path, name, null);
    }

    public UnionDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    public UnionDataType(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
    }

    public UnionDataType(String name) {
        this(CategoryPath.ROOT, name);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Union>";
        }
        return "";
    }

    @Override
    public DataTypeComponent getComponent(int ordinal) {
        return this.components.get(ordinal);
    }

    @Override
    public DataTypeComponent[] getComponents() {
        return this.components.toArray(new DataTypeComponent[this.components.size()]);
    }

    @Override
    public DataTypeComponent[] getDefinedComponents() {
        return this.getComponents();
    }

    @Override
    public int getNumComponents() {
        return this.components.size();
    }

    @Override
    public int getNumDefinedComponents() {
        return this.components.size();
    }

    @Override
    protected int getPreferredComponentLength(DataType dataType, int length) {
        if (!(dataType instanceof Dynamic)) {
            length = -1;
        }
        return super.getPreferredComponentLength(dataType, length);
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String componentName, String comment) throws IllegalArgumentException {
        int oldAlignment = this.getAlignment();
        DataTypeComponent dtc = this.doAdd(dataType, length, componentName, comment);
        if (!this.repack(true) && this.isPackingEnabled() && oldAlignment != this.getAlignment()) {
            this.notifyAlignmentChanged();
        }
        return dtc;
    }

    private int getBitFieldAllocation(BitFieldDataType bitfieldDt) {
        BitFieldPacking bitFieldPacking = this.getDataOrganization().getBitFieldPacking();
        if (bitFieldPacking.useMSConvention()) {
            return bitfieldDt.getBaseTypeSize();
        }
        if (bitfieldDt.getBitSize() == 0) {
            return 0;
        }
        int length = bitfieldDt.getBaseTypeSize();
        if (this.packing > 0 && length > this.packing) {
            length = DataOrganizationImpl.getLeastCommonMultiple(bitfieldDt.getStorageSize(), this.packing);
        }
        return length;
    }

    DataTypeComponent doAdd(DataType dataType, int length, String componentName, String comment) throws IllegalArgumentException {
        dataType = this.validateDataType(dataType);
        dataType = this.adjustBitField(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, this.components.size(), 0, componentName, comment);
        dataType.addParent(this);
        this.components.add(dtc);
        return dtc;
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String componentName, String comment) throws IllegalArgumentException {
        dataType = this.validateDataType(dataType);
        int oldAlignment = this.getAlignment();
        dataType = this.adjustBitField(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, 0, componentName, comment);
        dataType.addParent(this);
        this.shiftOrdinals(ordinal, 1);
        this.components.add(ordinal, dtc);
        if (!this.repack(true) && this.isPackingEnabled() && oldAlignment != this.getAlignment()) {
            this.notifyAlignmentChanged();
        }
        return dtc;
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        return this.insertBitField(this.components.size(), baseDataType, bitSize, componentName, comment);
    }

    @Override
    public DataTypeComponent insertBitField(int ordinal, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, IndexOutOfBoundsException {
        if (ordinal < 0 || ordinal > this.components.size()) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        BitFieldDataType bitFieldDt = new BitFieldDataType(baseDataType, bitSize);
        return this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public boolean isZeroLength() {
        return this.unionLength == 0;
    }

    @Override
    public int getLength() {
        if (this.unionLength == 0) {
            return 1;
        }
        return this.unionLength;
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public Union clone(DataTypeManager dtm) {
        if (this.dataMgr == dtm) {
            return this;
        }
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public void delete(int ordinal) {
        int oldAlignment = this.getAlignment();
        DataTypeComponent dtc = this.components.remove(ordinal);
        dtc.getDataType().removeParent(this);
        this.shiftOrdinals(ordinal, -1);
        if (!this.repack(true) && this.isPackingEnabled() && oldAlignment != this.getAlignment()) {
            this.notifyAlignmentChanged();
        }
    }

    @Override
    public void delete(Set<Integer> ordinals) {
        if (ordinals.isEmpty()) {
            return;
        }
        int oldAlignment = this.getAlignment();
        ArrayList<DataTypeComponentImpl> newComponents = new ArrayList<DataTypeComponentImpl>();
        int newLength = 0;
        int ordinalAdjustment = 0;
        for (DataTypeComponentImpl dtc : this.components) {
            int ordinal = dtc.getOrdinal();
            if (ordinals.contains(ordinal)) {
                --ordinalAdjustment;
                continue;
            }
            if (ordinalAdjustment != 0) {
                dtc.setOrdinal(dtc.getOrdinal() + ordinalAdjustment);
            }
            newComponents.add(dtc);
            newLength = Math.max(newLength, dtc.getLength());
        }
        this.components = newComponents;
        if (this.isPackingEnabled()) {
            if (!this.repack(true) && oldAlignment != this.getAlignment()) {
                this.notifyAlignmentChanged();
            }
        } else {
            this.unionLength = newLength;
            this.notifySizeChanged();
        }
    }

    private DataType adjustBitField(DataType dataType) {
        if (!(dataType instanceof BitFieldDataType)) {
            return dataType;
        }
        BitFieldDataType bitfieldDt = (BitFieldDataType)dataType;
        DataType baseDataType = bitfieldDt.getBaseDataType();
        baseDataType = baseDataType.clone(this.dataMgr);
        int bitSize = bitfieldDt.getDeclaredBitSize();
        int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
        boolean bigEndian = this.getDataOrganization().isBigEndian();
        int storageBitOffset = 0;
        if (bigEndian) {
            if (bitSize == 0) {
                storageBitOffset = 7;
            } else {
                int storageSize = BitFieldDataType.getMinimumStorageSize(effectiveBitSize);
                storageBitOffset = 8 * storageSize - effectiveBitSize;
            }
        }
        if (effectiveBitSize != bitfieldDt.getBitSize() || storageBitOffset != bitfieldDt.getBitOffset()) {
            try {
                bitfieldDt = new BitFieldDataType(baseDataType, effectiveBitSize, storageBitOffset);
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                // empty catch block
            }
        }
        return bitfieldDt;
    }

    @Override
    public int getAlignment() {
        if (this.unionAlignment > 0) {
            return this.unionAlignment;
        }
        this.unionAlignment = this.isPackingEnabled() ? CompositeAlignmentHelper.getAlignment(this.getDataOrganization(), this) : this.getNonPackedAlignment();
        return this.unionAlignment;
    }

    @Override
    public boolean repack(boolean notify) {
        boolean changed;
        int oldLength = this.unionLength;
        int oldAlignment = this.getAlignment();
        this.unionLength = 0;
        for (DataTypeComponent dataTypeComponent : this.components) {
            int length = dataTypeComponent.getLength();
            if (this.isPackingEnabled() && dataTypeComponent.isBitFieldComponent()) {
                length = this.getBitFieldAllocation((BitFieldDataType)dataTypeComponent.getDataType());
            }
            this.unionLength = Math.max(length, this.unionLength);
        }
        this.unionAlignment = -1;
        this.getAlignment();
        if (this.isPackingEnabled()) {
            this.unionLength = DataOrganizationImpl.getAlignedOffset(this.unionAlignment, this.unionLength);
        }
        boolean bl = changed = oldLength != this.unionLength || oldAlignment != this.unionAlignment;
        if (changed && notify) {
            if (oldLength != this.unionLength) {
                this.notifySizeChanged();
            } else if (oldAlignment != this.unionAlignment) {
                this.notifyAlignmentChanged();
            }
        }
        return changed;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null) {
            return false;
        }
        if (dt instanceof UnionInternal) {
            DataTypeComponent[] otherComps;
            UnionInternal union = (UnionInternal)dt;
            if (this.packing != union.getStoredPackingValue() || this.minimumAlignment != union.getStoredMinimumAlignment()) {
                return false;
            }
            DataTypeComponent[] myComps = this.getComponents();
            if (myComps.length != (otherComps = union.getComponents()).length) {
                return false;
            }
            for (int i = 0; i < myComps.length; ++i) {
                if (myComps[i].isEquivalent(otherComps[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void shiftOrdinals(int ordinal, int deltaOrdinal) {
        for (int i = ordinal; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal);
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        if (!this.isPackingEnabled()) {
            return;
        }
        if (dt instanceof BitFieldDataType) {
            return;
        }
        boolean hasPossibleChange = false;
        for (DataTypeComponentImpl dtc : this.components) {
            if (dtc.getDataType() != dt) continue;
            hasPossibleChange = true;
            break;
        }
        if (hasPossibleChange && !this.repack(true) && this.isPackingEnabled()) {
            this.notifyAlignmentChanged();
        }
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt instanceof BitFieldDataType) {
            return;
        }
        boolean changed = false;
        for (DataTypeComponentImpl dtc : this.components) {
            int length;
            if (dtc.getDataType() != dt || (length = DataTypeComponent.usesZeroLengthComponent(dt) ? 0 : dt.getLength()) < 0 || length == dtc.getLength()) continue;
            dtc.setLength(length);
            changed = true;
        }
        if (changed && !this.repack(true) && this.isPackingEnabled()) {
            this.notifyAlignmentChanged();
        }
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) throws IllegalArgumentException {
        DataType replacementDt = newDt;
        try {
            this.validateDataType(replacementDt);
            if (replacementDt.getDataTypeManager() != this.dataMgr) {
                replacementDt = replacementDt.clone(this.dataMgr);
            }
            this.checkAncestry(replacementDt);
        }
        catch (Exception e) {
            replacementDt = DataType.DEFAULT;
        }
        boolean changed = false;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            boolean remove = false;
            if (dtc.isBitFieldComponent()) {
                try {
                    changed |= this.updateBitFieldDataType(dtc, oldDt, replacementDt);
                }
                catch (InvalidDataTypeException e) {
                    Msg.error((Object)this, (Object)("Invalid bitfield replacement type " + newDt.getName() + ", removing bitfield " + dtc.getDataType().getName() + ": " + this.getPathName()));
                    remove = true;
                }
            } else if (dtc.getDataType() == oldDt) {
                if (replacementDt == DEFAULT) {
                    Msg.error((Object)this, (Object)("Invalid replacement type " + newDt.getName() + ", removing component " + dtc.getDataType().getName() + ": " + this.getPathName()));
                    remove = true;
                } else {
                    int len;
                    int n = len = DataTypeComponent.usesZeroLengthComponent(newDt) ? 0 : newDt.getLength();
                    if (len < 0) {
                        len = dtc.getLength();
                    }
                    oldDt.removeParent(this);
                    dtc.setLength(len);
                    dtc.setDataType(replacementDt);
                    replacementDt.addParent(this);
                    changed = true;
                }
            }
            if (!remove) continue;
            oldDt.removeParent(this);
            this.components.remove(i);
            this.shiftOrdinals(i, -1);
            changed = true;
        }
        if (changed) {
            this.repack(false);
            this.notifySizeChanged();
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        boolean changed = false;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            boolean removeBitFieldComponent = false;
            if (dtc.isBitFieldComponent()) {
                BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                boolean bl = removeBitFieldComponent = bitfieldDt.getBaseDataType() == dt;
            }
            if (!removeBitFieldComponent && dtc.getDataType() != dt) continue;
            dt.removeParent(this);
            this.components.remove(i);
            this.shiftOrdinals(i, -1);
            changed = true;
        }
        if (changed && !this.repack(true) && this.isPackingEnabled()) {
            this.notifyAlignmentChanged();
        }
    }

    @Override
    public void replaceWith(DataType dataType) throws IllegalArgumentException {
        DataTypeComponent[] dataTypeComponentArray;
        if (!(dataType instanceof UnionInternal)) {
            throw new IllegalArgumentException();
        }
        UnionInternal union = (UnionInternal)dataType;
        for (DataTypeComponent dataTypeComponent : this.components) {
            dataTypeComponent.getDataType().removeParent(this);
        }
        this.components.clear();
        this.unionAlignment = -1;
        this.packing = union.getStoredPackingValue();
        this.minimumAlignment = union.getStoredMinimumAlignment();
        for (DataTypeComponent dtc : dataTypeComponentArray = union.getComponents()) {
            DataType dt = dtc.getDataType();
            this.doAdd(dt, dtc.getLength(), dtc.getFieldName(), dtc.getComment());
        }
        this.repack(false);
        this.notifySizeChanged();
    }

    @Override
    public boolean dependsOn(DataType dt) {
        if (this.getNumComponents() == 1) {
            DataTypeComponent dtc = this.getComponent(0);
            return dtc.getDataType().dependsOn(dt);
        }
        return false;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "UNION_" + this.getName();
    }
}

