/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassTranslator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FileTimeDataType
extends BuiltIn {
    private static final SimpleDateFormat formatter;
    private static Date epochData;

    public FileTimeDataType() {
        this(null);
    }

    public FileTimeDataType(DataTypeManager dtm) {
        super(null, "FileTime", dtm);
    }

    @Override
    public String getDescription() {
        return "The stamp follows the Filetime-measurement scheme (that is, the number of 100 nanosecond ticks measured from midnight January 1, 1601).";
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "FileTime";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (epochData == null) {
            return "unparsed date";
        }
        try {
            long numTicks = buf.getLong(0);
            long numMilliSeconds = numTicks / 10000L;
            long start = 0L - epochData.getTime();
            Date date = new Date(numMilliSeconds - start);
            long fractionalPartPlus1e8 = numTicks % 10000000L + 100000000L;
            String fractionalPart = Long.toString(fractionalPartPlus1e8).substring(1);
            return formatter.format(date) + "." + fractionalPart + " UTC";
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            long numTicks = buf.getLong(0);
            return new Long(numTicks);
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Long.class;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new FileTimeDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.FileTime", (String)FileTimeDataType.class.getName());
        formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            epochData = formatter.parse("1601-01-01 00:00:00");
        }
        catch (Exception e) {
            Msg.error(FileTimeDataType.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }
}

