/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceImpl;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;

public class SimpleSourceReferenceIterator
implements CodeBlockReferenceIterator {
    private LinkedList<CodeBlockReferenceImpl> blockRefQueue = new LinkedList();
    private TaskMonitor monitor;

    public SimpleSourceReferenceIterator(CodeBlock block, boolean followIndirectFlows, TaskMonitor monitor) throws CancelledException {
        this.monitor = monitor;
        SimpleSourceReferenceIterator.getSources(block, this.blockRefQueue, followIndirectFlows, monitor);
    }

    @Override
    public CodeBlockReference next() throws CancelledException {
        this.monitor.checkCanceled();
        return this.blockRefQueue.isEmpty() ? null : (CodeBlockReference)this.blockRefQueue.removeFirst();
    }

    @Override
    public boolean hasNext() throws CancelledException {
        this.monitor.checkCanceled();
        return !this.blockRefQueue.isEmpty();
    }

    @Deprecated
    public static int getNumSources(CodeBlock block, boolean followIndirectFlows, TaskMonitor monitor) throws CancelledException {
        return SimpleSourceReferenceIterator.getSources(block, null, followIndirectFlows, monitor);
    }

    private static int getSources(CodeBlock block, LinkedList<CodeBlockReferenceImpl> blockRefQueue, boolean followIndirectFlows, TaskMonitor monitor) throws CancelledException {
        Address fallAddr;
        if (block == null) {
            return 0;
        }
        CodeBlockModel m = block.getModel();
        if (!(m instanceof SimpleBlockModel)) {
            throw new IllegalArgumentException();
        }
        SimpleBlockModel model = (SimpleBlockModel)m;
        Address start = block.getMinAddress();
        if (start == null) {
            return 0;
        }
        int count = 0;
        Listing listing = model.getListing();
        Instruction instr = listing.getInstructionAt(start);
        ReferenceManager refMgr = model.getProgram().getReferenceManager();
        Address[] entryPts = block.getStartAddresses();
        for (int n = 0; n < entryPts.length; ++n) {
            ReferenceIterator iter = refMgr.getReferencesTo(entryPts[n]);
            while (iter.hasNext()) {
                Reference ref = iter.next();
                RefType refType = ref.getReferenceType();
                if (monitor != null && monitor.isCancelled()) {
                    throw new CancelledException();
                }
                if (refType.isFlow()) {
                    SimpleSourceReferenceIterator.queueDestReference(blockRefQueue, block, entryPts[n], ref.getFromAddress(), (FlowType)refType, monitor);
                    ++count;
                    continue;
                }
                if (!followIndirectFlows || instr == null && !start.isExternalAddress()) continue;
                int cnt = SimpleSourceReferenceIterator.followIndirection(blockRefQueue, block, ref, monitor);
                count += cnt;
            }
        }
        if (instr != null && (fallAddr = instr.getFallFrom()) != null) {
            SimpleSourceReferenceIterator.queueDestReference(blockRefQueue, block, start, fallAddr, RefType.FALL_THROUGH, monitor);
            ++count;
        }
        return count;
    }

    private static int followIndirection(LinkedList<CodeBlockReferenceImpl> blockRefQueue, CodeBlock destBlock, Reference destRef, TaskMonitor monitor) throws CancelledException {
        SimpleBlockModel model = (SimpleBlockModel)destBlock.getModel();
        Address addr = destRef.getFromAddress();
        Listing listing = model.getListing();
        Data data = listing.getDefinedDataContaining(addr);
        if (data == null) {
            return 0;
        }
        int cnt = 0;
        int offset = (int)addr.subtract(data.getMinAddress());
        Data primitive = data.getPrimitiveAt(offset);
        if (primitive != null) {
            ReferenceIterator iter = primitive.getReferenceIteratorTo();
            while (iter.hasNext()) {
                Address fromAddr;
                Instruction instr;
                Reference ref = iter.next();
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                RefType rt = ref.getReferenceType();
                if (rt != RefType.INDIRECTION && rt != RefType.READ || (instr = listing.getInstructionAt(fromAddr = ref.getFromAddress())) == null || rt == RefType.READ && !instr.getFlowType().isComputed()) continue;
                SimpleSourceReferenceIterator.queueDestReference(blockRefQueue, destBlock, destRef.getToAddress(), fromAddr, instr.getFlowType().isCall() ? RefType.COMPUTED_CALL : RefType.COMPUTED_JUMP, monitor);
                ++cnt;
            }
        }
        return cnt;
    }

    private static void queueDestReference(LinkedList<CodeBlockReferenceImpl> blockRefQueue, CodeBlock destBlock, Address toAddr, Address fromAddr, FlowType flowType, TaskMonitor monitor) {
        if (blockRefQueue == null) {
            return;
        }
        blockRefQueue.add(new CodeBlockReferenceImpl(null, destBlock, flowType, toAddr, fromAddr));
    }
}

