/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;

public class UniqueAddressFactory {
    private AddressFactory addrFactory;
    private AddressSpace uniqueSpace;
    private final long firstAvailableOffset;
    private long nextOffset;

    public UniqueAddressFactory(AddressFactory addrFactory, Language language) {
        this.addrFactory = addrFactory;
        this.uniqueSpace = addrFactory.getUniqueSpace();
        this.firstAvailableOffset = language instanceof SleighLanguage ? ((SleighLanguage)language).getUniqueBase() : 0L;
        this.nextOffset = this.firstAvailableOffset;
    }

    public synchronized Address getNextUniqueAddress() {
        Address addr = this.uniqueSpace.getAddress(this.nextOffset);
        this.nextOffset += 128L;
        return addr;
    }

    public synchronized void reset() {
        this.nextOffset = this.firstAvailableOffset;
    }

    public AddressFactory getAddressFactory() {
        return this.addrFactory;
    }
}

