/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;

public class GlobalRegisterSymbol
extends SymbolDB {
    public GlobalRegisterSymbol(SymbolManager mgr, DBObjectCache<SymbolDB> cache, Address addr, DBRecord record) {
        super(mgr, cache, addr, record);
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.GLOBAL_VAR;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public Object getObject() {
        Register reg = this.symbolMgr.getProgram().getRegister(this.getAddress());
        return reg;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return SymbolType.GLOBAL_VAR.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }
}

