/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class RelocationDBAdapterV2
extends RelocationDBAdapter {
    static final int VERSION = 2;
    private Table relocTable;
    private AddressMap addrMap;

    RelocationDBAdapterV2(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.relocTable = handle.getTable("Relocations");
        if (this.relocTable == null) {
            throw new VersionException("Missing Table: Relocations");
        }
        if (this.relocTable.getSchema().getVersion() != 2) {
            throw new VersionException(false);
        }
    }

    @Override
    void add(long addrKey, int type, long[] values, byte[] bytes, String symbolName) {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord get(long addrKey) throws IOException {
        return this.relocTable.getRecord(addrKey);
    }

    @Override
    int getRecordCount() {
        return this.relocTable.getRecordCount();
    }

    @Override
    int getVersion() {
        return 2;
    }

    @Override
    void remove(long addrKey) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator iterator() throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    RecordIterator iterator(AddressSetView set) throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap, set, set.getMinAddress(), true);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    RecordIterator iterator(Address start) throws IOException {
        AddressKeyRecordIterator recIter = new AddressKeyRecordIterator(this.relocTable, this.addrMap, start, true);
        return new RelocationDBAdapter.RecordIteratorAdapter(this, recIter);
    }

    @Override
    DBRecord adaptRecord(DBRecord rec) {
        DBRecord newRec = SCHEMA.createRecord(rec.getKey());
        newRec.setIntValue(0, rec.getIntValue(0));
        long[] values = new long[]{rec.getLongValue(1)};
        newRec.setField(1, (Field)new BinaryCodedField(values));
        newRec.setBinaryData(2, null);
        return newRec;
    }
}

