/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Schema;
import db.StringField;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.EnumDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class EnumDBAdapterV0
extends EnumDBAdapter
implements RecordTranslator {
    static final int VERSION = 0;
    static final int V0_ENUM_NAME_COL = 0;
    static final int V0_ENUM_COMMENT_COL = 1;
    static final int V0_ENUM_CAT_COL = 2;
    static final int V0_ENUM_SIZE_COL = 3;
    static final Schema V0_ENUM_SCHEMA = new Schema(0, "Enum ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, ByteField.INSTANCE}, new String[]{"Name", "Comment", "Category ID", "Size"});
    private Table enumTable;

    public EnumDBAdapterV0(DBHandle handle) throws VersionException {
        this.enumTable = handle.getTable("Enumeration Data Types");
        if (this.enumTable == null) {
            throw new VersionException("Missing Table: Enumeration Data Types");
        }
        int version = this.enumTable.getSchema().getVersion();
        if (version != 0) {
            String msg = "Expected version 0 for table Enumeration Data Types but got " + this.enumTable.getSchema().getVersion();
            if (version < 0) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    public DBRecord createRecord(String name, String comments, long categoryID, byte size, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        throw new UnsupportedOperationException("Not allowed to update prior version #0 of Enumeration Data Types table.");
    }

    @Override
    public DBRecord getRecord(long enumID) throws IOException {
        return this.translateRecord(this.enumTable.getRecord(enumID));
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.enumTable.iterator(), (RecordTranslator)this);
    }

    @Override
    public void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long enumID) throws IOException {
        return this.enumTable.deleteRecord(enumID);
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Enumeration Data Types");
    }

    @Override
    public Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.enumTable.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return Field.EMPTY_ARRAY;
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = EnumDBAdapter.ENUM_SCHEMA.createRecord(oldRec.getKey());
        rec.setString(0, oldRec.getString(0));
        rec.setString(1, oldRec.getString(1));
        rec.setLongValue(2, oldRec.getLongValue(2));
        rec.setByteValue(3, oldRec.getByteValue(3));
        rec.setLongValue(4, 0L);
        rec.setLongValue(5, UniversalIdGenerator.nextID().getValue());
        rec.setLongValue(6, 0L);
        rec.setLongValue(7, 0L);
        return rec;
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        return null;
    }
}

