/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.MessageFormattingUtils;
import ghidra.pcodeCPort.slghpattern.DisjointPattern;
import ghidra.pcodeCPort.slghsymbol.Constructor;

public class DecisionProperties {
    private VectorSTL<String> identerrors = new VectorSTL();
    private VectorSTL<String> conflicterrors = new VectorSTL();

    public VectorSTL<String> getIdentErrors() {
        return this.identerrors;
    }

    public VectorSTL<String> getConflictErrors() {
        return this.conflicterrors;
    }

    public void identicalPattern(Constructor a, Constructor b) {
        if (!a.isError() && !b.isError()) {
            a.setError(true);
            b.setError(true);
            String msg = "Constructors with identical patterns:\n   " + a + "\n   " + b;
            this.identerrors.push_back((Object)MessageFormattingUtils.format(a.location, msg));
            this.identerrors.push_back((Object)MessageFormattingUtils.format(b.location, msg));
        }
    }

    public void conflictingPattern(DisjointPattern pa, Constructor a, DisjointPattern pb, Constructor b) {
        if (!a.isError() && !b.isError()) {
            a.setError(true);
            b.setError(true);
            String msg = "Constructor patterns cannot be distinguished: \n   " + pa + " " + a + "\n   " + pb + " " + b;
            this.conflicterrors.push_back((Object)MessageFormattingUtils.format(a.location, msg));
            this.conflicterrors.push_back((Object)MessageFormattingUtils.format(b.location, msg));
        }
    }
}

