/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.MicrosoftDemanglerAnalyzer;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorControl;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.WrappingTaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class LoadPdbTask
extends Task {
    private File pdbFile;
    private DataTypeManagerService service;
    private final Program program;
    private final boolean useMsDiaParser;
    private final PdbApplicatorControl control;
    private String resultMessages;
    private Exception resultException;

    LoadPdbTask(Program program, File pdbFile, boolean useMsDiaParser, PdbApplicatorControl control, DataTypeManagerService service) {
        super("Load PDB", true, false, true, true);
        this.program = program;
        this.pdbFile = pdbFile;
        this.useMsDiaParser = useMsDiaParser;
        this.control = control;
        this.service = service;
    }

    public void run(TaskMonitor monitor) {
        final WrappingTaskMonitor wrappedMonitor = new WrappingTaskMonitor(monitor){

            public void initialize(long max) {
            }
        };
        final MessageLog log = new MessageLog();
        AnalysisWorker worker = new AnalysisWorker(){

            public String getWorkerName() {
                return "Load PDB";
            }

            public boolean analysisWorkerCallback(Program currentProgram, Object workerContext, TaskMonitor currentMonitor) throws CancelledException {
                try {
                    if (LoadPdbTask.this.useMsDiaParser ? !LoadPdbTask.this.parseWithMsDiaParser(log, (TaskMonitor)wrappedMonitor) : !LoadPdbTask.this.parseWithNewParser(log, (TaskMonitor)wrappedMonitor)) {
                        return false;
                    }
                    LoadPdbTask.this.analyzeSymbols(currentMonitor, log);
                }
                catch (IOException e) {
                    log.appendMsg("PDB IO Error: " + e.getMessage());
                }
                return false;
            }
        };
        try {
            AutoAnalysisManager.getAnalysisManager((Program)this.program).scheduleWorker(worker, null, true, (TaskMonitor)wrappedMonitor);
        }
        catch (CancelledException | InterruptedException throwable) {
        }
        catch (InvocationTargetException e) {
            this.resultException = e;
        }
        if (log.hasMessages()) {
            this.resultMessages = log.toString();
        }
    }

    String getResultMessages() {
        return this.resultMessages;
    }

    Exception getResultException() {
        return this.resultException;
    }

    private boolean parseWithMsDiaParser(MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ghidra.app.util.bin.format.pdb.PdbParser parser = new ghidra.app.util.bin.format.pdb.PdbParser(this.pdbFile, this.program, this.service, true, true, monitor);
        try {
            parser.parse();
            parser.openDataTypeArchives();
            parser.applyTo(log);
            return true;
        }
        catch (DuplicateIdException | PdbException e) {
            log.appendMsg("PDB Error: " + e.getMessage());
            return false;
        }
    }

    private boolean parseWithNewParser(MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        boolean bl;
        block8: {
            PdbReaderOptions pdbReaderOptions = new PdbReaderOptions();
            PdbApplicatorOptions pdbApplicatorOptions = new PdbApplicatorOptions();
            pdbApplicatorOptions.setProcessingControl(this.control);
            AbstractPdb pdb = PdbParser.parse(this.pdbFile.getAbsolutePath(), pdbReaderOptions, monitor);
            try {
                monitor.setMessage("PDB: Parsing " + this.pdbFile + "...");
                pdb.deserialize(monitor);
                PdbApplicator applicator = new PdbApplicator(this.pdbFile.getAbsolutePath(), pdb);
                applicator.applyTo(this.program, (DataTypeManager)this.program.getDataTypeManager(), this.program.getImageBase(), pdbApplicatorOptions, monitor, log);
                bl = true;
                if (pdb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pdb != null) {
                        try {
                            pdb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ghidra.app.util.bin.format.pdb2.pdbreader.PdbException e) {
                    log.appendMsg("PDB Error: " + e.getMessage());
                    return false;
                }
            }
            pdb.close();
        }
        return bl;
    }

    private void analyzeSymbols(TaskMonitor monitor, MessageLog log) {
        MicrosoftDemanglerAnalyzer demanglerAnalyzer = new MicrosoftDemanglerAnalyzer();
        String analyzerName = demanglerAnalyzer.getName();
        Options analysisProperties = this.program.getOptions("Analyzers");
        String defaultValueAsString = analysisProperties.getValueAsString(analyzerName);
        boolean doDemangle = true;
        if (defaultValueAsString != null) {
            doDemangle = Boolean.parseBoolean(defaultValueAsString);
        }
        if (doDemangle) {
            Memory addrs = this.program.getMemory();
            monitor.initialize(addrs.getNumAddresses());
            try {
                demanglerAnalyzer.added(this.program, (AddressSetView)addrs, monitor, log);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
    }
}

