/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VtShapeDescriptorMsProperty;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VtShapeMsType;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbUniversalMember;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class VtShapeTypeApplier
extends MsTypeApplier {
    public VtShapeTypeApplier(PdbApplicator applicator, VtShapeMsType msType) {
        super(applicator, msType);
    }

    @Override
    BigInteger getSize() {
        return BigInteger.valueOf(this.applicator.getDataOrganization().getPointerSize() * ((VtShapeMsType)this.msType).getCount());
    }

    String getName() {
        return "vtshape_" + this.index;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.dataType = this.createVtShape((VtShapeMsType)this.msType);
    }

    private DataType createVtShape(VtShapeMsType msShape) throws CancelledException {
        List<VtShapeDescriptorMsProperty> list = msShape.getDescriptorList();
        StructureDataType shape = new StructureDataType(this.applicator.getAnonymousTypesCategory(), "vtshape" + this.index, 0, this.applicator.getDataTypeManager());
        ArrayList<DefaultPdbUniversalMember> members = new ArrayList<DefaultPdbUniversalMember>();
        int offset = 0;
        for (VtShapeDescriptorMsProperty descriptor : list) {
            switch (descriptor) {
                case NEAR: 
                case FAR: 
                case THIN: 
                case OUTER: 
                case META: 
                case NEAR32: 
                case FAR32: {
                    PointerDataType pointer = new PointerDataType(this.applicator.getDataTypeManager());
                    DefaultPdbUniversalMember member = new DefaultPdbUniversalMember(this.applicator, "", (DataType)pointer, offset);
                    offset += pointer.getLength();
                    members.add(member);
                    break;
                }
                case UNUSED: {
                    offset += this.applicator.getDataOrganization().getPointerSize();
                }
            }
        }
        int size = this.applicator.getDataOrganization().getPointerSize() * msShape.getCount();
        if (!DefaultCompositeMember.applyDataTypeMembers((Composite)shape, false, size, members, msg -> Msg.warn((Object)this, (Object)msg), this.applicator.getCancelOnlyWrappingMonitor())) {
            CompositeTypeApplier.clearComponents((Composite)shape);
        }
        return shape;
    }
}

