/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.TrampolineMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class TrampolineSymbolApplier
extends MsSymbolApplier {
    private TrampolineMsSymbol symbol;

    public TrampolineSymbolApplier(PdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof TrampolineMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (TrampolineMsSymbol)abstractSymbol;
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws CancelledException, PdbException {
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        Address targetAddress = this.applicator.getAddress(this.symbol.getSegmentTarget(), this.symbol.getOffsetTarget());
        Function target = null;
        Function thunk = null;
        if (!this.applicator.isInvalidAddress(targetAddress, "thunk target")) {
            target = this.createNewFunction(targetAddress, 1L);
        }
        if (!this.applicator.isInvalidAddress(symbolAddress, "thunk symbol")) {
            thunk = this.createNewFunction(symbolAddress, this.symbol.getSizeOfThunk());
        }
        if (target != null && thunk != null) {
            thunk.setThunkedFunction(target);
        }
    }

    private Function createNewFunction(Address startAddress, long size) {
        Function function;
        AddressSet addressSet = new AddressSet(startAddress, startAddress.add(size));
        if (this.applicator.getProgram().getListing().getInstructionAt(startAddress) == null) {
            DisassembleCommand cmd = new DisassembleCommand((AddressSetView)addressSet, null, true);
            cmd.applyTo((DomainObject)this.applicator.getProgram(), this.applicator.getCancelOnlyWrappingMonitor());
        }
        if ((function = this.applicator.getProgram().getListing().getFunctionAt(startAddress)) != null) {
            return function;
        }
        CreateFunctionCmd funCmd = new CreateFunctionCmd(startAddress);
        if (!funCmd.applyTo((DomainObject)this.applicator.getProgram(), this.applicator.getCancelOnlyWrappingMonitor())) {
            this.applicator.appendLogMsg("Failed to apply function at address " + startAddress.toString() + "; attempting to use possible existing function");
        }
        return funCmd.getFunction();
    }
}

