/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public abstract class AbstractCobol0MsType
extends AbstractMsType {
    protected RecordNumber parentRecordNumber;
    protected byte[] data;

    public AbstractCobol0MsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize) throws PdbException {
        super(pdb, reader);
        this.parentRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.data = reader.parseBytesRemaining();
    }

    public RecordNumber getParentRecordNumber() {
        return this.parentRecordNumber;
    }

    public AbstractMsType getParentType() {
        return this.pdb.getTypeRecord(this.parentRecordNumber);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("Cobol0MsType\n");
        builder.append(String.format("  parent type index: %s\n", this.getParentType()));
        builder.append(String.format("  additional data length: %d\n", this.data.length));
    }
}

