/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DebugData;
import ghidra.app.util.bin.format.pdb2.pdbreader.Hasher;
import ghidra.app.util.bin.format.pdb2.pdbreader.Hasher32;
import ghidra.app.util.bin.format.pdb2.pdbreader.Hasher32V2;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageFileMachine;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation600;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class PdbNewDebugInfo
extends PdbDebugInfo {
    private static final long HEADER_MAGIC = 0xEFFEEFFEL;
    private static final int DBI_HEADER_LENGTH = 64;
    protected Hasher hasher;
    protected long versionSignature = 0L;
    protected long dbiAge = 0L;
    protected int universalVersion = 0;
    protected int pdbDllBuildVersion = 0;
    protected int pdbDllReleaseBuildVersion = 0;
    protected int lengthTypeServerMapSubstream = 0;
    protected long indexOfMicrosoftFoundationClassTypeServer = 0L;
    protected int lengthOptionalDebugHeader = 0;
    protected int lengthEditAndContinueSubstream = 0;
    protected int flags = 0;
    protected ImageFileMachine machineType;
    protected long padReserve = 0L;
    protected List<String> editAndContinueNameList = new ArrayList<String>();
    protected List<Integer> debugStreamList = new ArrayList<Integer>();
    protected DebugData debugData;

    public PdbNewDebugInfo(AbstractPdb pdb, int streamNumber) {
        super(pdb, streamNumber);
        this.debugData = new DebugData(pdb);
    }

    public ImageFileMachine getMachineType() {
        return this.machineType;
    }

    public DebugData getDebugData() {
        return this.debugData;
    }

    @Override
    protected void deserializeHeader(PdbByteReader reader) throws PdbException {
        this.versionSignature = reader.parseUnsignedIntVal();
        this.versionNumber = reader.parseUnsignedIntVal();
        this.dbiAge = reader.parseUnsignedIntVal();
        this.streamNumberGlobalStaticSymbolsHashMaybe = reader.parseUnsignedShortVal();
        this.universalVersion = reader.parseUnsignedShortVal();
        this.streamNumberPublicStaticSymbolsHashMaybe = reader.parseUnsignedShortVal();
        this.pdbDllBuildVersion = reader.parseUnsignedShortVal();
        this.streamNumberSymbolRecords = reader.parseUnsignedShortVal();
        this.pdbDllReleaseBuildVersion = reader.parseUnsignedShortVal();
        this.lengthModuleInformationSubstream = reader.parseInt();
        this.lengthSectionContributionSubstream = reader.parseInt();
        this.lengthSectionMap = reader.parseInt();
        this.lengthFileInformation = reader.parseInt();
        this.lengthTypeServerMapSubstream = reader.parseInt();
        this.indexOfMicrosoftFoundationClassTypeServer = reader.parseUnsignedIntVal();
        this.lengthOptionalDebugHeader = reader.parseInt();
        this.lengthEditAndContinueSubstream = reader.parseInt();
        this.flags = reader.parseUnsignedShortVal();
        this.machineType = ImageFileMachine.fromValue(reader.parseUnsignedShortVal());
        this.padReserve = reader.parseUnsignedIntVal();
        this.pdb.setTargetProcessor(this.machineType.getProcessor());
        this.pdb.setDbiAge((int)this.dbiAge);
    }

    @Override
    protected int getHeaderLength() {
        return 64;
    }

    @Override
    protected void deserializeInternalSubstreams(PdbByteReader reader, TaskMonitor monitor) throws PdbException, CancelledException {
        this.processModuleInformation(reader, monitor, false);
        this.processSectionContributions(reader, monitor, false);
        this.processSegmentMap(reader, monitor, false);
        this.processFileInformation(reader, monitor, false);
        this.processTypeServerMap(reader, false);
        this.processEditAndContinueInformation(reader, monitor, false);
        this.debugData.deserializeHeader(reader, monitor);
    }

    @Override
    protected void deserializeAdditionalSubstreams(TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        this.symbolRecords.deserialize(monitor);
        this.globalSymbolInformation.deserialize(this.getGlobalSymbolsHashMaybeStreamNumber(), monitor);
        this.publicSymbolInformation.deserialize(this.getPublicStaticSymbolsHashMaybeStreamNumber(), monitor);
        this.debugData.deserialize(monitor);
    }

    @Override
    protected void processModuleInformation(PdbByteReader reader, TaskMonitor monitor, boolean skip) throws PdbException, CancelledException {
        if (this.lengthModuleInformationSubstream == 0) {
            return;
        }
        if (skip) {
            reader.skip(this.lengthModuleInformationSubstream);
            return;
        }
        PdbByteReader substreamReader = reader.getSubPdbByteReader(this.lengthModuleInformationSubstream);
        while (substreamReader.hasMore()) {
            monitor.checkCanceled();
            ModuleInformation600 moduleInformation = new ModuleInformation600(this.pdb);
            moduleInformation.deserialize(substreamReader);
            this.moduleInformationList.add(moduleInformation);
        }
    }

    @Override
    protected String parseFileInfoName(PdbByteReader reader) throws PdbException {
        String filename = reader.parseString(this.pdb, StringParseType.StringNt);
        return filename;
    }

    @Override
    protected void dumpHeader(Writer writer) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("versionSignature: ");
        builder.append(this.versionSignature);
        builder.append("\nversionNumber: ");
        builder.append(this.versionNumber);
        builder.append("\nage: ");
        builder.append(this.dbiAge);
        builder.append("\nstreamNumberGlobalStaticSymbols: ");
        builder.append(this.streamNumberGlobalStaticSymbolsHashMaybe);
        builder.append(String.format("\nuniversalVersion: 0x%04x", this.universalVersion));
        builder.append("\nstreamNumberPublicStaticSymbols: ");
        builder.append(this.streamNumberPublicStaticSymbolsHashMaybe);
        builder.append(String.format("\npdbDllBuildVersion: 0x%04x", this.pdbDllBuildVersion));
        builder.append("\nstreamNumberSymbolRecords: ");
        builder.append(this.streamNumberSymbolRecords);
        builder.append(String.format("\npdbDllReleaseBuildVersion: 0x%04x", this.pdbDllReleaseBuildVersion));
        builder.append("\nlengthModuleInformationSubstream: ");
        builder.append(this.lengthModuleInformationSubstream);
        builder.append("\nlengthSectionContributionSubstream: ");
        builder.append(this.lengthSectionContributionSubstream);
        builder.append("\nlengthSectionMap: ");
        builder.append(this.lengthSectionMap);
        builder.append("\nlengthFileInformation: ");
        builder.append(this.lengthFileInformation);
        builder.append("\nlengthTypeServerMapSubstream: ");
        builder.append(this.lengthTypeServerMapSubstream);
        builder.append("\nindexOfMicrosoftFoundationClassTypeServer: ");
        builder.append(this.indexOfMicrosoftFoundationClassTypeServer);
        builder.append("\nlengthOptionalDebugHeader: ");
        builder.append(this.lengthOptionalDebugHeader);
        builder.append("\nlengthEditAndContinueSubstream: ");
        builder.append(this.lengthEditAndContinueSubstream);
        builder.append(String.format("\nflags: 0x%04x", this.flags));
        builder.append(String.format("\nmachineType: %s", this.machineType.toString()));
        builder.append("\npadReserve: ");
        builder.append(this.padReserve);
        writer.write(builder.toString());
    }

    @Override
    protected void dumpInternalSubstreams(Writer writer) throws IOException {
        writer.write("ModuleInformationList---------------------------------------\n");
        this.dumpModuleInformation(writer);
        writer.write("\nEnd ModuleInformationList-----------------------------------\n");
        writer.write("SectionContributionList-------------------------------------\n");
        this.dumpSectionContributions(writer);
        writer.write("\nEnd SectionContributionList---------------------------------\n");
        writer.write("SegmentMap--------------------------------------------------\n");
        this.dumpSegmentMap(writer);
        writer.write("\nEnd SegmentMap----------------------------------------------\n");
        writer.write("EditAndContinueNameList-------------------------------------\n");
        this.dumpEditAndContinueNameList(writer);
        writer.write("\nEnd EditAndContinueNameList---------------------------------\n");
        this.debugData.dump(writer);
    }

    protected void processTypeServerMap(PdbByteReader reader, boolean skip) throws PdbException {
        if (this.lengthTypeServerMapSubstream == 0) {
            return;
        }
        if (skip) {
            reader.skip(this.lengthTypeServerMapSubstream);
            return;
        }
        PdbByteReader substreamReader = reader.getSubPdbByteReader(this.lengthTypeServerMapSubstream);
    }

    protected void processEditAndContinueInformation(PdbByteReader reader, TaskMonitor monitor, boolean skip) throws PdbException, CancelledException {
        int tableSize;
        if (this.lengthEditAndContinueSubstream == 0) {
            return;
        }
        if (skip) {
            reader.skip(this.lengthEditAndContinueSubstream);
            return;
        }
        PdbByteReader substreamReader = reader.getSubPdbByteReader(this.lengthEditAndContinueSubstream);
        long hdr = substreamReader.parseUnsignedIntVal();
        int ver = substreamReader.parseInt();
        if (hdr != 0xEFFEEFFEL) {
            return;
        }
        switch (ver) {
            case 1: {
                this.hasher = new Hasher32();
                break;
            }
            case 2: {
                this.hasher = new Hasher32V2();
                break;
            }
            default: {
                return;
            }
        }
        int length = substreamReader.parseInt();
        PdbByteReader bufferReader = substreamReader.getSubPdbByteReader(length);
        int count = tableSize = substreamReader.parseInt();
        int realEntryCount = 0;
        while (--count >= 0) {
            monitor.checkCanceled();
            int offset = substreamReader.parseInt();
            bufferReader.setIndex(offset);
            String name = bufferReader.parseNullTerminatedString(this.pdb.getPdbReaderOptions().getOneByteCharset());
            if (name.length() != 0) {
                ++realEntryCount;
            }
            this.editAndContinueNameList.add(name);
            long hashVal = name.length() == 0 ? 0L : this.hasher.hash(name, 0xFFFFFFFFL);
            hashVal %= (long)tableSize;
        }
        int numRealEntries = substreamReader.parseInt();
        if (realEntryCount != numRealEntries) {
            throw new PdbException("Count mismatch: " + realEntryCount + " vs. " + numRealEntries);
        }
    }

    protected void dumpEditAndContinueNameList(Writer writer) throws IOException {
        for (String name : this.editAndContinueNameList) {
            writer.write(String.format("Name: %s\n", name));
        }
    }

    long getAge() {
        return this.dbiAge;
    }
}

