/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.Processor;
import java.util.HashMap;
import java.util.Map;

public enum ImageFileMachine {
    UNKNOWN("Unknown", 0, Processor.UNKNOWN),
    TARGET_HOST("Interacts with the host and not a WOW64 guest", 1, Processor.UNKNOWN),
    I386("Intel 386", 332, Processor.I80386),
    I860("Intel I860", 333, Processor.UNKNOWN),
    R3000("MIPS little-endian, 0x160 big-endian", 354, Processor.MIPS_MIPSR4000),
    R4000("MIPS little-endian", 358, Processor.MIPS_MIPSR4000),
    R10000("MIPS little-endian", 360, Processor.MIPS_MIPSR4000),
    WCEMIPSV2("MIPS little-endian WCE v2", 361, Processor.MIPS_MIPSR4000),
    ALPHA("Alpha_AXP", 388, Processor.ALPHA_21064),
    SH3("SH3 little-endian", 418, Processor.SH3),
    SH3DSP("SH3DSP", 419, Processor.SH3DSP),
    SH3E("SH3E little-endian", 420, Processor.SH3),
    SH4("SH4 little-endian", 422, Processor.SH4),
    SH5("SH5", 424, Processor.SH4),
    ARM("ARM Little-Endian", 448, Processor.ARM3),
    THUMB("ARM Thumb/Thumb-2 Little-Endian", 450, Processor.THUMB),
    ARMNT("ARM Thumb-2 Little-Endian", 452, Processor.ARMNT),
    AM33("TAM33BD", 467, Processor.AM33),
    POWERPC("IBM PowerPC Little-Endian", 496, Processor.PPC601),
    POWERPCFP("POWERPCFP", 497, Processor.PPCFP),
    POWERPCBE("POWERPCBE", 498, Processor.PPCBE),
    IA64("Intel 64", 512, Processor.IA64_IA64_1),
    M68K("Motorola 68000", 616, Processor.M68000),
    MIPS16("MIPS16", 614, Processor.MIPS16),
    ALPHA64("ALPHA64", 644, Processor.ALPHA_21064),
    MIPSFPU("MIPSFPU", 870, Processor.MIPS_MIPSR4000),
    MIPSFPU16("MIPSFPU16", 1126, Processor.MIPS_MIPSR4000),
    AXP64("AXP64", 644, Processor.UNKNOWN),
    TRICORE("Infineon", 1312, Processor.TRICORE),
    CEF("CEF", 3311, Processor.UNKNOWN),
    EBC("EFI Byte Code", 3772, Processor.EBC),
    AMD64("AMD64 (K8)", 34404, Processor.X64_AMD64),
    M32R("M32R little-endian", 36929, Processor.M32R),
    ARM64("ARM64 Little-Endian", 43620, Processor.ARM64),
    CEE("CEE", 49390, Processor.CEE);

    private static final Map<Integer, ImageFileMachine> BY_VALUE;
    private final String label;
    private final int value;
    private Processor processor;

    public String toString() {
        return this.label;
    }

    public static ImageFileMachine fromValue(int val) {
        return BY_VALUE.getOrDefault(val, UNKNOWN);
    }

    public Processor getProcessor() {
        return this.processor;
    }

    private ImageFileMachine(String label, int value, Processor processor) {
        this.label = label;
        this.value = value;
        this.processor = processor;
    }

    static {
        BY_VALUE = new HashMap<Integer, ImageFileMachine>();
        for (ImageFileMachine val : ImageFileMachine.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

