/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractTypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.ItemProgramInterfaceParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.NameTable;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfoParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbIdentifiers;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderMetrics;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.Processor;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolRecords;
import ghidra.app.util.bin.format.pdb2.pdbreader.TPI;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeProgramInterfaceParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPdb
implements AutoCloseable {
    private static final int PDB_DIRECTORY_STREAM_NUMBER = 1;
    private static final int VERSION_NUMBER_SIZE = 4;
    private static final int MINIMAL_DEBUG_INFO_PARAM = 1229867341;
    private static final int NO_TYPE_MERGE_PARAM = 1297370958;
    protected AbstractMsf msf;
    protected PdbReaderOptions readerOptions;
    protected int versionNumber = 0;
    protected int signature = 0;
    protected int pdbAge = 0;
    protected int dbiAge = 0;
    protected AbstractTypeProgramInterface typeProgramInterface;
    protected PdbDebugInfo debugInfo;
    protected Processor targetProcessor = Processor.UNKNOWN;
    protected boolean minimalDebugInfo = false;
    protected boolean noTypeMerge = false;
    protected boolean hasIdStream = false;
    protected List<String> strings;
    protected List<Integer> parameters;
    protected NameTable nameTable;
    protected AbstractTypeProgramInterface itemProgramInterface;
    protected GUID guid;
    protected boolean substreamsDeserialized = false;
    private TypeParser typeParser;
    private SymbolParser symbolParser;
    private PdbReaderMetrics pdbReaderMetrics = new PdbReaderMetrics(this);

    public PdbReaderMetrics getPdbReaderMetrics() {
        return this.pdbReaderMetrics;
    }

    public int parseSegment(PdbByteReader reader) throws PdbException {
        int segment = reader.parseUnsignedShortVal();
        this.pdbReaderMetrics.witnessedSectionSegmentNumber(segment);
        return segment;
    }

    @Override
    public void close() throws IOException {
        if (this.msf != null) {
            this.msf.close();
        }
    }

    public PdbReaderOptions getPdbReaderOptions() {
        return this.readerOptions;
    }

    public PdbIdentifiers getIdentifiers() throws IOException, PdbException {
        this.parseDBI();
        if (this.debugInfo != null) {
            try {
                this.debugInfo.deserialize(true, TaskMonitor.DUMMY);
            }
            catch (CancelledException e) {
                throw new AssertException((Throwable)e);
            }
        }
        int age = this.pdbAge;
        if (this.dbiAge > 0) {
            age = this.dbiAge;
        }
        return new PdbIdentifiers(this.versionNumber, this.signature, age, this.guid, this.targetProcessor);
    }

    public void deserialize(TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        if (this.msf == null) {
            return;
        }
        this.deserializeDirectory(monitor);
        this.deserializeSubstreams(monitor);
        PdbLog.message(this.pdbReaderMetrics::getPostProcessingReport);
    }

    public TypeParser getTypeParser() {
        return this.typeParser;
    }

    public SymbolParser getSymbolParser() {
        return this.symbolParser;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public int getSignature() {
        return this.signature;
    }

    public int getAge() {
        return this.pdbAge;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public boolean isDeserialized() {
        return this.substreamsDeserialized;
    }

    public Processor getTargetProcessor() {
        return this.targetProcessor;
    }

    public boolean hasMinimalDebugInfo() {
        return this.minimalDebugInfo;
    }

    public void setTargetProcessor(Processor targetProcessorIn) {
        if (this.targetProcessor == Processor.UNKNOWN) {
            this.targetProcessor = targetProcessorIn;
        }
    }

    void setDbiAge(int dbiAge) {
        this.dbiAge = dbiAge;
    }

    public AbstractTypeProgramInterface getTypeProgramInterface() {
        return this.typeProgramInterface;
    }

    public AbstractTypeProgramInterface getItemProgramInterface() {
        return this.itemProgramInterface;
    }

    public PdbDebugInfo getDebugInfo() {
        return this.debugInfo;
    }

    public SymbolRecords getSymbolRecords() {
        return this.debugInfo.getSymbolRecords();
    }

    public AbstractMsType getTypeRecord(RecordNumber recordNumber) {
        return this.getTypeRecord(recordNumber, AbstractMsType.class);
    }

    public <T extends AbstractMsType> T getTypeRecord(RecordNumber recordNumber, Class<T> typeClass) {
        AbstractMsType msType = this.getTPI((recordNumber = this.fixupTypeIndex(recordNumber, typeClass)).getCategory()).getRecord(recordNumber.getNumber());
        if (!typeClass.isInstance(msType)) {
            if (!recordNumber.isNoType()) {
                PdbLog.logGetTypeClassMismatch(msType, typeClass);
            }
            return null;
        }
        return (T)((AbstractMsType)typeClass.cast(msType));
    }

    RecordNumber fixupTypeIndex(RecordNumber recordNumber, Class<?> typeClass) {
        if (recordNumber.getNumber() < 0) {
            int newNumber = recordNumber.getNumber() & Integer.MAX_VALUE;
            switch (recordNumber.getCategory()) {
                case TYPE: {
                    return RecordNumber.itemRecordNumber(newNumber);
                }
                case ITEM: {
                    return RecordNumber.typeRecordNumber(newNumber);
                }
            }
        }
        return recordNumber;
    }

    private TPI getTPI(RecordCategory category) {
        switch (category) {
            case TYPE: {
                return this.typeProgramInterface;
            }
            case ITEM: {
                return this.itemProgramInterface;
            }
        }
        return null;
    }

    public String getNameFromNameIndex(int index) {
        return this.nameTable.getNameFromStreamNumber(index);
    }

    public int getNameIndexFromName(String name) {
        return this.nameTable.getStreamNumberFromName(name);
    }

    public String getNameStringFromOffset(int offset) {
        return this.nameTable.getNameStringFromOffset(offset);
    }

    static int getVersionNumberSize() {
        return 4;
    }

    static int deserializeVersionNumber(AbstractMsf msf, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        MsfStream directoryStream = msf.getStream(1);
        if (directoryStream.getLength() < AbstractPdb.getVersionNumberSize()) {
            throw new PdbException("Directory Stream too short");
        }
        byte[] bytes = directoryStream.read(0, AbstractPdb.getVersionNumberSize(), monitor);
        PdbByteReader pdbDirectoryReader = new PdbByteReader(bytes);
        return pdbDirectoryReader.parseInt();
    }

    AbstractPdb(AbstractMsf msf, PdbReaderOptions readerOptions) throws IOException, PdbException {
        this.msf = msf;
        this.readerOptions = readerOptions;
        this.strings = new ArrayList<String>();
        this.parameters = new ArrayList<Integer>();
        this.nameTable = new NameTable(this);
        this.typeParser = new TypeParser(this);
        this.symbolParser = new SymbolParser(this);
    }

    abstract void deserializeIdentifiersOnly(TaskMonitor var1) throws IOException, PdbException, CancelledException;

    AbstractMsf getMsf() {
        return this.msf;
    }

    void deserializeSubstreams(TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        if (this.substreamsDeserialized) {
            return;
        }
        TypeProgramInterfaceParser tpiParser = new TypeProgramInterfaceParser();
        this.typeProgramInterface = tpiParser.parse(this, monitor);
        if (this.typeProgramInterface != null) {
            this.typeProgramInterface.deserialize(monitor);
        }
        boolean ipiStreamHasNoName = ItemProgramInterfaceParser.hackCheckNoNameForStream(this.nameTable);
        this.pdbReaderMetrics.witnessIpiDetection(ipiStreamHasNoName, this.hasIdStream);
        if (this.hasIdStream || ipiStreamHasNoName) {
            ItemProgramInterfaceParser ipiParser = new ItemProgramInterfaceParser();
            this.itemProgramInterface = ipiParser.parse(this, monitor);
            if (this.itemProgramInterface != null) {
                this.itemProgramInterface.deserialize(monitor);
            }
        }
        this.parseDBI();
        if (this.debugInfo != null) {
            this.debugInfo.deserialize(false, monitor);
        }
        this.substreamsDeserialized = true;
    }

    private PdbDebugInfo parseDBI() throws IOException, PdbException {
        if (this.debugInfo == null) {
            PdbDebugInfoParser dbiParser = new PdbDebugInfoParser();
            this.debugInfo = dbiParser.parse(this);
        }
        return this.debugInfo;
    }

    PdbByteReader getReaderForStreamNumber(int streamNumber, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getReaderForStreamNumber(streamNumber, 0, Integer.MAX_VALUE, monitor);
    }

    PdbByteReader getReaderForStreamNumber(int streamNumber, int streamOffset, int numToRead, TaskMonitor monitor) throws IOException, CancelledException {
        MsfStream stream = this.msf.getStream(streamNumber);
        numToRead = Math.min(numToRead, stream.getLength());
        byte[] bytes = stream.read(streamOffset, numToRead, monitor);
        PdbByteReader reader = new PdbByteReader(bytes);
        return reader;
    }

    String dumpStream(int streamNumber, int maxOut) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.msf.getStream(streamNumber).dump(maxOut));
        return builder.toString();
    }

    abstract void deserializeDirectory(TaskMonitor var1) throws IOException, PdbException, CancelledException;

    public abstract void dumpDirectory(Writer var1) throws IOException;

    protected PdbByteReader getDirectoryReader(TaskMonitor monitor) throws IOException, CancelledException {
        return this.getReaderForStreamNumber(1, 0, Integer.MAX_VALUE, monitor);
    }

    protected void deserializeVersionSignatureAge(PdbByteReader reader) throws PdbException {
        this.versionNumber = reader.parseInt();
        this.signature = reader.parseInt();
        this.pdbAge = reader.parseInt();
    }

    protected String dumpVersionSignatureAge() {
        StringBuilder builder = new StringBuilder();
        builder.append("DirectoryHeader---------------------------------------------");
        builder.append("\nversionNumber: ");
        builder.append(this.versionNumber);
        builder.append("\nsignature: ");
        builder.append(Integer.toHexString(this.signature));
        builder.append("\nage: ");
        builder.append(this.pdbAge);
        return builder.toString();
    }

    protected void deserializeParameters(PdbByteReader reader, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        this.nameTable.deserializeDirectory(reader, monitor);
        while (reader.hasMore()) {
            monitor.checkCanceled();
            int val = reader.parseInt();
            this.parameters.add(val);
        }
        for (int param : this.parameters) {
            monitor.checkCanceled();
            if (param == 1229867341) {
                this.minimalDebugInfo = true;
                continue;
            }
            if (param == 1297370958) {
                this.noTypeMerge = true;
                continue;
            }
            if (param < 20091201) continue;
            this.hasIdStream = true;
        }
    }

    protected String dumpParameters() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.nameTable.dump());
        builder.append("\nParameters--------------------------------------------------\n");
        for (int i = 0; i < this.parameters.size(); ++i) {
            builder.append(String.format("parameter[%d]: 0x%08x %d\n", i, this.parameters.get(i), this.parameters.get(i)));
        }
        builder.append("Booleans----------------------------------------------------");
        builder.append("\nminimalDebugInfo: ");
        builder.append(this.minimalDebugInfo);
        builder.append("\nnoTypeMerge: ");
        builder.append(this.noTypeMerge);
        builder.append("\nhasIdStream: ");
        builder.append(this.hasIdStream);
        builder.append("\n");
        return builder.toString();
    }

    public void dumpSubStreams(Writer writer) throws IOException {
        writer.write("SubStreams--------------------------------------------------\n");
        if (this.typeProgramInterface != null) {
            writer.write("TypeProgramInterface----------------------------------------\n");
            this.typeProgramInterface.dump(writer);
            writer.write("End TypeProgramInterface------------------------------------\n");
            writer.write("\n");
        }
        if (this.itemProgramInterface != null) {
            writer.write("ItemProgramInterface----------------------------------------\n");
            this.itemProgramInterface.dump(writer);
            writer.write("End ItemProgramInterface------------------------------------\n");
        }
        if (this.debugInfo != null) {
            writer.write("DebugInfo---------------------------------------------------\n");
            this.debugInfo.dump(writer);
            writer.write("End DebugInfo-----------------------------------------------\n");
        }
    }
}

