/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.actions.KeyBindingUtils;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.dialog.AbstractDetailsPanel;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginStatus;
import java.awt.Color;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class PluginDetailsPanel
extends AbstractDetailsPanel {
    private SimpleAttributeSet nameAttrSet;
    private SimpleAttributeSet depNameAttrSet;
    private SimpleAttributeSet descrAttrSet;
    private SimpleAttributeSet categoriesAttrSet;
    private SimpleAttributeSet classAttrSet;
    private SimpleAttributeSet locAttrSet;
    private SimpleAttributeSet developerAttrSet;
    private SimpleAttributeSet dependencyAttrSet;
    private SimpleAttributeSet noValueAttrSet;
    private final PluginConfigurationModel model;

    PluginDetailsPanel(PluginConfigurationModel model) {
        this.model = model;
        this.createFieldAttributes();
        this.createMainPanel();
    }

    void setPluginDescription(PluginDescription descriptor) {
        this.textLabel.setText("");
        if (descriptor == null) {
            return;
        }
        List<PluginDescription> dependencies = this.model.getDependencies(descriptor);
        Collections.sort(dependencies, (pd1, pd2) -> pd1.getName().compareTo(pd2.getName()));
        StringBuilder buffer = new StringBuilder("<HTML>");
        buffer.append("<TABLE cellpadding=2>");
        this.insertRowTitle(buffer, "Name");
        this.insertRowValue(buffer, descriptor.getName(), !dependencies.isEmpty() ? this.depNameAttrSet : this.nameAttrSet);
        this.insertRowTitle(buffer, "Description");
        this.insertRowValue(buffer, descriptor.getDescription(), this.descrAttrSet);
        this.insertRowTitle(buffer, "Status");
        this.insertRowValue(buffer, descriptor.getStatus().getDescription(), descriptor.getStatus() == PluginStatus.RELEASED ? titleAttrSet : this.developerAttrSet);
        this.insertRowTitle(buffer, "Package");
        this.insertRowValue(buffer, descriptor.getPluginPackage().getName(), this.categoriesAttrSet);
        this.insertRowTitle(buffer, "Category");
        this.insertRowValue(buffer, descriptor.getCategory(), this.categoriesAttrSet);
        this.insertRowTitle(buffer, "Plugin Class");
        this.insertRowValue(buffer, descriptor.getPluginClass().getName(), this.classAttrSet);
        this.insertRowTitle(buffer, "Class Location");
        this.insertRowValue(buffer, descriptor.getSourceLocation(), this.locAttrSet);
        this.insertRowTitle(buffer, "Used By");
        buffer.append("<TD VALIGN=\"TOP\">");
        if (dependencies.isEmpty()) {
            this.insertHTMLLine(buffer, "None", this.noValueAttrSet);
        } else {
            for (int i = 0; i < dependencies.size(); ++i) {
                this.insertHTMLString(buffer, dependencies.get(i).getPluginClass().getName(), this.dependencyAttrSet);
                if (i >= dependencies.size() - 1) continue;
                buffer.append("<BR>");
            }
            this.insertHTMLLine(buffer, "", titleAttrSet);
        }
        buffer.append("</TD>");
        buffer.append("</TR>");
        this.insertRowTitle(buffer, "Services Required");
        buffer.append("<TD VALIGN=\"TOP\">");
        List<Class<?>> servicesRequired = descriptor.getServicesRequired();
        if (servicesRequired.isEmpty()) {
            this.insertHTMLLine(buffer, "None", this.noValueAttrSet);
        } else {
            for (int i = 0; i < servicesRequired.size(); ++i) {
                this.insertHTMLString(buffer, servicesRequired.get(i).getName(), this.dependencyAttrSet);
                if (i >= servicesRequired.size() - 1) continue;
                buffer.append("<BR>");
            }
            this.insertHTMLLine(buffer, "", titleAttrSet);
        }
        buffer.append("</TD>");
        buffer.append("</TR>");
        this.addLoadedActionsContent(buffer, descriptor);
        buffer.append("</TABLE>");
        this.textLabel.setText(buffer.toString());
        this.sp.getViewport().setViewPosition(new Point(0, 0));
    }

    private void addLoadedActionsContent(StringBuilder buffer, PluginDescription pluginDescription) {
        if (!this.model.isLoaded(pluginDescription)) {
            return;
        }
        buffer.append("<TR>");
        buffer.append("<TD VALIGN=\"TOP\">");
        this.insertHTMLLine(buffer, "Loaded Actions:", titleAttrSet);
        buffer.append("</TD>");
        Set<DockingActionIf> actions = this.model.getActionsForPlugin(pluginDescription);
        if (actions.size() == 0) {
            buffer.append("<TD VALIGN=\"TOP\">");
            this.insertHTMLLine(buffer, "No actions for plugin", this.noValueAttrSet);
            buffer.append("</TD>");
            buffer.append("</TR>");
            return;
        }
        buffer.append("<TD VALIGN=\"TOP\">");
        buffer.append("<TABLE BORDER=1><TR><TH>Action Name</TH><TH>Menu Path</TH><TH>Keybinding</TH></TR>");
        for (DockingActionIf dockableAction : actions) {
            buffer.append("<TR><TD WIDTH=\"200\">");
            this.insertHTMLString(buffer, dockableAction.getName(), this.locAttrSet);
            buffer.append("</TD>");
            buffer.append("<TD WIDTH=\"300\">");
            MenuData menuBarData = dockableAction.getMenuBarData();
            String[] menuPath = menuBarData == null ? null : menuBarData.getMenuPath();
            String menuPathString = this.createStringForMenuPath(menuPath);
            if (menuPathString != null) {
                this.insertHTMLString(buffer, menuPathString, this.locAttrSet);
            } else {
                String[] popupPath;
                MenuData popupMenuData = dockableAction.getPopupMenuData();
                String[] stringArray = popupPath = popupMenuData == null ? null : popupMenuData.getMenuPath();
                if (popupPath != null) {
                    this.insertHTMLString(buffer, "(in a context popup menu)", this.noValueAttrSet);
                } else {
                    this.insertHTMLString(buffer, "Not in a menu", this.noValueAttrSet);
                }
            }
            buffer.append("</TD>");
            buffer.append("<TD WIDTH=\"100\">");
            KeyStroke keyBinding = dockableAction.getKeyBinding();
            if (keyBinding != null) {
                String keyStrokeString = KeyBindingUtils.parseKeyStroke((KeyStroke)keyBinding);
                this.insertHTMLString(buffer, keyStrokeString, this.locAttrSet);
            } else {
                this.insertHTMLString(buffer, "No keybinding", this.noValueAttrSet);
            }
            buffer.append("</TD></TR>");
        }
        buffer.append("</TABLE>");
        buffer.append("</TD>");
        buffer.append("</TR>");
    }

    private String createStringForMenuPath(String[] path) {
        if (path == null) {
            return null;
        }
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            buffy.append(path[i].replaceAll("\\&", ""));
            if (i == path.length - 1) continue;
            buffy.append("->");
        }
        return buffy.toString();
    }

    @Override
    protected void createFieldAttributes() {
        titleAttrSet = new SimpleAttributeSet();
        titleAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        titleAttrSet.addAttribute(StyleConstants.FontSize, 11);
        titleAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        titleAttrSet.addAttribute(StyleConstants.Foreground, new Color(140, 0, 0));
        this.nameAttrSet = new SimpleAttributeSet();
        this.nameAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.nameAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.nameAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.nameAttrSet.addAttribute(StyleConstants.Foreground, new Color(0, 204, 51));
        this.depNameAttrSet = new SimpleAttributeSet();
        this.depNameAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.depNameAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.depNameAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.depNameAttrSet.addAttribute(StyleConstants.Foreground, Color.RED);
        this.descrAttrSet = new SimpleAttributeSet();
        this.descrAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.descrAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.descrAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.descrAttrSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        this.categoriesAttrSet = new SimpleAttributeSet();
        this.categoriesAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.categoriesAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.categoriesAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.categoriesAttrSet.addAttribute(StyleConstants.Foreground, new Color(204, 0, 204));
        this.classAttrSet = new SimpleAttributeSet();
        this.classAttrSet.addAttribute(StyleConstants.FontFamily, "monospaced");
        this.classAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.classAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.classAttrSet.addAttribute(StyleConstants.Foreground, Color.BLACK);
        this.locAttrSet = new SimpleAttributeSet();
        this.locAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.locAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.locAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.locAttrSet.addAttribute(StyleConstants.Foreground, Color.DARK_GRAY);
        this.developerAttrSet = new SimpleAttributeSet();
        this.developerAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.developerAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.developerAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.developerAttrSet.addAttribute(StyleConstants.Foreground, new Color(230, 15, 85));
        this.dependencyAttrSet = new SimpleAttributeSet();
        this.dependencyAttrSet.addAttribute(StyleConstants.FontFamily, "monospaced");
        this.dependencyAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.dependencyAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.dependencyAttrSet.addAttribute(StyleConstants.Foreground, new Color(23, 100, 30));
        this.noValueAttrSet = new SimpleAttributeSet();
        this.noValueAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.noValueAttrSet.addAttribute(StyleConstants.FontSize, 11);
        this.noValueAttrSet.addAttribute(StyleConstants.Italic, Boolean.TRUE);
        this.noValueAttrSet.addAttribute(StyleConstants.Foreground, new Color(192, 192, 192));
    }
}

