/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.widgets.label.GDHtmlLabel;
import ghidra.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class AbstractDetailsPanel
extends JPanel {
    private static final int MIN_WIDTH = 700;
    protected static final int LEFT_COLUMN_WIDTH = 150;
    protected static final int RIGHT_MARGIN = 30;
    protected static SimpleAttributeSet titleAttrSet;
    protected JLabel textLabel;
    protected JScrollPane sp;

    protected abstract void createFieldAttributes();

    protected SimpleAttributeSet createAttributeSet(String fontFamily, int fontSize, boolean bold, Color color) {
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        attrSet.addAttribute(StyleConstants.FontFamily, fontFamily);
        attrSet.addAttribute(StyleConstants.FontSize, fontSize);
        attrSet.addAttribute(StyleConstants.Bold, bold);
        attrSet.addAttribute(StyleConstants.Foreground, color);
        return attrSet;
    }

    protected SimpleAttributeSet createAttributeSet(Color color) {
        SimpleAttributeSet attrSet = new SimpleAttributeSet();
        attrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        attrSet.addAttribute(StyleConstants.FontSize, 11);
        attrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        attrSet.addAttribute(StyleConstants.Foreground, color);
        return attrSet;
    }

    protected void clear() {
        this.textLabel.setText("");
    }

    protected void createMainPanel() {
        this.setLayout(new BorderLayout());
        this.textLabel = new GDHtmlLabel(){

            public Dimension getPreferredSize() {
                Dimension mySize = super.getPreferredSize();
                int rightColumnWidth = AbstractDetailsPanel.this.getWidth() - 150;
                mySize.width = Math.max(700, rightColumnWidth);
                return mySize;
            }
        };
        this.textLabel.setVerticalAlignment(1);
        this.textLabel.setOpaque(true);
        this.textLabel.setBackground(Color.WHITE);
        this.sp = new JScrollPane(this.textLabel);
        this.sp.getVerticalScrollBar().setUnitIncrement(10);
        this.sp.setPreferredSize(new Dimension(700, 200));
        this.add((Component)this.sp, "Center");
    }

    protected void insertRowTitle(StringBuilder buffer, String rowName) {
        buffer.append("<TR>");
        buffer.append("<TD VALIGN=\"TOP\">");
        this.insertHTMLLine(buffer, rowName + ":", titleAttrSet);
        buffer.append("</TD>");
    }

    protected void insertRowValue(StringBuilder buffer, String value, SimpleAttributeSet attributes) {
        buffer.append("<TD VALIGN=\"TOP\" WIDTH=\"80%\">");
        this.insertHTMLLine(buffer, value, attributes);
        buffer.append("</TD>");
        buffer.append("</TR>");
    }

    protected void insertHTMLString(StringBuilder buffer, String string, SimpleAttributeSet attributes) {
        if (string == null) {
            return;
        }
        buffer.append("<FONT COLOR=\"");
        Color foregroundColor = (Color)attributes.getAttribute(StyleConstants.Foreground);
        buffer.append(HTMLUtilities.toHexString((Color)foregroundColor));
        buffer.append("\" FACE=\"");
        buffer.append(attributes.getAttribute(StyleConstants.FontFamily).toString());
        buffer.append("\">");
        Boolean isBold = (Boolean)attributes.getAttribute(StyleConstants.Bold);
        isBold = isBold == null ? Boolean.FALSE : isBold;
        String text = HTMLUtilities.escapeHTML((String)string);
        if (isBold.booleanValue()) {
            text = HTMLUtilities.bold((String)text);
        }
        buffer.append(text);
        buffer.append("</FONT>");
    }

    protected void insertHTMLLine(StringBuilder buffer, String string, SimpleAttributeSet attributes) {
        if (string == null) {
            return;
        }
        this.insertHTMLString(buffer, string, attributes);
        buffer.append("<BR>");
    }
}

