/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.main.datatree.CheckoutDialog;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.remote.User;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.WrappingTaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class VersionControlCheckOutAction
extends VersionControlAction {
    public VersionControlCheckOutAction(Plugin plugin) {
        this(plugin.getName(), plugin.getTool());
    }

    VersionControlCheckOutAction(String owner, PluginTool tool) {
        super("CheckOut", owner, tool);
        ImageIcon icon = ResourceManager.loadImage((String)"images/vcCheckOut.png");
        this.setPopupMenuData(new MenuData(new String[]{"Check Out"}, (Icon)icon, "Repository"));
        this.setToolBarData(new ToolBarData((Icon)icon, "Repository"));
        this.setDescription("Check out file");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileContext context) {
        this.checkOut(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileContext context) {
        if (this.isFileSystemBusy()) {
            return false;
        }
        List<DomainFile> providedList = context.getSelectedFiles();
        for (DomainFile domainFile : providedList) {
            if (!domainFile.canCheckout()) continue;
            return true;
        }
        return false;
    }

    private User getUser() {
        try {
            if (this.repository != null) {
                return this.repository.getUser();
            }
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Check Out", (Component)this.tool.getToolFrame());
        }
        return null;
    }

    protected void checkOut(Collection<DomainFile> files) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        this.tool.execute(new CheckOutTask(files));
    }

    private class CheckOutTask
    extends Task {
        private Collection<DomainFile> files;
        private boolean exclusive;
        private CheckoutDialog checkout;

        CheckOutTask(Collection<DomainFile> files) {
            super("Check Out", true, true, true);
            this.exclusive = true;
            this.files = files;
        }

        private boolean gatherVersionedFiles(TaskMonitor monitor, List<DomainFile> results) throws CancelledException {
            monitor.setMessage("Examining Files...");
            monitor.setMaximum((long)this.files.size());
            for (DomainFile df : this.files) {
                monitor.checkCanceled();
                if (df.isVersioned() && !df.isCheckedOut()) {
                    results.add(df);
                }
                monitor.incrementProgress(1L);
            }
            int n = results.size();
            if (n == 0) {
                Msg.showError((Object)((Object)this), (Component)VersionControlCheckOutAction.this.tool.getToolFrame(), (String)"Checkout Failed", (Object)"The specified files do not contain any versioned files available for checkeout");
                return false;
            }
            User user = VersionControlCheckOutAction.this.getUser();
            if (user != null && user.hasWritePermission()) {
                this.checkout = (CheckoutDialog)((Object)Swing.runNow(() -> new CheckoutDialog()));
                if (this.checkout.showDialog(VersionControlCheckOutAction.this.tool) != 0) {
                    return false;
                }
                this.exclusive = this.checkout.exclusiveCheckout();
                return true;
            }
            if (n == 1) {
                return true;
            }
            int choice = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)VersionControlCheckOutAction.this.tool.getToolFrame(), (String)"Confirm Bulk Checkout", (String)("Would you like to checkout " + results.size() + " files as specified?"));
            return choice == 1;
        }

        public void run(TaskMonitor monitor) {
            try {
                ArrayList<DomainFile> versionedFiles = new ArrayList<DomainFile>();
                if (!this.gatherVersionedFiles(monitor, versionedFiles)) {
                    return;
                }
                monitor.setMaximum(0L);
                monitor.setProgress(0L);
                WrappingTaskMonitor wrappedMonitor = new WrappingTaskMonitor(monitor){

                    public void setMessage(String message) {
                    }
                };
                ArrayList<DomainFile> failedCheckouts = new ArrayList<DomainFile>();
                int progress = 0;
                for (DomainFile df : versionedFiles) {
                    monitor.checkCanceled();
                    monitor.setMessage("Checkout " + progress + " of " + versionedFiles.size() + ": " + df.getName());
                    if (!df.checkout(this.exclusive, (TaskMonitor)wrappedMonitor)) {
                        failedCheckouts.add(df);
                    }
                    ++progress;
                }
                this.showResultsMessage(versionedFiles, failedCheckouts);
            }
            catch (CancelledException e) {
                VersionControlCheckOutAction.this.tool.setStatusInfo("Checkout cancelled");
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)VersionControlCheckOutAction.this.repository, (Exception)e, (String)"Check Out", (Component)VersionControlCheckOutAction.this.tool.getToolFrame());
            }
        }

        private void showResultsMessage(List<DomainFile> allFiles, List<DomainFile> failedFiles) {
            int total = allFiles.size();
            if (failedFiles.isEmpty()) {
                String s = "Checkout completed for " + total + " file(s)";
                VersionControlCheckOutAction.this.tool.setStatusInfo(s);
                Msg.info((Object)((Object)this), (Object)s);
                return;
            }
            if (failedFiles.size() == 1) {
                DomainFile df = failedFiles.get(0);
                String s = "Exclusive checkout failed for: " + df.getName() + "\nOne or more users have file checked out!";
                Msg.showError((Object)((Object)this), (Component)VersionControlCheckOutAction.this.tool.getToolFrame(), (String)"Checkout Failed", (Object)s);
                return;
            }
            String userMessage = "Multiple exclusive checkouts failed.\nOne or more users have file checked out!";
            StringBuilder buffy = new StringBuilder(userMessage + "\n");
            String message = "Exclusive checkout failed for: %s";
            for (DomainFile df : failedFiles) {
                String formatted = String.format(message, df.getName());
                buffy.append(formatted).append('\n');
            }
            Msg.showError((Object)((Object)this), (Component)VersionControlCheckOutAction.this.tool.getToolFrame(), (String)"Checkout Failed", (Object)(userMessage + "\n(see log for list of failed files)"));
        }
    }
}

